/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class NaturePowerFX
extends EntityFX {
    public static final ResourceLocation particles = new ResourceLocation("witchery:textures/particle/power.png");
    private boolean canMove = false;
    private boolean circling = false;

    public NaturePowerFX(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.noClip = true;
    }

    public void renderParticle(Tessellator tess, float partialTicks, float par3, float par4, float par5, float par6, float par7) {
        Minecraft.getMinecraft().renderEngine.bindTexture(particles);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        tess.startDrawingQuads();
        tess.setBrightness(this.getBrightnessForRender(partialTicks));
        int typeIndex = 0;
        int par1 = typeIndex + this.particleAge * 8 / 20 % 16;
        par1 = par1 > 7 ? 15 - par1 : par1;
        int particleTextureIndexX = par1 % 16;
        int particleTextureIndexY = par1 / 16;
        float f6 = (float)particleTextureIndexX / 16.0f;
        float f7 = f6 + 0.0624375f;
        float f8 = (float)particleTextureIndexY / 16.0f;
        float f9 = f8 + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        float x = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks - interpPosX);
        float y = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks - interpPosY);
        float z = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks - interpPosZ);
        tess.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, 1.0f);
        tess.addVertexWithUV((double)(x - par3 * scale - par6 * scale), (double)(y - par4 * scale), (double)(z - par5 * scale - par7 * scale), (double)f7, (double)f9);
        tess.addVertexWithUV((double)(x - par3 * scale + par6 * scale), (double)(y + par4 * scale), (double)(z - par5 * scale + par7 * scale), (double)f7, (double)f8);
        tess.addVertexWithUV((double)(x + par3 * scale + par6 * scale), (double)(y + par4 * scale), (double)(z + par5 * scale + par7 * scale), (double)f6, (double)f8);
        tess.addVertexWithUV((double)(x + par3 * scale - par6 * scale), (double)(y - par4 * scale), (double)(z + par5 * scale - par7 * scale), (double)f6, (double)f9);
        tess.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    public void onUpdate() {
        if (!this.worldObj.isRemote) {
            this.setDead();
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= Math.min(this.particleMaxAge, 600) || this.particleAge < 0) {
            this.setDead();
        } else if ((double)this.particleAge > (double)this.particleMaxAge * 0.9) {
            this.noClip = false;
        }
        if (!this.isDead && this.canMove) {
            if (this.circling) {
                Vec3 motion = Vec3.createVectorHelper((double)this.motionX, (double)this.motionY, (double)this.motionZ);
                motion.rotateAroundY(0.5f);
                this.motionX = motion.xCoord *= 1.08;
                this.motionY = motion.yCoord *= 0.85;
                this.motionZ = motion.zCoord *= 1.08;
            } else {
                this.motionY -= 0.04 * (double)this.particleGravity;
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
            }
        }
    }

    public int getFXLayer() {
        return 3;
    }

    public NaturePowerFX setMaxAge(int maxAge) {
        this.particleMaxAge = maxAge;
        return this;
    }

    public NaturePowerFX setGravity(float gravity) {
        this.particleGravity = gravity;
        return this;
    }

    public NaturePowerFX setCanMove(boolean canMove) {
        this.canMove = canMove;
        return this;
    }

    public NaturePowerFX setScale(float scale) {
        this.particleScale = scale;
        return this;
    }

    public NaturePowerFX setCircling(boolean circling) {
        this.circling = circling;
        return this;
    }
}

