/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.model;

import com.emoniph.witchery.entity.EntityOwl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelOwl
extends ModelBase {
    ModelRenderer head;
    ModelRenderer body;
    ModelRenderer rightarm;
    ModelRenderer leftarm;
    ModelRenderer rightleg;
    ModelRenderer leftleg;

    public ModelOwl() {
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.setTextureOffset("head.beak", 30, 0);
        this.setTextureOffset("head.hornRight", 37, 0);
        this.setTextureOffset("head.hornLeft", 37, 0);
        this.setTextureOffset("head.head1", 0, 0);
        this.head = new ModelRenderer((ModelBase)this, "head");
        this.head.setRotationPoint(0.0f, 15.0f, 0.0f);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        this.head.mirror = true;
        this.head.addBox("hornRight", -5.0f, -7.0f, -1.0f, 1, 3, 2);
        this.head.addBox("hornLeft", 4.0f, -7.0f, -1.0f, 1, 3, 2);
        this.head.addBox("beak", -1.0f, -3.0f, -4.0f, 2, 3, 1);
        this.head.addBox("head1", -4.0f, -6.0f, -3.0f, 8, 6, 6);
        this.body = new ModelRenderer((ModelBase)this, 16, 16);
        this.body.addBox(-3.0f, 0.0f, -2.0f, 6, 8, 4);
        this.body.setRotationPoint(0.0f, 15.0f, 0.0f);
        this.body.setTextureSize(64, 32);
        this.body.mirror = true;
        this.setRotation(this.body, 0.0f, 0.0f, 0.0f);
        this.rightarm = new ModelRenderer((ModelBase)this, 40, 16);
        this.rightarm.addBox(-1.0f, -1.0f, -2.0f, 1, 8, 4);
        this.rightarm.setRotationPoint(-3.0f, 16.0f, 0.0f);
        this.rightarm.setTextureSize(64, 32);
        this.rightarm.mirror = true;
        this.setRotation(this.rightarm, 0.0f, 0.0f, 0.0f);
        this.leftarm = new ModelRenderer((ModelBase)this, 40, 16);
        this.leftarm.addBox(0.0f, -1.0f, -2.0f, 1, 8, 4);
        this.leftarm.setRotationPoint(3.0f, 16.0f, 0.0f);
        this.leftarm.setTextureSize(64, 32);
        this.leftarm.mirror = true;
        this.setRotation(this.leftarm, 0.0f, 0.0f, 0.0f);
        this.rightleg = new ModelRenderer((ModelBase)this, 0, 16);
        this.rightleg.addBox(-1.0f, 0.0f, -2.0f, 2, 1, 4);
        this.rightleg.setRotationPoint(-2.0f, 23.0f, -1.0f);
        this.rightleg.setTextureSize(64, 32);
        this.rightleg.mirror = true;
        this.setRotation(this.rightleg, 0.0f, 0.0f, 0.0f);
        this.leftleg = new ModelRenderer((ModelBase)this, 0, 16);
        this.leftleg.addBox(-1.0f, 0.0f, -2.0f, 2, 1, 4);
        this.leftleg.setRotationPoint(2.0f, 23.0f, -1.0f);
        this.leftleg.setTextureSize(64, 32);
        this.leftleg.mirror = true;
        this.setRotation(this.leftleg, 0.0f, 0.0f, 0.0f);
        this.rightleg.setRotationPoint(-2.0f, 8.0f, -1.0f);
        this.leftleg.setRotationPoint(2.0f, 8.0f, -1.0f);
        this.body.addChild(this.leftleg);
        this.body.addChild(this.rightleg);
    }

    public static boolean isLanded(Entity entity) {
        Block block = entity.worldObj.getBlock(MathHelper.floor_double((double)entity.posX), (int)(entity.posY - 0.01), MathHelper.floor_double((double)entity.posZ));
        Material material = block.getMaterial();
        return material == Material.leaves || material.isSolid();
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        EntityOwl entitybat = (EntityOwl)entity;
        if (entity.motionY == 0.0 && entity.motionX == 0.0 && entity.motionZ == 0.0 && ModelOwl.isLanded(entity)) {
            this.body.rotateAngleX = 0.0f;
            this.leftarm.rotateAngleZ = 0.0f;
            this.rightarm.rotateAngleZ = 0.0f;
            this.rightleg.rotateAngleX = 0.0f;
            this.leftleg.rotateAngleX = 0.0f;
        } else {
            float f6 = 57.295776f;
            this.body.rotateAngleX = 0.7853982f + MathHelper.cos((float)(f2 * 0.1f)) * 0.15f;
            this.body.rotateAngleY = 0.0f;
            this.rightleg.rotateAngleX = 0.7853982f + MathHelper.cos((float)(f2 * 0.1f)) * 0.15f;
            this.leftleg.rotateAngleX = 0.7853982f + MathHelper.cos((float)(f2 * 0.1f)) * 0.15f;
            this.rightarm.rotateAngleZ = MathHelper.cos((float)(f2 * 0.5f)) * (float)Math.PI * 0.2f * 2.0f + 1.4f;
            this.leftarm.rotateAngleZ = -this.rightarm.rotateAngleZ;
        }
        if (entitybat.isSitting()) {
            this.rightleg.rotateAngleY = 0.5f;
            this.leftleg.rotateAngleY = -this.rightleg.rotateAngleY;
        } else {
            this.rightleg.rotateAngleY = 0.1f;
            this.leftleg.rotateAngleY = -this.rightleg.rotateAngleY;
        }
        this.head.rotateAngleY = f3 / 57.295776f;
        this.head.rotateAngleX = f4 / 57.295776f;
        if (this.isChild) {
            float p6 = 2.0f;
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.5f / p6), (float)(1.5f / p6), (float)(1.5f / p6));
            GL11.glTranslatef((float)0.0f, (float)(11.0f * f5), (float)0.0f);
            this.head.render(f5);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / p6), (float)(1.0f / p6), (float)(1.0f / p6));
            GL11.glTranslatef((float)0.0f, (float)(24.0f * f5), (float)0.0f);
            this.body.render(f5);
            this.rightarm.render(f5);
            this.leftarm.render(f5);
            GL11.glPopMatrix();
        } else {
            this.head.render(f5);
            this.body.render(f5);
            this.rightarm.render(f5);
            this.leftarm.render(f5);
        }
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    }
}

