/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.model;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityGoblin;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelGoblin
extends ModelBase {
    public ModelRenderer bipedHead;
    public ModelRenderer bipedBody;
    public ModelRenderer bipedRightArm;
    public ModelRenderer bipedLeftArm;
    public ModelRenderer bipedRightLeg;
    public ModelRenderer bipedLeftLeg;
    public int heldItemLeft;
    public int heldItemRight;
    public boolean isSneak;
    public boolean aimedBow;

    public ModelGoblin() {
        this(0.0f);
    }

    public ModelGoblin(float scale) {
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.setTextureOffset("head.face", 0, 0);
        this.setTextureOffset("head.nose1", 34, 3);
        this.setTextureOffset("head.nose2", 34, 0);
        this.setTextureOffset("head.nose3", 33, 9);
        this.setTextureOffset("head.earTipLeft", 46, 0);
        this.setTextureOffset("head.earInnerLeft", 39, 0);
        this.setTextureOffset("head.earInnerRight", 39, 0);
        this.setTextureOffset("head.earTipRight", 46, 0);
        this.bipedHead = new ModelRenderer((ModelBase)this, "head");
        this.bipedHead.setRotationPoint(0.0f, 11.0f, 0.0f);
        this.setRotation(this.bipedHead, 0.0f, 0.0f, 0.0f);
        this.bipedHead.mirror = true;
        this.bipedHead.addBox("face", -4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.bipedHead.addBox("nose1", -0.5f, -6.0f, -5.0f, 1, 3, 1);
        this.bipedHead.addBox("nose2", -0.5f, -5.0f, -6.0f, 1, 1, 1);
        this.bipedHead.addBox("nose3", -0.5f, -4.0f, -7.0f, 1, 2, 2);
        this.bipedHead.addBox("earTipLeft", 6.0f, -7.0f, 0.0f, 2, 2, 1);
        this.bipedHead.addBox("earInnerLeft", 4.0f, -7.0f, 0.0f, 2, 3, 1);
        this.bipedHead.addBox("earInnerRight", -6.0f, -7.0f, 0.0f, 2, 3, 1);
        this.bipedHead.addBox("earTipRight", -8.0f, -7.0f, 0.0f, 2, 2, 1);
        this.bipedBody = new ModelRenderer((ModelBase)this, 16, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 7, 4, scale);
        this.bipedBody.setRotationPoint(0.0f, 11.0f, 0.0f);
        this.bipedBody.setTextureSize(64, 32);
        this.bipedBody.mirror = true;
        this.setRotation(this.bipedBody, 0.0f, 0.0f, 0.0f);
        this.bipedRightArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.bipedRightArm.addBox(-3.0f, -3.0f, -2.0f, 4, 12, 4, scale);
        this.bipedRightArm.setRotationPoint(-5.0f, 12.0f, 0.0f);
        this.bipedRightArm.setTextureSize(64, 32);
        this.bipedRightArm.mirror = true;
        this.setRotation(this.bipedRightArm, 0.0f, 0.0f, 0.0f);
        this.bipedLeftArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.bipedLeftArm.addBox(-1.0f, -3.0f, -2.0f, 4, 12, 4, scale);
        this.bipedLeftArm.setRotationPoint(5.0f, 12.0f, 0.0f);
        this.bipedLeftArm.setTextureSize(64, 32);
        this.bipedLeftArm.mirror = true;
        this.setRotation(this.bipedLeftArm, 0.0f, 0.0f, 0.0f);
        this.bipedRightLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedRightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, scale);
        this.bipedRightLeg.setRotationPoint(-2.0f, 18.0f, 0.0f);
        this.bipedRightLeg.setTextureSize(64, 32);
        this.bipedRightLeg.mirror = true;
        this.setRotation(this.bipedRightLeg, 0.0f, 0.0f, 0.0f);
        this.bipedLeftLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, scale);
        this.bipedLeftLeg.setRotationPoint(2.0f, 18.0f, 0.0f);
        this.bipedLeftLeg.setTextureSize(64, 32);
        this.bipedLeftLeg.mirror = true;
        this.setRotation(this.bipedLeftLeg, 0.0f, 0.0f, 0.0f);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void render(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.setRotationAngles(par2, par3, par4, par5, par6, par7, par1Entity);
        if (this.isChild) {
            float f6 = 2.0f;
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.5f / f6), (float)(1.5f / f6), (float)(1.5f / f6));
            GL11.glTranslatef((float)0.0f, (float)(16.0f * par7), (float)0.0f);
            this.bipedHead.render(par7);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / f6), (float)(1.0f / f6), (float)(1.0f / f6));
            GL11.glTranslatef((float)0.0f, (float)(24.0f * par7), (float)0.0f);
            this.bipedBody.render(par7);
            this.bipedRightArm.render(par7);
            this.bipedLeftArm.render(par7);
            this.bipedRightLeg.render(par7);
            this.bipedLeftLeg.render(par7);
            GL11.glPopMatrix();
        } else {
            this.bipedHead.render(par7);
            this.bipedBody.render(par7);
            this.bipedRightArm.render(par7);
            this.bipedLeftArm.render(par7);
            this.bipedRightLeg.render(par7);
            this.bipedLeftLeg.render(par7);
        }
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, Entity par7Entity) {
        boolean isWorshipping;
        float f7;
        this.bipedHead.rotateAngleY = par4 / 57.295776f;
        this.bipedHead.rotateAngleX = par5 / 57.295776f;
        this.bipedRightArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
        this.bipedLeftArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.0f;
        this.bipedRightLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.bipedRightLeg.rotateAngleY = 0.0f;
        this.bipedLeftLeg.rotateAngleY = 0.0f;
        if (this.isRiding) {
            this.bipedRightArm.rotateAngleX += -0.62831855f;
            this.bipedLeftArm.rotateAngleX += -0.62831855f;
            this.bipedRightLeg.rotateAngleX = -1.2566371f;
            this.bipedLeftLeg.rotateAngleX = -1.2566371f;
            this.bipedRightLeg.rotateAngleY = 0.31415927f;
            this.bipedLeftLeg.rotateAngleY = -0.31415927f;
        }
        if (this.heldItemLeft != 0) {
            this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            EntityGoblin goblin;
            this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemRight;
            if (par7Entity != null && par7Entity instanceof EntityGoblin && (goblin = (EntityGoblin)par7Entity).isWorking()) {
                this.bipedRightArm.rotateAngleX = goblin.getHeldItem() != null && goblin.getHeldItem().getItem() == Witchery.Items.KOBOLDITE_PICKAXE ? (float)((double)this.bipedRightArm.rotateAngleX - (double)(par7Entity.ticksExisted % 6) * 0.3) : (float)((double)this.bipedRightArm.rotateAngleX - (double)(par7Entity.ticksExisted % 20) * 0.1);
            }
        }
        this.bipedRightArm.rotateAngleY = 0.0f;
        this.bipedLeftArm.rotateAngleY = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.bipedBody.rotateAngleY = MathHelper.sin((float)(MathHelper.sqrt_float((float)f6) * (float)Math.PI * 2.0f)) * 0.2f;
            this.bipedRightArm.rotationPointZ = MathHelper.sin((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotationPointX = -MathHelper.cos((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointZ = -MathHelper.sin((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointX = MathHelper.cos((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleX += this.bipedBody.rotateAngleY;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
            float f8 = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -(this.bipedHead.rotateAngleX - 0.7f) * 0.75f;
            this.bipedRightArm.rotateAngleX = (float)((double)this.bipedRightArm.rotateAngleX - ((double)f7 * 1.2 + (double)f8));
            this.bipedRightArm.rotateAngleY += this.bipedBody.rotateAngleY * 2.0f;
            this.bipedRightArm.rotateAngleZ = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -0.4f;
        }
        boolean bl = isWorshipping = par7Entity != null && par7Entity instanceof EntityGoblin && ((EntityGoblin)par7Entity).isWorshipping();
        if (this.isSneak || isWorshipping) {
            this.bipedBody.rotateAngleX = 0.5f;
            this.bipedRightArm.rotateAngleX -= 2.2f;
            this.bipedLeftArm.rotateAngleX -= 2.2f;
            this.bipedRightLeg.rotationPointZ = 3.0f;
            this.bipedLeftLeg.rotationPointZ = 3.0f;
            this.bipedHead.rotateAngleX = 0.5f;
            this.bipedRightLeg.rotationPointY = 18.0f;
            this.bipedLeftLeg.rotationPointY = 18.0f;
            this.bipedHead.rotationPointY = 13.0f;
            this.bipedBody.rotationPointY = 13.0f;
        } else {
            this.bipedBody.rotateAngleX = 0.0f;
            this.bipedRightLeg.rotationPointZ = 0.1f;
            this.bipedLeftLeg.rotationPointZ = 0.1f;
            this.bipedRightLeg.rotationPointY = 18.0f;
            this.bipedLeftLeg.rotationPointY = 18.0f;
            this.bipedHead.rotationPointY = 11.0f;
            this.bipedBody.rotationPointY = 11.0f;
        }
        this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        if (this.aimedBow) {
            float f6 = 0.0f;
            f7 = 0.0f;
            this.bipedRightArm.rotateAngleZ = 0.0f;
            this.bipedLeftArm.rotateAngleZ = 0.0f;
            this.bipedRightArm.rotateAngleY = -(0.1f - f6 * 0.6f) + this.bipedHead.rotateAngleY;
            this.bipedLeftArm.rotateAngleY = 0.1f - f6 * 0.6f + this.bipedHead.rotateAngleY + 0.4f;
            this.bipedRightArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedLeftArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedRightArm.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.bipedLeftArm.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
            this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
            this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
            this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        }
    }
}

