/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.gui;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.client.gui.GuiButtonJumpPage;
import com.emoniph.witchery.client.gui.GuiButtonNextPage;
import com.emoniph.witchery.crafting.BrazierRecipes;
import com.emoniph.witchery.crafting.DistilleryRecipes;
import com.emoniph.witchery.crafting.KettleRecipes;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritEffect;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.network.PacketItemUpdate;
import com.emoniph.witchery.ritual.RiteRegistry;
import com.emoniph.witchery.util.Const;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiScreenWitchcraftBook
extends GuiScreen {
    private static final ResourceLocation field_110405_a = new ResourceLocation("textures/gui/book.png");
    public static final ResourceLocation DOUBLE_BOOK_TEXTURE = new ResourceLocation("witchery", "textures/gui/bookDouble.png");
    private static final ResourceLocation[] field_110405_b = new ResourceLocation[]{new ResourceLocation("witchery", "textures/gui/circle_white_large.png"), new ResourceLocation("witchery", "textures/gui/circle_blue_large.png"), new ResourceLocation("witchery", "textures/gui/circle_red_large.png"), new ResourceLocation("witchery", "textures/gui/circle_white_medium.png"), new ResourceLocation("witchery", "textures/gui/circle_blue_medium.png"), new ResourceLocation("witchery", "textures/gui/circle_red_medium.png"), new ResourceLocation("witchery", "textures/gui/circle_white_small.png"), new ResourceLocation("witchery", "textures/gui/circle_blue_small.png"), new ResourceLocation("witchery", "textures/gui/circle_red_small.png")};
    private static final String[] sizes = new String[]{"\u00a7715x15\u00a70", "\u00a7515x15\u00a70", "\u00a7415x15\u00a70", "\u00a7711x11\u00a70", "\u00a7511x11\u00a70", "\u00a7411x11\u00a70", "\u00a777x7\u00a70", "\u00a757x7\u00a70", "\u00a747x7\u00a70"};
    private final EntityPlayer player;
    private final ItemStack itemstack;
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private GuiButton buttonDone;
    private GuiButtonJumpPage buttonJumpPage1;
    private GuiButtonJumpPage buttonJumpPage2;
    private GuiButtonJumpPage buttonJumpPage3;
    private GuiButtonJumpPage buttonJumpPage4;
    private GuiButtonJumpPage buttonJumpPage5;
    private GuiButtonJumpPage buttonJumpPage6;
    private GuiButtonJumpPage buttonJumpPage7;
    private static final String CURRENT_PAGE_KEY = "CurrentPage";

    public GuiScreenWitchcraftBook(EntityPlayer player, ItemStack itemstack) {
        NBTTagCompound compound;
        this.player = player;
        this.itemstack = itemstack;
        this.bookTitle = itemstack.getDisplayName();
        this.bookPages = new NBTTagList();
        if (Witchery.Items.GENERIC.itemBookOven.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            compound.setString("Summary", Witchery.resource("witchery.book.oven1"));
            this.bookPages.appendTag((NBTBase)compound);
            compound = new NBTTagCompound();
            compound.setString("Summary", Witchery.resource("witchery.book.oven2"));
            this.bookPages.appendTag((NBTBase)compound);
            compound = new NBTTagCompound();
            compound.setString("Summary", Witchery.resource("witchery.book.oven3"));
            this.bookPages.appendTag((NBTBase)compound);
        } else if (Witchery.Items.GENERIC.itemBookDistilling.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.distillery1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            for (DistilleryRecipes.DistilleryRecipe recipe : DistilleryRecipes.instance().recipes) {
                compound = new NBTTagCompound();
                compound.setString("Summary", recipe.getDescription());
                this.bookPages.appendTag((NBTBase)compound);
            }
        } else if (Witchery.Items.GENERIC.itemBookCircleMagic.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.rites1");
            String intro2 = Witchery.resource("witchery.book.rites2");
            String anyCircles = Witchery.resource("witchery.book.rites.anycircle");
            compound.setString("Summary", intro);
            compound.setString("Summary2", intro2);
            compound.setByteArray("Circles", new byte[]{0, 3, 6});
            this.bookPages.appendTag((NBTBase)compound);
            for (RiteRegistry.Ritual ritual : RiteRegistry.instance().getSortedRituals()) {
                if (!ritual.showInBook()) continue;
                compound = new NBTTagCompound();
                compound.setString("Summary", ritual.getDescription());
                byte[] circles = ritual.getCircles();
                compound.setByteArray("Circles", circles);
                if (circles.length == 0) {
                    compound.setString("Summary2", anyCircles);
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (byte cir : circles) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(sizes[cir]);
                    }
                    compound.setString("Summary2", sb.toString());
                }
                this.bookPages.appendTag((NBTBase)compound);
            }
        } else if (Witchery.Items.GENERIC.itemBookInfusions.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.brews1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            for (KettleRecipes.KettleRecipe recipe : KettleRecipes.instance().recipes) {
                if (!recipe.inBook) continue;
                compound = new NBTTagCompound();
                compound.setString("Summary", recipe.getDescription());
                this.bookPages.appendTag((NBTBase)compound);
            }
        } else if (Witchery.Items.GENERIC.itemBookBurning.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.burning1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            for (BrazierRecipes.BrazierRecipe recipe : BrazierRecipes.instance().recipes) {
                if (!recipe.inBook) continue;
                compound = new NBTTagCompound();
                compound.setString("Summary", recipe.getDescription());
                this.bookPages.appendTag((NBTBase)compound);
            }
            compound = new NBTTagCompound();
            String intro2 = Witchery.resource("witchery.book.burning2");
            compound.setString("Summary", intro2);
            this.bookPages.appendTag((NBTBase)compound);
            for (InfusedSpiritEffect effect : InfusedSpiritEffect.effectList) {
                if (effect == null || !effect.isInBook()) continue;
                compound = new NBTTagCompound();
                compound.setString("Summary", effect.getDescription());
                this.bookPages.appendTag((NBTBase)compound);
            }
        } else if (Witchery.Items.GENERIC.itemBookHerbology.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.herbology1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            this.addPlantPage((Block)Witchery.Blocks.CROP_BELLADONNA, "witchery.book.herbology.belladonna", "witchery:textures/blocks/belladonna_stage_4.png");
            this.addPlantPage(Witchery.Blocks.EMBER_MOSS, "witchery.book.herbology.embermoss", "witchery:textures/blocks/embermoss.png");
            this.addPlantPage(Witchery.Blocks.GLINT_WEED, "witchery.book.herbology.glintweed", "witchery:textures/blocks/glintWeed.png");
            this.addPlantPage((Block)Witchery.Blocks.CROP_MANDRAKE, "witchery.book.herbology.mandrake", "witchery:textures/blocks/mandrake_stage_4.png");
            this.addPlantPage((Block)Witchery.Blocks.CROP_SNOWBELL, "witchery.book.herbology.snowbell", "witchery:textures/blocks/snowbell_stage_4.png");
            this.addPlantPage(Witchery.Blocks.SPANISH_MOSS, "witchery.book.herbology.spanishmoss", "witchery:textures/blocks/spanishMoss.png");
            this.addPlantPage(new ItemStack(Witchery.Blocks.BRAMBLE, 1, 1), "witchery.book.herbology.wildbramble", "witchery:textures/blocks/bramble_wild.png");
            this.addPlantPage(new ItemStack(Witchery.Blocks.BRAMBLE, 1, 0), "witchery.book.herbology.enderbramble", "witchery:textures/blocks/bramble_ender.png");
            this.addPlantPage(Witchery.Blocks.VOID_BRAMBLE, "witchery.book.herbology.voidbramble", "witchery:textures/blocks/voidBramble.png");
            this.addPlantPage((Block)Witchery.Blocks.CROP_ARTICHOKE, "witchery.book.herbology.artichoke", "witchery:textures/blocks/artichoke_stage_4.png");
            this.addPlantPage(Witchery.Blocks.GRASSPER, "witchery.book.herbology.grassper", "witchery:textures/blocks/grassperIcon.png");
            this.addPlantPage(Witchery.Blocks.CRITTER_SNARE, "witchery.book.herbology.crittersnare", "witchery:textures/blocks/critterSnare_empty.png");
            this.addPlantPage(Witchery.Blocks.BLOOD_ROSE, "witchery.book.herbology.bloodrose", "witchery:textures/blocks/bloodrose.png");
            this.addPlantPage(Witchery.Blocks.WISPY_COTTON, "witchery.book.herbology.somniancotton", "witchery:textures/blocks/somnianCotton.png");
            this.addPlantPage((Block)Witchery.Blocks.CROP_WOLFSBANE, "witchery.book.herbology.wolfsbane", "witchery:textures/blocks/wolfsbane_stage_7.png");
            this.addPlantPage((Block)Witchery.Blocks.CROP_GARLIC, "witchery.book.herbology.garlic", "witchery:textures/blocks/garlic_stage_5.png");
            this.addPlantPage(new ItemStack(Witchery.Blocks.SAPLING, 1, 1), "witchery.book.herbology.alder", "witchery:textures/blocks/sapling_alder.png");
            this.addPlantPage(new ItemStack(Witchery.Blocks.SAPLING, 1, 2), "witchery.book.herbology.hawthorn", "witchery:textures/blocks/sapling_hawthorn.png");
            this.addPlantPage(new ItemStack(Witchery.Blocks.SAPLING, 1, 0), "witchery.book.herbology.rowan", "witchery:textures/blocks/sapling_rowan.png");
        } else if (Witchery.Items.GENERIC.itemBookBiomes.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.biomes1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            this.addBiomes(BiomeDictionary.Type.FOREST);
            this.addBiomes(BiomeDictionary.Type.PLAINS);
            this.addBiomes(BiomeDictionary.Type.MOUNTAIN);
            this.addBiomes(BiomeDictionary.Type.HILLS);
            this.addBiomes(BiomeDictionary.Type.SWAMP);
            this.addBiomes(BiomeDictionary.Type.WATER);
            this.addBiomes(BiomeDictionary.Type.DESERT);
            this.addBiomes(BiomeDictionary.Type.FROZEN);
            this.addBiomes(BiomeDictionary.Type.JUNGLE);
            this.addBiomes(BiomeDictionary.Type.WASTELAND);
            this.addBiomes(BiomeDictionary.Type.BEACH);
            this.addBiomes(BiomeDictionary.Type.MUSHROOM);
            this.addBiomes(BiomeDictionary.Type.MAGICAL);
        } else if (Witchery.Items.GENERIC.itemBookWands.isMatch(itemstack)) {
            compound = new NBTTagCompound();
            String intro = Witchery.resource("witchery.book.wands1");
            compound.setString("Summary", intro);
            this.bookPages.appendTag((NBTBase)compound);
            for (SymbolEffect recipe : EffectRegistry.instance().getEffects()) {
                if (!recipe.isVisible(player)) continue;
                compound = new NBTTagCompound();
                compound.setString("Summary", recipe.getDescription());
                this.bookPages.appendTag((NBTBase)compound);
            }
        }
        this.bookTotalPages = this.bookPages.tagCount();
        NBTTagCompound stackCompound = itemstack.getTagCompound();
        if (stackCompound != null && stackCompound.hasKey(CURRENT_PAGE_KEY)) {
            this.currPage = Math.min(Math.max(stackCompound.getInteger(CURRENT_PAGE_KEY), 0), Math.max(this.bookTotalPages, 1) - 1);
        }
    }

    private void addBiomes(BiomeDictionary.Type biomeType) {
        String biomeKey = biomeType.toString().toLowerCase();
        String title = "\u00a7n" + Witchery.resource("witchery.book.biomes." + biomeKey + ".name") + "\u00a7r" + "\n\n" + "\u00a78" + Witchery.resource("witchery.book.biomes.foci") + ": " + Witchery.resource("witchery.book.biomes." + biomeKey + ".item") + "\u00a70" + Const.BOOK_NEWLINE;
        BiomeGenBase[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType);
        int ITEMS_PER_PAGE = 8;
        StringBuilder sb = new StringBuilder();
        for (int glowstone = 1; glowstone <= biomes.length; ++glowstone) {
            sb.append(glowstone);
            sb.append(" : ");
            sb.append(biomes[glowstone - 1].biomeName);
            sb.append(Const.BOOK_NEWLINE);
            if (glowstone % 8 != 0 && glowstone != biomes.length) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.setString("Summary", title + Const.BOOK_NEWLINE + sb.toString());
            this.bookPages.appendTag((NBTBase)compound);
            sb = new StringBuilder();
        }
    }

    private void addPlantPage(ItemStack plantStack, String descriptionResourceID, String imageResourceID) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("Summary", "\u00a7n" + plantStack.getDisplayName() + "\u00a7r");
        compound.setString("Details", Witchery.resource(descriptionResourceID));
        compound.setString("Image", imageResourceID);
        this.bookPages.appendTag((NBTBase)compound);
    }

    private void addPlantPage(Block plantBlock, String descriptionResourceID, String imageResourceID) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("Summary", "\u00a7n" + plantBlock.getLocalizedName() + "\u00a7r");
        compound.setString("Details", Witchery.resource(descriptionResourceID));
        compound.setString("Image", imageResourceID);
        this.bookPages.appendTag((NBTBase)compound);
    }

    private void storeCurrentPage() {
        if (this.itemstack.getTagCompound() == null) {
            this.itemstack.setTagCompound(new NBTTagCompound());
        }
        this.itemstack.getTagCompound().setInteger(CURRENT_PAGE_KEY, this.currPage);
    }

    public void updateScreen() {
        super.updateScreen();
        ++this.updateCount;
    }

    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.width / 2 - 100, 4 + this.bookImageHeight, 200, 20, I18n.format((String)"gui.done", (Object[])new Object[0]));
        this.buttonList.add(this.buttonDone);
        int i = (this.width - this.bookImageWidth) / 2;
        int b0 = 2;
        if (Witchery.Items.GENERIC.itemBookCircleMagic.isMatch(this.itemstack)) {
            this.buttonNextPage = new GuiButtonNextPage(1, i + 180, b0 + 154, true);
            this.buttonList.add(this.buttonNextPage);
            this.buttonPreviousPage = new GuiButtonNextPage(2, i + 110, b0 + 154, false);
            this.buttonList.add(this.buttonPreviousPage);
            this.buttonJumpPage7 = new GuiButtonJumpPage(9, i + 214, b0 + 138, 69, 48, 248);
            this.buttonList.add(this.buttonJumpPage7);
            this.buttonJumpPage6 = new GuiButtonJumpPage(8, i + 214, b0 + 118, 58, 40, 248);
            this.buttonList.add(this.buttonJumpPage6);
            this.buttonJumpPage5 = new GuiButtonJumpPage(7, i + 214, b0 + 98, 47, 32, 248);
            this.buttonList.add(this.buttonJumpPage5);
            this.buttonJumpPage4 = new GuiButtonJumpPage(6, i + 214, b0 + 78, 29, 24, 248);
            this.buttonList.add(this.buttonJumpPage4);
            this.buttonJumpPage3 = new GuiButtonJumpPage(5, i + 214, b0 + 58, 23, 16, 248);
            this.buttonList.add(this.buttonJumpPage3);
            this.buttonJumpPage2 = new GuiButtonJumpPage(4, i + 214, b0 + 38, 17, 8, 248);
            this.buttonList.add(this.buttonJumpPage2);
            this.buttonJumpPage1 = new GuiButtonJumpPage(3, i + 214, b0 + 18, 2, 0, 248);
            this.buttonList.add(this.buttonJumpPage1);
        } else {
            this.buttonNextPage = new GuiButtonNextPage(1, i + 120, b0 + 154, true);
            this.buttonList.add(this.buttonNextPage);
            this.buttonPreviousPage = new GuiButtonNextPage(2, i + 38, b0 + 154, false);
            this.buttonList.add(this.buttonPreviousPage);
        }
        this.updateButtons();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.sendBookToServer(false);
    }

    private void updateButtons() {
        this.buttonNextPage.visible = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.visible = this.currPage > 0;
    }

    private void sendBookToServer(boolean par1) {
        if (this.player != null && this.currPage >= 0 && this.currPage < 1000 && this.player.inventory.currentItem >= 0 && this.player.inventory.getCurrentItem() != null) {
            Witchery.packetPipeline.sendToServer(new PacketItemUpdate(this.player.inventory.currentItem, this.currPage, this.player.inventory.getCurrentItem()));
        }
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.enabled) {
            if (par1GuiButton.id == 0) {
                this.mc.displayGuiScreen((GuiScreen)null);
            } else if (par1GuiButton.id == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                    this.storeCurrentPage();
                }
            } else if (par1GuiButton.id == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                    this.storeCurrentPage();
                }
            } else if (par1GuiButton instanceof GuiButtonJumpPage) {
                GuiButtonJumpPage but = (GuiButtonJumpPage)par1GuiButton;
                this.currPage = but.nextPage - 1;
                this.storeCurrentPage();
            }
            this.updateButtons();
        }
    }

    protected void keyTyped(char par1, int par2) {
        super.keyTyped(par1, par2);
    }

    public void drawScreen(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Witchery.Items.GENERIC.itemBookCircleMagic.isMatch(this.itemstack)) {
            this.mc.getTextureManager().bindTexture(DOUBLE_BOOK_TEXTURE);
            this.bookImageWidth = 256;
            int k = (this.width - this.bookImageWidth) / 2;
            int b0 = 2;
            this.drawTexturedModalRect(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
            String s3 = "";
            String s = I18n.format((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s1 = "";
            String s2 = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.tagCount()) {
                NBTTagCompound compound = this.bookPages.getCompoundTagAt(this.currPage);
                s1 = compound.getString("Summary");
                s2 = compound.getString("Summary2");
                if (compound.hasKey("Circles")) {
                    byte[] circles;
                    for (byte circle : circles = compound.getByteArray("Circles")) {
                        this.mc.getTextureManager().bindTexture(field_110405_b[circle]);
                        this.drawTexturedModalRect(k, b0, -148, -36, this.bookImageWidth, this.bookImageHeight);
                    }
                }
            }
            int l = this.fontRendererObj.getStringWidth(s);
            this.fontRendererObj.drawString(s, k - l + this.bookImageWidth - 16, b0 + 16, 0);
            this.fontRendererObj.drawSplitString(s1, k + 20, b0 + 16, 98, 0);
            if (!s2.isEmpty()) {
                int swidth = this.fontRendererObj.getStringWidth(s2);
                if (swidth < 90) {
                    this.fontRendererObj.drawSplitString(s2, k + this.bookImageWidth / 4 * 3 - swidth / 2, b0 + 125, 98, 0);
                } else {
                    this.fontRendererObj.drawSplitString(s2, k + 142, b0 + 125, 98, 0);
                }
            }
        } else {
            this.mc.getTextureManager().bindTexture(field_110405_a);
            int k = (this.width - this.bookImageWidth) / 2;
            int b0 = 2;
            this.drawTexturedModalRect(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
            String s2 = "";
            String s = I18n.format((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s1 = "";
            boolean hasImage = false;
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.tagCount()) {
                NBTTagCompound compound = this.bookPages.getCompoundTagAt(this.currPage);
                s1 = compound.getString("Summary");
                if (compound.hasKey("Circles")) {
                    byte[] circles;
                    for (byte circle : circles = compound.getByteArray("Circles")) {
                        this.mc.getTextureManager().bindTexture(field_110405_b[circle]);
                        this.drawTexturedModalRect(k, b0, -62, -70, this.bookImageWidth, this.bookImageHeight);
                    }
                }
                if (hasImage = compound.hasKey("Image")) {
                    String loc = compound.getString("Image");
                    ResourceLocation location = new ResourceLocation(loc);
                    this.mc.getTextureManager().bindTexture(location);
                    GuiScreenWitchcraftBook.drawTexturedQuadFit(k - 32 + this.bookImageWidth - 44, b0 + 32, 32.0, 32.0, this.zLevel);
                }
                if (compound.hasKey("Details")) {
                    s2 = compound.getString("Details");
                }
            }
            int l = this.fontRendererObj.getStringWidth(s);
            this.fontRendererObj.drawString(s, k - l + this.bookImageWidth - 44, b0 + 16, 0);
            this.fontRendererObj.drawSplitString(s1, k + 36, b0 + 32, 116 - (hasImage ? 34 : 0), 0);
            if (s2 != null && !s2.isEmpty()) {
                this.fontRendererObj.drawSplitString(s2, k + 36, b0 + 32 + 34, 116, 0);
            }
        }
        super.drawScreen(par1, par2, par3);
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + height, zLevel, 0.0, 1.0);
        tessellator.addVertexWithUV(x + width, y + height, zLevel, 1.0, 1.0);
        tessellator.addVertexWithUV(x + width, y + 0.0, zLevel, 1.0, 0.0);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.draw();
    }

    static ResourceLocation func_110404_g() {
        return field_110405_a;
    }
}

