/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client;

import com.emoniph.witchery.entity.EntityBroom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TransformWolf {
    private EntityWolf proxyEntity;
    private RenderWolf proxyRenderer = new RenderWolf((ModelBase)new ModelWolf(), (ModelBase)new ModelWolf(), 0.5f);

    public EntityLivingBase getModel() {
        return this.proxyEntity;
    }

    public void syncModelWith(EntityLivingBase entity, boolean frontface) {
        if (this.proxyEntity == null) {
            this.proxyEntity = new EntityWolf(entity.worldObj);
        } else if (this.proxyEntity.worldObj != entity.worldObj) {
            this.proxyEntity.setWorld(entity.worldObj);
        }
        this.proxyEntity.setPosition(entity.posX, entity.posY, entity.posZ);
        this.proxyEntity.lastTickPosX = entity.lastTickPosX;
        this.proxyEntity.lastTickPosY = entity.lastTickPosY;
        this.proxyEntity.lastTickPosZ = entity.lastTickPosZ;
        this.proxyEntity.motionX = entity.motionX;
        this.proxyEntity.motionY = entity.motionY;
        this.proxyEntity.motionZ = entity.motionZ;
        this.proxyEntity.moveForward = entity.moveForward;
        this.proxyEntity.moveStrafing = entity.moveStrafing;
        this.proxyEntity.onGround = entity.onGround;
        this.proxyEntity.prevPosX = entity.prevPosX;
        this.proxyEntity.prevPosY = entity.prevPosY;
        this.proxyEntity.prevPosZ = entity.prevPosZ;
        this.proxyEntity.rotationPitch = entity.rotationPitch;
        this.proxyEntity.rotationYaw = entity.rotationYaw;
        this.proxyEntity.rotationYawHead = entity.rotationYawHead;
        this.proxyEntity.prevRotationPitch = entity.prevRotationPitch;
        this.proxyEntity.prevRotationYaw = entity.prevRotationYaw;
        this.proxyEntity.prevRotationYawHead = entity.prevRotationYawHead;
        this.proxyEntity.limbSwing = entity.limbSwing;
        this.proxyEntity.limbSwingAmount = entity.limbSwingAmount;
        this.proxyEntity.prevLimbSwingAmount = entity.prevLimbSwingAmount;
        this.proxyEntity.isSwingInProgress = entity.isSwingInProgress;
        this.proxyEntity.swingProgress = entity.swingProgress;
        this.proxyEntity.prevSwingProgress = entity.prevSwingProgress;
        this.proxyEntity.renderYawOffset = frontface ? 0.0f : entity.renderYawOffset;
        this.proxyEntity.prevRenderYawOffset = frontface ? 0.0f : entity.prevRenderYawOffset;
        this.proxyEntity.ticksExisted = entity.ticksExisted;
        this.proxyEntity.isDead = false;
        this.proxyEntity.isAirBorne = entity.isAirBorne;
        this.proxyEntity.yOffset = 0.0f;
        this.proxyEntity.setSneaking(entity.isSneaking());
        this.proxyEntity.setSprinting(entity.isSprinting());
        this.proxyEntity.setInvisible(entity.isInvisible());
        this.proxyEntity.setSitting(entity.isRiding());
    }

    public void render(World worldObj, EntityLivingBase entity, double x, double y, double z, RendererLivingEntity renderer, float partialTicks, boolean frontface) {
        this.syncModelWith(entity, frontface);
        this.proxyRenderer.setRenderManager(RenderManager.instance);
        float f1 = this.proxyEntity.prevRotationYaw + (this.proxyEntity.rotationYaw - this.proxyEntity.prevRotationYaw) * partialTicks;
        double d3 = -((double)this.proxyEntity.yOffset);
        if (this.proxyEntity.isSneaking() && !(entity instanceof EntityPlayerSP)) {
            d3 -= 0.125;
        }
        if (entity.isRiding()) {
            Entity ridden = entity.ridingEntity;
            d3 += ridden.getMountedYOffset() + (entity.ridingEntity instanceof EntityBroom ? (double)ridden.height - 0.2 : 0.0);
        }
        float f2 = 1.0f;
        GL11.glColor3f((float)f2, (float)f2, (float)f2);
        this.proxyRenderer.doRender((EntityLiving)this.proxyEntity, x, y + d3, z, frontface ? 0.0f : f1, partialTicks);
    }

    protected void renderEquippedItems(ItemRenderer itemRenderer, EntityLivingBase p_77029_1_, float p_77029_2_) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack itemstack = p_77029_1_.getHeldItem();
        if (itemstack != null && itemstack.getItem() != null) {
            float f1;
            boolean is3D;
            Item item = itemstack.getItem();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
            boolean bl = is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            if (item instanceof ItemBlock && (is3D || RenderBlocks.renderItemIn3d((int)Block.getBlockFromItem((Item)item).getRenderType()))) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(-(f1 *= 0.75f)), (float)(-f1), (float)f1);
            } else if (item == Items.bow) {
                f1 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (item.isFull3D()) {
                f1 = 0.625f;
                if (item.shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                f1 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f1, (float)f1, (float)f1);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (itemstack.getItem().requiresMultipleRenderPasses()) {
                for (int i = 0; i < itemstack.getItem().getRenderPasses(itemstack.getItemDamage()); ++i) {
                    int j = itemstack.getItem().getColorFromItemStack(itemstack, i);
                    float f5 = (float)(j >> 16 & 0xFF) / 255.0f;
                    float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f3 = (float)(j & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f5, (float)f2, (float)f3, (float)1.0f);
                    itemRenderer.renderItem(p_77029_1_, itemstack, i);
                }
            } else {
                int i = itemstack.getItem().getColorFromItemStack(itemstack, 0);
                float f4 = (float)(i >> 16 & 0xFF) / 255.0f;
                float f5 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GL11.glColor4f((float)f4, (float)f5, (float)f2, (float)1.0f);
                itemRenderer.renderItem(p_77029_1_, itemstack, 0);
            }
            GL11.glPopMatrix();
        }
    }
}

