/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.PotionResizing;
import com.emoniph.witchery.client.RenderEntityViewer;
import com.emoniph.witchery.client.renderer.RenderInfusionEnergyBar;
import com.emoniph.witchery.infusion.InfusedBrewEffect;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePowerSpeed;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.StrokeSet;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.integration.ModHookMorph;
import com.emoniph.witchery.item.ItemBrewBag;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.EntitySizeInfo;
import com.emoniph.witchery.util.KeyBindHelper;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.RenderUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlayerRender {
    protected static RenderInfusionEnergyBar infusionEnergyBar;
    protected static RenderInfusionEnergyBar creatureEnergyBar;
    private boolean remoteViewingActive = true;
    public static long ticksSinceActive;
    public static boolean moveCameraActive;
    public static int moveCameraToEntityID;
    private static final ResourceLocation RADIAL_LOCATION;
    EntityRenderer prevRender;
    RenderEntityViewer renderer;
    int currentBeastForm = 0;
    private static final ResourceLocation BARK_TEXTURES;
    private static RenderItem drawItems;
    private int lastY = 0;
    private static final int[] glyphOffsetX;
    private static final int[] glyphOffsetY;
    private static final ResourceLocation TEXTURE_GRID;
    private Field fieldAccess = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ItemStack belt;
        EntityClientPlayerMP player;
        if (event.phase == TickEvent.Phase.START) {
            PotionEffect shrunk;
            EntityClientPlayerMP player2 = Minecraft.getMinecraft().thePlayer;
            Minecraft mc = Minecraft.getMinecraft();
            if (player2 == null || mc.currentScreen != null) return;
            if (mc.getSystemTime() - ticksSinceActive > 3000L) {
                moveCameraActive = false;
            }
            this.remoteViewingActive = moveCameraActive;
            if (this.remoteViewingActive) {
                for (Object entity : player2.worldObj.loadedEntityList) {
                    if (((Entity)entity).getEntityId() != moveCameraToEntityID || !(entity instanceof EntityLivingBase)) continue;
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if (living.isDead) return;
                    Minecraft.getMinecraft().renderViewEntity = living;
                    return;
                }
                return;
            }
            EntitySizeInfo size = new EntitySizeInfo((EntityLivingBase)player2);
            PotionEffect potionEffect = shrunk = Witchery.Potions.RESIZING != null ? player2.getActivePotionEffect(Witchery.Potions.RESIZING) : null;
            if (!(shrunk == null && size.isDefault || ModHookMorph.isMorphed((EntityPlayer)player2, true))) {
                if (this.renderer == null) {
                    this.renderer = new RenderEntityViewer(mc);
                }
                if (mc.gameSettings.thirdPersonView == 0) {
                    if (mc.entityRenderer != this.renderer) {
                        this.prevRender = mc.entityRenderer;
                        mc.entityRenderer = this.renderer;
                    }
                } else if (this.prevRender != null) {
                    mc.entityRenderer = this.prevRender;
                }
                float normalSize = 1.8f;
                float scale = size.defaultHeight / 1.8f * (shrunk != null ? PotionResizing.getScaleFactor(shrunk.getAmplifier()) : 1.0f);
                if (scale < 1.0f) {
                    float requiredSize = 1.8f * (1.0f - scale);
                    float currentSize = this.renderer.getOffset();
                    if (currentSize < requiredSize) {
                        currentSize = Math.min(currentSize + 0.01f, requiredSize);
                    } else if (currentSize > requiredSize) {
                        currentSize = Math.min(currentSize - 0.01f, requiredSize);
                    }
                    this.renderer.setOffset(currentSize);
                    return;
                } else {
                    float requiredSize = -(1.8f * scale - 1.8f);
                    float currentSize = this.renderer.getOffset();
                    if (currentSize > requiredSize) {
                        currentSize = Math.max(currentSize - 0.01f, requiredSize);
                    }
                    this.renderer.setOffset(currentSize);
                }
                return;
            } else {
                if (this.prevRender == null || mc.entityRenderer == this.prevRender) return;
                if (this.renderer != null) {
                    this.renderer.setOffset(0.0f);
                }
                mc.entityRenderer = this.prevRender;
            }
            return;
        }
        if (event.phase != TickEvent.Phase.END || (player = Minecraft.getMinecraft().thePlayer) == null || Minecraft.getMinecraft().currentScreen != null) return;
        Minecraft mc = Minecraft.getMinecraft();
        if (this.remoteViewingActive) {
            Minecraft.getMinecraft().renderViewEntity = player;
        }
        ScaledResolution screen = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        int maxEnergy = Infusion.getMaxEnergy((EntityPlayer)player);
        if (maxEnergy > 0) {
            if (infusionEnergyBar == null) {
                infusionEnergyBar = new RenderInfusionEnergyBar(true);
            }
            double left = Config.instance().guiOnLeft ? 20.0 : (double)(screen.getScaledWidth() - 20);
            double top = (double)screen.getScaledHeight() / 2.0 - 16.0;
            Infusion infusion = Infusion.Registry.instance().get((EntityPlayer)player);
            infusionEnergyBar.draw(left, top, (double)Infusion.getCurrentEnergy((EntityPlayer)player) / (double)maxEnergy, (EntityPlayer)player, infusion.infusionID);
        }
        int powerID = CreaturePower.getCreaturePowerID((EntityPlayer)player);
        int charges = CreaturePower.getCreaturePowerCharges((EntityPlayer)player);
        if (powerID > 0) {
            if (creatureEnergyBar == null) {
                creatureEnergyBar = new RenderInfusionEnergyBar(false);
            }
            double left = Config.instance().guiOnLeft ? 30.0 : (double)(screen.getScaledWidth() - 30);
            double top = (double)screen.getScaledHeight() / 2.0 - 16.0;
            creatureEnergyBar.draw(left, top, charges, (EntityPlayer)player, powerID);
        }
        if ((belt = player.getEquipmentInSlot(2)) != null && belt.getItem() == Witchery.Items.BARK_BELT) {
            int beltCharges = Math.min(Witchery.Items.BARK_BELT.getChargeLevel(belt), Witchery.Items.BARK_BELT.getMaxChargeLevel((EntityLivingBase)player));
            this.drawBarkBeltCharges(player, beltCharges, screen);
        }
        this.drawInfusedBrews(player, screen);
        ItemStack stack = player.getItemInUse();
        if (stack != null && stack.getItem() == Witchery.Items.MYSTIC_BRANCH) {
            byte[] strokes = player.getEntityData().getByteArray("Strokes");
            mc.getTextureManager().bindTexture(TEXTURE_GRID);
            GL11.glPushMatrix();
            int iconOffset = 0;
            if (Config.instance().branchIconSet == 1) {
                iconOffset = 64;
            }
            try {
                int x = screen.getScaledWidth() / 2 - 8;
                int y = screen.getScaledHeight() / 2 - 8;
                int DELAY = 8;
                this.lastY = this.lastY == 120 ? 0 : this.lastY + 1;
                int tempIndex = this.lastY / 8;
                int imageIndex = tempIndex > 7 ? 15 - tempIndex : tempIndex;
                for (int i = 0; i < strokes.length; ++i) {
                    PlayerRender.drawTexturedModalRect(x += glyphOffsetX[strokes[i]] * 16, y += glyphOffsetY[strokes[i]] * 16, strokes[i] * 16 + iconOffset, imageIndex * 16, 16, 16);
                }
                SymbolEffect effect = EffectRegistry.instance().getEffect(strokes);
                if (effect == null) return;
                String text = effect.getLocalizedName();
                int tx = screen.getScaledWidth() / 2 - (int)(PlayerRender.getStringWidth(text) / 2.0);
                int ty = screen.getScaledHeight() / 2 + 20;
                PlayerRender.drawString(text, tx, ty, 0xFFFFFF);
                return;
            }
            finally {
                GL11.glPopMatrix();
            }
        } else {
            if (stack == null || stack.getItem() != Witchery.Items.BREW_BAG || player.isSneaking()) return;
            ItemBrewBag.InventoryBrewBag inv = new ItemBrewBag.InventoryBrewBag((EntityPlayer)player);
            byte[] strokes = player.getEntityData().getByteArray("Strokes");
            GL11.glPushMatrix();
            try {
                int x = screen.getScaledWidth() / 2 - 8;
                int y = screen.getScaledHeight() / 2 - 8;
                if (strokes.length == 0) {
                    mc.getTextureManager().bindTexture(RADIAL_LOCATION);
                    GL11.glPushMatrix();
                    float scale = 0.33333334f;
                    GL11.glTranslatef((float)(x - 42 + 5), (float)(y - 42 + 5), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    int color = ItemBrewBag.getColor(stack);
                    float red = (float)(color >>> 16 & 0xFF) / 256.0f;
                    float green = (float)(color >>> 8 & 0xFF) / 256.0f;
                    float blue = (float)(color & 0xFF) / 256.0f;
                    GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
                    PlayerRender.drawTexturedModalRect(8, 8, 0, 0, 256, 256);
                    GL11.glPopMatrix();
                }
                this.drawBrewInSlot(inv, 0, strokes, x + 0, y - 32, 0, -11, 1);
                this.drawBrewInSlot(inv, 1, strokes, x + 24, y - 24, 23, 6, 0);
                this.drawBrewInSlot(inv, 2, strokes, x + 32, y - 0, 23, 6, 0);
                this.drawBrewInSlot(inv, 3, strokes, x + 24, y + 24, 23, 6, 0);
                this.drawBrewInSlot(inv, 4, strokes, x + 0, y + 32, 0, 19, 1);
                this.drawBrewInSlot(inv, 5, strokes, x - 24, y + 24, -5, 6, 2);
                this.drawBrewInSlot(inv, 6, strokes, x - 32, y - 0, -5, 6, 2);
                this.drawBrewInSlot(inv, 7, strokes, x - 24, y - 24, -5, 6, 2);
                return;
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    private void drawInfusedBrews(EntityClientPlayerMP player, ScaledResolution screen) {
        String remainingTime;
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        InfusedBrewEffect effect = InfusedBrewEffect.getActiveBrew(nbtPlayer);
        if (effect != null && (remainingTime = InfusedBrewEffect.getMinutesRemaining(player.worldObj, nbtPlayer, effect)) != null && !remainingTime.isEmpty()) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.getTextureManager().bindTexture(BARK_TEXTURES);
            int tx = screen.getScaledWidth() / 2 - 91;
            int screenHeight = screen.getScaledHeight();
            int top = screen.getScaledHeight() / 2 + 26;
            int screenMid = screenHeight / 2;
            int left = Config.instance().guiOnLeft ? 17 : screen.getScaledWidth() - 23;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ICON_WIDTH = 16;
            int ICON_HEIGHT = 16;
            PlayerRender.drawTexturedModalRect(left, top, effect.imageMapX, effect.imageMapY, 16, 16);
            double width = PlayerRender.getStringWidth(remainingTime) / 2.0;
            PlayerRender.drawString(remainingTime, (double)(left + 8) - width, top + 10, -285212673);
        }
    }

    private void drawBarkBeltCharges(EntityClientPlayerMP player, int beltCharges, ScaledResolution screen) {
        if (beltCharges > 0 && !player.capabilities.isCreativeMode) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.getTextureManager().bindTexture(BARK_TEXTURES);
            int tx = screen.getScaledWidth() / 2 - 91;
            int par2 = screen.getScaledHeight();
            int ty = par2 / 2;
            IAttributeInstance attributeinstance = mc.thePlayer.getEntityAttribute(SharedMonsterAttributes.maxHealth);
            int i2 = par2 - 39;
            float f = (float)attributeinstance.getAttributeValue();
            float f1 = mc.thePlayer.getAbsorptionAmount();
            int j2 = MathHelper.ceiling_float_int((float)((f + f1) / 2.0f / 10.0f));
            int k2 = Math.max(10 - (j2 - 2), 3);
            int l2 = Witchery.modHooks.isTinkersPresent ? i2 - 10 : i2 - (j2 - 1) * k2 - 10;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean iconOffsetX = false;
            int ICON_WIDTH = 8;
            int ICON_HEIGHT = 8;
            int iconOffsetY = 248;
            for (int i = 0; i < beltCharges; ++i) {
                PlayerRender.drawTexturedModalRect(tx + i * 8, l2, 0, 248, 8, 8);
            }
        }
    }

    private void drawBrewInSlot(ItemBrewBag.InventoryBrewBag inv, int slot, byte[] strokes, int x, int y, int fx, int fy, int align) {
        ItemStack brew = inv.getStackInSlot(slot);
        if (brew != null && (strokes.length == 0 || strokes[0] == StrokeSet.Stroke.INDEX_TO_STROKE[slot])) {
            PlayerRender.drawItem(x, y, brew);
            String s = brew.getDisplayName();
            if (s != null) {
                s.trim();
                double fontX = x + fx;
                double fontY = y + fy;
                if (align != 0) {
                    double width = PlayerRender.getStringWidth(s);
                    if (align == 1) {
                        fontX -= width / 2.0;
                    } else if (align == 2) {
                        fontX -= width;
                    }
                }
                PlayerRender.drawString(s, fontX, fontY, 0x77FFFFFF);
            }
        }
    }

    private static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (stack != null && stack.getItem() != null && (f = stack.getItem().getFontRenderer(stack)) != null) {
            return f;
        }
        return Minecraft.getMinecraft().fontRenderer;
    }

    private static void drawItem(int i, int j, ItemStack itemstack) {
        PlayerRender.drawItem(i, j, itemstack, PlayerRender.getFontRenderer(itemstack));
    }

    private static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer) {
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        PlayerRender.drawItems.zLevel += 100.0f;
        try {
            drawItems.renderItemAndEffectIntoGUI(fontRenderer, mc.renderEngine, itemstack, i, j);
            drawItems.renderItemOverlayIntoGUI(fontRenderer, mc.renderEngine, itemstack, i, j);
        }
        catch (Exception e) {
            // empty catch block
        }
        PlayerRender.drawItems.zLevel -= 100.0f;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public static void drawString(String s, double x, double y, int color) {
        RenderHelper.disableStandardItemLighting();
        RenderUtil.blend(true);
        RenderUtil.render2d(true);
        Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(s, (int)x, (int)y, color);
        RenderUtil.render2d(false);
        RenderUtil.blend(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getStringWidth(String s) {
        double val;
        GL11.glPushAttrib((int)262144);
        try {
            val = Minecraft.getMinecraft().fontRenderer.getStringWidth(s);
        }
        finally {
            GL11.glPopAttrib();
        }
        return val;
    }

    private static void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        double zLevel = 0.0;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(par1 + 0), (double)(par2 + par6), zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.addVertexWithUV((double)(par1 + par5), (double)(par2 + par6), zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.addVertexWithUV((double)(par1 + par5), (double)(par2 + 0), zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.addVertexWithUV((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.draw();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.getMinecraft();
            EntityClientPlayerMP player = minecraft.thePlayer;
            if (player != null) {
                int z;
                int y;
                int x;
                PotionEffect effect;
                int sinkingCurseLevel;
                CreaturePower power;
                boolean allowSpeedUp = true;
                int creaturePowerID = CreaturePower.getCreaturePowerID((EntityPlayer)player);
                if (creaturePowerID > 0 && (power = CreaturePower.Registry.instance().get(creaturePowerID)) != null) {
                    power.onUpdate(player.worldObj, (EntityPlayer)player);
                    boolean bl = allowSpeedUp = !(power instanceof CreaturePowerSpeed);
                }
                if (player.getHeldItem() != null && player.getHeldItem().getItem() != null && allowSpeedUp && (player.getHeldItem().getItem() == Witchery.Items.MYSTIC_BRANCH || player.getHeldItem().getItem() == Witchery.Items.BREW_BAG) && player.isUsingItem()) {
                    boolean canGo;
                    boolean bl = canGo = Math.abs(player.motionX) <= 0.1 && Math.abs(player.motionZ) <= 0.1;
                    if (player.worldObj.getBlock(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY) - 2, MathHelper.floor_double((double)player.posZ)) != Blocks.ice) {
                        if (player.onGround) {
                            if (!player.isInWater()) {
                                if (canGo) {
                                    player.motionX *= 1.6500000476837158;
                                    player.motionZ *= 1.6500000476837158;
                                }
                            } else if (canGo) {
                                player.motionX *= (double)1.1f;
                                player.motionZ *= (double)1.1f;
                            }
                        }
                    } else if (canGo) {
                        player.motionX *= (double)1.1f;
                        player.motionZ *= (double)1.1f;
                    }
                }
                if ((sinkingCurseLevel = Infusion.getSinkingCurseLevel((EntityPlayer)player)) > 0 && player.isInWater()) {
                    if (player.motionY < -0.03 && !player.onGround) {
                        player.motionY *= 1.5 + Math.min(0.05 * (double)(sinkingCurseLevel - 1), 0.2);
                    } else if (!player.onGround && player.isInsideOfMaterial(Material.water) && player.motionY > 0.0) {
                        // empty if block
                    }
                } else if (sinkingCurseLevel > 0) {
                    if (!player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying) {
                        player.motionY = -0.2f;
                    }
                } else if (player.isPotionActive(Potion.moveSlowdown) && !player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying && (effect = player.getActivePotionEffect(Potion.moveSlowdown)) != null && effect.getAmplifier() > 4) {
                    player.motionY = -0.2f;
                }
                if (sinkingCurseLevel == 0 && BlockUtil.getBlockMaterial((EntityPlayer)player).isLiquid() && player.getCurrentArmor(0) != null && player.getCurrentArmor(0).getItem() == Witchery.Items.DEATH_FEET && player.motionY < 0.0) {
                    player.motionY += 0.1;
                }
                if (player.onGround && KeyBindHelper.isKeyBindDown(minecraft.gameSettings.keyBindJump) && player.worldObj.getBlock(x = MathHelper.floor_double((double)player.posX), (y = MathHelper.floor_double((double)player.posY)) - 1, z = MathHelper.floor_double((double)player.posZ)) == Witchery.Blocks.LEAPING_LILY) {
                    player.playSound("random.bowhit", 1.0f, 0.4f / ((float)player.worldObj.rand.nextDouble() * 0.4f + 0.8f));
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            Minecraft minecraft = Minecraft.getMinecraft();
            EntityClientPlayerMP player = minecraft.thePlayer;
            if (player != null && minecraft.currentScreen != null && minecraft.currentScreen instanceof InventoryEffectRenderer && player.dimension == Config.instance().dimensionDreamID && !player.capabilities.isCreativeMode) {
                block35: {
                    if (this.fieldAccess == null) {
                        try {
                            Field[] fields = GuiScreen.class.getDeclaredFields();
                            if (fields.length <= 3) break block35;
                            if (fields[3].getType() == List.class) {
                                Field field = fields[3];
                                field.setAccessible(true);
                                this.fieldAccess = field;
                                break block35;
                            }
                            for (Field field : fields) {
                                if (field.getType() != List.class) continue;
                                field.setAccessible(true);
                                this.fieldAccess = field;
                                break;
                            }
                        }
                        catch (Exception e) {
                            Log.instance().debug(String.format("Exception occurred setting player gui. %s", e.toString()));
                        }
                    }
                }
                if (this.fieldAccess != null) {
                    try {
                        List list = (List)this.fieldAccess.get(minecraft.currentScreen);
                        if (list.size() > 0) {
                            list.clear();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Log.instance().warning(e, "Exception occurred setting player gui screen");
                    }
                }
            }
        }
    }

    static {
        ticksSinceActive = 0L;
        moveCameraActive = false;
        moveCameraToEntityID = 0;
        RADIAL_LOCATION = new ResourceLocation("witchery", "textures/gui/radial.png");
        BARK_TEXTURES = new ResourceLocation("witchery", "textures/gui/creatures.png");
        drawItems = new RenderItem();
        glyphOffsetX = new int[]{0, 0, 1, -1, 1, -1, -1, 1};
        glyphOffsetY = new int[]{-1, 1, 0, 0, -1, 1, -1, 1};
        TEXTURE_GRID = new ResourceLocation("witchery", "textures/gui/grid.png");
    }
}

