/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.entity.EntityNightmare;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.SoundEffect;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PotionWakingNightmare
extends PotionBase
implements IHandleLivingUpdate {
    public PotionWakingNightmare(int id, int color) {
        super(id, true, color);
    }

    @Override
    public void postContructInitialize() {
        this.setPermenant();
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 3L && entity.dimension != Config.instance().dimensionDreamID && world.rand.nextInt(amplifier > 3 ? 30 : (amplifier > 1 ? 60 : 180)) == 0) {
            double R = 16.0;
            double H = 8.0;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(entity.posX - 16.0), (double)(entity.posY - 8.0), (double)(entity.posZ - 16.0), (double)(entity.posX + 16.0), (double)(entity.posY + 8.0), (double)(entity.posZ + 16.0));
            List entities = world.getEntitiesWithinAABB(EntityNightmare.class, bounds);
            boolean doNothing = false;
            for (EntityNightmare nightmare : entities) {
                if (!nightmare.getVictimName().equalsIgnoreCase(entity.getCommandSenderName())) continue;
                doNothing = true;
                break;
            }
            if (!doNothing) {
                Infusion.spawnCreature(world, EntityNightmare.class, MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY), MathHelper.floor_double((double)entity.posZ), entity, 2, 6, null, SoundEffect.NONE);
            }
        }
    }
}

