/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.PotionBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PotionSunAllergy
extends PotionBase
implements IHandleLivingUpdate {
    public PotionSunAllergy(int id, int color) {
        super(id, true, color);
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        float f;
        if (!world.isRemote && world.getWorldTime() % 20L == 0L && world.isDaytime() && (f = entity.getBrightness(1.0f)) > 0.5f && !entity.isInWater() && world.rand.nextFloat() < f - 0.45f && world.canBlockSeeTheSky(MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY), MathHelper.floor_double((double)entity.posZ))) {
            boolean burnEntity = true;
            ItemStack itemstack = entity.getEquipmentInSlot(4);
            if (itemstack != null && !(entity instanceof EntityPlayer)) {
                if (itemstack.isItemStackDamageable()) {
                    itemstack.setItemDamage(itemstack.getItemDamageForDisplay() + world.rand.nextInt(2));
                    if (itemstack.getItemDamageForDisplay() >= itemstack.getMaxDamage()) {
                        entity.renderBrokenItemStack(itemstack);
                        entity.setCurrentItemOrArmor(4, (ItemStack)null);
                    }
                }
                burnEntity = false;
            }
            if (burnEntity) {
                if (entity instanceof EntityPlayer) {
                    entity.attackEntityFrom(DamageSource.outOfWorld, amplifier >= 3 ? 2.0f : 1.0f);
                } else {
                    entity.setFire(8);
                }
            }
        }
    }
}

