/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.util.BlockActionCircle;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.Coord;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PotionSnowTrail
extends PotionBase {
    public PotionSnowTrail(int id, int color) {
        super(id, color);
    }

    public boolean isReady(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        if (!entity.worldObj.isRemote) {
            for (int l = 0; l < 4; ++l) {
                float temp;
                int k;
                int j;
                int i = MathHelper.floor_double((double)(entity.posX + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                if (entity.worldObj.getBlock(i, j = MathHelper.floor_double((double)entity.posY), k = MathHelper.floor_double((double)(entity.posZ + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)))).getMaterial() != Material.air || !((temp = entity.worldObj.getBiomeGenForCoords(i, k).getFloatTemperature(i, j, k)) < 1.6f) || !Blocks.snow_layer.canPlaceBlockAt(entity.worldObj, i, j, k)) continue;
                entity.worldObj.setBlock(i, j, k, Blocks.snow_layer);
            }
            if (entity instanceof EntitySnowman && entity.worldObj.rand.nextInt(20) == 0) {
                entity.worldObj.createExplosion((Entity)entity, entity.posX, entity.posY, entity.posZ, 3.0f, false);
                Coord coord = new Coord((Entity)entity);
                PotionSnowTrail.createSnowCovering(entity.worldObj, coord.x, coord.y, coord.z, 8, null);
                entity.setDead();
            }
        }
    }

    public static void createSnowCovering(World world, int x, int y, int z, int radius, EntityPlayer source) {
        if (BlockProtect.checkModsForBreakOK(world, x, y, z, (EntityLivingBase)source)) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, int x, int y, int z) {
                    int maxSearch = 8;
                    if (world.isAirBlock(x, y, z)) {
                        for (int i = 1; i < 8; ++i) {
                            int dy = y - i;
                            Block block = world.getBlock(x, dy, z);
                            if (block.getMaterial() == Material.air) continue;
                            this.setBlockToSnow(world, x, dy + 1, z, block);
                            break;
                        }
                    } else {
                        for (int i = 1; i < 8; ++i) {
                            int dy = y + i;
                            Block block = world.getBlock(x, dy, z);
                            if (block.getMaterial() != Material.air) continue;
                            Block blockBelow = world.getBlock(x, dy - 1, z);
                            this.setBlockToSnow(world, x, dy, z, blockBelow);
                            break;
                        }
                    }
                }

                private void setBlockToSnow(World world, int x, int y, int z, Block blockBelow) {
                    if (blockBelow.isOpaqueCube() || blockBelow.getMaterial() == Material.leaves) {
                        world.setBlock(x, y, z, Blocks.snow_layer);
                    }
                }
            }.processFilledCircle(world, x, y, z, radius);
        }
    }
}

