/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.EntityAIEnslaverHurtByTarget;
import com.emoniph.witchery.brewing.potions.IHandleLivingSetAttackTarget;
import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.entity.EntityDemon;
import com.emoniph.witchery.entity.EntityEnt;
import com.emoniph.witchery.entity.EntityImp;
import com.emoniph.witchery.util.EntityUtil;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class PotionEnslaved
extends PotionBase
implements IHandleLivingSetAttackTarget,
IHandleLivingUpdate {
    private static final String ENSLAVER_KEY = "WITCEnslaverName";

    public PotionEnslaved(int id, int color) {
        super(id, true, color);
    }

    @Override
    public void onLivingSetAttackTarget(World world, EntityLiving entity, LivingSetAttackTargetEvent event, int amplifier) {
        String enslaverName;
        if (event.target != null && event.target instanceof EntityPlayer && entity instanceof EntityLiving && (enslaverName = PotionEnslaved.getMobEnslaverName(entity)).equals(event.target.getCommandSenderName())) {
            entity.setAttackTarget(null);
        }
    }

    public static boolean setEnslaverForMob(EntityLiving entity, EntityPlayer player) {
        boolean isEnslaved;
        if (entity == null || player == null) {
            return false;
        }
        String enslaverName = entity.getEntityData().getString(ENSLAVER_KEY);
        boolean bl = isEnslaved = enslaverName != null && !enslaverName.isEmpty();
        if (!isEnslaved || !player.getCommandSenderName().equals(enslaverName)) {
            entity.getEntityData().setString(ENSLAVER_KEY, player.getCommandSenderName());
            entity.addPotionEffect(new PotionEffect(Witchery.Potions.ENSLAVED.id, Integer.MAX_VALUE));
            EntityUtil.dropAttackTarget(entity);
            return true;
        }
        return false;
    }

    public static boolean isMobEnslavedBy(EntityLiving entity, EntityPlayer player) {
        return player != null && entity != null && entity.getEntityData() != null && player.getCommandSenderName().equals(entity.getEntityData().getString(ENSLAVER_KEY));
    }

    public static boolean canCreatureBeEnslaved(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityLiving) {
            return !(entityLiving instanceof IBossDisplayData) && !(entityLiving instanceof EntityGolem) && !(entityLiving instanceof EntityDemon) && !(entityLiving instanceof EntityWitch) && !(entityLiving instanceof EntityImp) && !(entityLiving instanceof EntityEnt);
        }
        return false;
    }

    public static boolean isMobEnslaved(EntityLiving entity) {
        if (entity == null) {
            return false;
        }
        String enslaverName = entity.getEntityData().getString(ENSLAVER_KEY);
        return enslaverName != null && !enslaverName.isEmpty();
    }

    public static String getMobEnslaverName(EntityLiving entity) {
        if (entity == null) {
            return "";
        }
        String enslaverName = entity.getEntityData().getString(ENSLAVER_KEY);
        return enslaverName;
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 3L && entity instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)entity;
            for (Object obj : creature.targetTasks.taskEntries) {
                EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                if (!(task.action instanceof EntityAIEnslaverHurtByTarget)) continue;
                return;
            }
            creature.targetTasks.addTask(1, (EntityAIBase)new EntityAIEnslaverHurtByTarget(creature));
        }
    }
}

