/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.world.World;

public class EntityAIZombieMateNow
extends EntityAIBase {
    private EntityZombie zombieObj;
    private EntityZombie mate;
    private World worldObj;
    private int matingTimeout;
    private boolean mating;
    private boolean begin;

    public EntityAIZombieMateNow(EntityZombie zombie) {
        this.zombieObj = zombie;
        this.worldObj = zombie.worldObj;
        this.setMutexBits(3);
    }

    public void beginMating() {
        this.begin = true;
    }

    public boolean shouldExecute() {
        if (!this.begin) {
            return false;
        }
        EntityZombie zombie = EntityUtil.findNearestEntityWithinAABB(this.worldObj, EntityZombie.class, this.zombieObj.boundingBox.expand(8.0, 3.0, 8.0), (Entity)this.zombieObj);
        if (zombie == null || zombie.isChild()) {
            return false;
        }
        this.mate = zombie;
        return true;
    }

    public void startExecuting() {
        this.matingTimeout = 600;
        this.mating = true;
        this.begin = false;
    }

    public void resetTask() {
        this.mate = null;
        this.mating = false;
        this.begin = false;
    }

    public boolean continueExecuting() {
        boolean keepGoing = this.matingTimeout >= 0;
        return keepGoing;
    }

    public void updateTask() {
        --this.matingTimeout;
        this.zombieObj.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
        if (this.zombieObj.getDistanceSqToEntity((Entity)this.mate) > 2.25) {
            this.zombieObj.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 1.4);
        } else if (this.matingTimeout == 0 && this.mating) {
            this.giveBirth();
        }
    }

    private void giveBirth() {
        ParticleEffect.HEART.send(SoundEffect.NONE, (Entity)this.mate, 1.0, 2.0, 8);
        this.zombieObj.setVillager(true);
        this.mate.setVillager(true);
        EntityZombie baby = new EntityZombie(this.worldObj);
        baby.setLocationAndAngles(this.mate.posX, this.mate.posY, this.mate.posZ, 0.0f, 0.0f);
        baby.setChild(true);
        this.worldObj.spawnEntityInWorld((Entity)baby);
    }
}

