/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.PotionEnslaved;
import com.emoniph.witchery.util.EntityUtil;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAIEnslaverHurtByTarget
extends EntityAITarget {
    EntityCreature enslavedEntity;
    EntityLivingBase enslaversAttacker;
    private int enslaversRevengeTimer;

    public EntityAIEnslaverHurtByTarget(EntityCreature enslavedCreature) {
        super(enslavedCreature, false);
        this.enslavedEntity = enslavedCreature;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (!this.enslavedEntity.isPotionActive(Witchery.Potions.ENSLAVED)) {
            return false;
        }
        String ownerName = PotionEnslaved.getMobEnslaverName((EntityLiving)this.enslavedEntity);
        if (ownerName == null || ownerName.isEmpty()) {
            return false;
        }
        EntityPlayer enslaver = this.enslavedEntity.worldObj.getPlayerEntityByName(ownerName);
        if (enslaver == null) {
            return false;
        }
        this.enslaversAttacker = enslaver.getAITarget();
        int revengeTimer = enslaver.func_142015_aE();
        if (revengeTimer == this.enslaversRevengeTimer) {
            return false;
        }
        if (this.enslaversAttacker == null) {
            return false;
        }
        return this.isSuitableTarget(this.enslaversAttacker, false);
    }

    public void startExecuting() {
        EntityUtil.setTarget((EntityLiving)this.taskOwner, this.enslaversAttacker);
        String enslaverName = PotionEnslaved.getMobEnslaverName((EntityLiving)this.enslavedEntity);
        EntityPlayer enslaver = this.enslavedEntity.worldObj.getPlayerEntityByName(enslaverName);
        if (enslaver != null) {
            this.enslaversRevengeTimer = enslaver.func_142015_aE();
        }
        super.startExecuting();
    }
}

