/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.brewing.EntityBrew;
import com.emoniph.witchery.brewing.ModifiersEffect;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.item.ItemBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBrew
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    protected IIcon itemIconOverlay;
    @SideOnly(value=Side.CLIENT)
    protected IIcon itemIconSplash;

    public ItemBrew() {
        this.setMaxStackSize(8);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.registerWithCreativeTab = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.itemIconOverlay;
        }
        return stack == null || WitcheryBrewRegistry.INSTANCE.isSplash(stack.getTagCompound()) ? this.itemIconSplash : this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        this.itemIconOverlay = iconRegister.registerIcon("witchery:brew_overlay");
        this.itemIconSplash = iconRegister.registerIcon("witchery:brew_splash");
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null) {
            return nbtRoot.getString("BrewName");
        }
        return super.getItemStackDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (pass == 0) {
            NBTTagCompound nbtRoot = stack.getTagCompound();
            return WitcheryBrewRegistry.INSTANCE.getBrewColor(nbtRoot);
        }
        return super.getColorFromItemStack(stack, pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean expanded) {
        String localText;
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null && (localText = nbtRoot.getString("BrewInfo")) != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.common;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        int DEFAULT_SPEED = 32;
        NBTTagCompound nbtRoot = stack.getTagCompound();
        int drinkSpeed = nbtRoot != null ? nbtRoot.getInteger("BrewDrinkSpeed") : 32;
        return drinkSpeed > 0 ? drinkSpeed : 32;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        if (WitcheryBrewRegistry.INSTANCE.isSplash(stack.getTagCompound())) {
            return EnumAction.bow;
        }
        return EnumAction.drink;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (WitcheryBrewRegistry.INSTANCE.isSplash(stack.getTagCompound())) {
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)new EntityBrew(world, (EntityLivingBase)player, stack, false));
            }
        } else {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        if (!world.isRemote) {
            ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, null, false, 0, player);
            WitcheryBrewRegistry.INSTANCE.applyToEntity(world, (EntityLivingBase)player, stack.getTagCompound(), modifiers);
        }
        if (!player.capabilities.isCreativeMode) {
            if (stack.stackSize <= 0) {
                return new ItemStack(Items.glass_bottle);
            }
            player.inventory.addItemStackToInventory(new ItemStack(Items.glass_bottle));
        }
        return stack;
    }
}

