/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.brewing.ModifiersEffect;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.EntityUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityDroplet
extends Entity {
    private int field_145788_c = -1;
    private int field_145786_d = -1;
    private int field_145787_e = -1;
    private Block field_145785_f;
    protected boolean inGround;
    public int throwableShake;
    private int ticksInGround;
    private int ticksInAir;
    private NBTTagCompound nbtBrew;
    private int color;

    public EntityDroplet(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    public EntityDroplet(World world, double x, double y, double z, NBTTagCompound nbtBrew) {
        super(world);
        this.ticksInGround = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(x, y, z);
        this.yOffset = 0.0f;
        this.nbtBrew = nbtBrew;
        this.setColor(WitcheryBrewRegistry.INSTANCE.getBrewColor(nbtBrew));
    }

    protected void entityInit() {
        this.dataWatcher.addObject(6, (Object)0);
    }

    protected void setColor(int color) {
        this.getDataWatcher().updateObject(6, (Object)color);
    }

    public int getColor() {
        return this.getDataWatcher().getWatchableObjectInt(6);
    }

    public NBTTagCompound getBrew() {
        return this.nbtBrew;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distSq) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public void setThrowableHeading(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float f2 = MathHelper.sqrt_double((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        p_70186_1_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_3_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_5_ += this.rand.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        this.motionX = p_70186_1_ *= (double)p_70186_7_;
        this.motionY = p_70186_3_ *= (double)p_70186_7_;
        this.motionZ = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.sqrt_double((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(motionX * motionX + motionZ * motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(motionY, f) * 180.0 / Math.PI);
        }
    }

    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.worldObj.getBlock(this.field_145788_c, this.field_145786_d, this.field_145787_e) == this.field_145785_f) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setDead();
                }
                return;
            }
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3 vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3, vec31);
        vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        if (movingobjectposition != null) {
            vec31 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
        }
        if (!this.worldObj.isRemote) {
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.canBeCollidedWith() || this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand((double)(f = 0.3f), (double)f, (double)f)).calculateIntercept(vec3, vec31)) == null || !((d1 = vec3.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.worldObj.getBlock(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ) == Blocks.portal) {
                this.setInPortal();
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f1) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.getGravityVelocity();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f4, this.posY - this.motionY * (double)f4, this.posZ - this.motionZ * (double)f4, this.motionX, this.motionY, this.motionZ);
            }
            f2 = 0.8f;
        }
        this.motionX *= (double)f2;
        this.motionY *= (double)f2;
        this.motionZ *= (double)f2;
        this.motionY -= (double)f3;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            this.worldObj.playAuxSFX(1016, MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), this.getColor());
            if (mop != null) {
                ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, new EntityPosition(this), true, 1, EntityUtil.playerOrFake(this.worldObj, (EntityLivingBase)((EntityPlayer)null)));
                switch (mop.typeOfHit) {
                    case BLOCK: {
                        WitcheryBrewRegistry.INSTANCE.applyToBlock(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, ForgeDirection.getOrientation((int)mop.sideHit), 1, this.nbtBrew, modifiers);
                        break;
                    }
                    case ENTITY: {
                        if (!(mop.entityHit instanceof EntityLivingBase)) break;
                        WitcheryBrewRegistry.INSTANCE.applyToEntity(this.worldObj, (EntityLivingBase)mop.entityHit, this.nbtBrew, modifiers);
                        break;
                    }
                }
            }
        }
        this.setDead();
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setShort("xTile", (short)this.field_145788_c);
        nbtRoot.setShort("yTile", (short)this.field_145786_d);
        nbtRoot.setShort("zTile", (short)this.field_145787_e);
        nbtRoot.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.field_145785_f));
        nbtRoot.setByte("shake", (byte)this.throwableShake);
        nbtRoot.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.nbtBrew != null) {
            nbtRoot.setTag("Brew", this.nbtBrew.copy());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        this.field_145788_c = nbtRoot.getShort("xTile");
        this.field_145786_d = nbtRoot.getShort("yTile");
        this.field_145787_e = nbtRoot.getShort("zTile");
        this.field_145785_f = Block.getBlockById((int)(nbtRoot.getByte("inTile") & 0xFF));
        this.throwableShake = nbtRoot.getByte("shake") & 0xFF;
        boolean bl = this.inGround = nbtRoot.getByte("inGround") == 1;
        if (nbtRoot.hasKey("Brew", 10)) {
            this.nbtBrew = (NBTTagCompound)nbtRoot.getCompoundTag("Brew").copy();
            this.setColor(WitcheryBrewRegistry.INSTANCE.getBrewColor(nbtRoot));
        }
        if (this.nbtBrew == null) {
            this.setDead();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }
}

