/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BlockSlurp
extends BlockBaseContainer {
    public BlockSlurp() {
        super(Material.glass, TileEntitySlurp.class);
        this.registerWithCreateTab = false;
    }

    public int getRenderType() {
        return -1;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canCollideCheck(int p_149678_1_, boolean p_149678_2_) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int metadata, float chance, int fortune) {
    }

    public void replaceBlockAt(World world, int x, int y, int z, int timeoutTicks) {
        Block block;
        if (!world.isRemote && BlockProtect.canBreak(block = world.getBlock(x, y, z), world) && BlockProtect.checkModsForBreakOK(world, x, y, z, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)))) {
            int meta = world.getBlockMetadata(x, y, z);
            world.setBlock(x, y, z, (Block)Witchery.Blocks.SLURP);
            TileEntitySlurp tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntitySlurp.class);
            if (tile != null) {
                tile.saveBlock(timeoutTicks, block, meta);
            }
        }
    }

    public static class TileEntitySlurp
    extends TileEntityBase {
        private Block savedBlock;
        private int savedMeta;
        private int timeout;

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && this.ticks >= (long)this.timeout) {
                if (this.savedBlock == null) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                } else {
                    this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, this.savedBlock, Math.max(this.savedMeta, 0), 3);
                }
            }
        }

        public void saveBlock(int timeoutTicks, Block block) {
            this.saveBlock(timeoutTicks, block, 0);
        }

        public void saveBlock(int timeoutTicks, Block block, int meta) {
            this.savedBlock = block;
            this.savedMeta = meta;
            this.timeout = timeoutTicks;
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setInteger("Timeout", Math.max(this.timeout, 0));
            if (this.savedBlock != null) {
                nbtRoot.setString("blockName", Block.blockRegistry.getNameForObject((Object)this.savedBlock));
                nbtRoot.setInteger("blockMeta", this.savedMeta);
            }
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            String blockName;
            super.readFromNBT(nbtRoot);
            this.timeout = Math.max(nbtRoot.getInteger("Timeout"), 0);
            this.savedBlock = null;
            this.savedMeta = 0;
            if (nbtRoot.hasKey("blockName") && (blockName = nbtRoot.getString("blockName")) != null && !blockName.isEmpty()) {
                this.savedBlock = Block.getBlockFromName((String)blockName);
                this.savedMeta = nbtRoot.getInteger("blockMeta");
            }
        }
    }
}

