/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.brewing.ModifiersEffect;
import com.emoniph.witchery.brewing.TileEntityBrewFluid;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.EntityUtil;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockBrewLiquidEffect
extends BlockBaseContainer
implements IFluidBlock {
    protected static final Map<Block, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<Block, Boolean> displacements = Maps.newHashMap();
    protected int quantaPerBlock = 6;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected int renderPass = 1;
    protected int maxScaledLight = 0;
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;
    protected final String fluidName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public BlockBrewLiquidEffect() {
        super(Material.water, TileEntityBrewFluid.class);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setTickRandomly(true);
        this.registerWithCreateTab = false;
        this.disableStats();
        Fluid fluid = Witchery.Fluids.BREW_LIQUID;
        this.fluidName = fluid.getName();
        this.density = fluid.getDensity();
        this.temperature = fluid.getTemperature();
        this.maxScaledLight = fluid.getLuminosity();
        this.tickRate = fluid.getViscosity() / 200;
        this.densityDir = fluid.getDensity() > 0 ? -1 : 1;
        fluid.setBlock((Block)this);
        this.stack = new FluidStack(fluid, 1000);
        this.displacements.putAll(defaultDisplacements);
    }

    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        TileEntityBrewFluid fluid = BlockUtil.getTileEntity(world, x, y, z, TileEntityBrewFluid.class);
        if (fluid != null) {
            return fluid.color;
        }
        return 68;
    }

    public BlockBrewLiquidEffect setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockBrewLiquidEffect setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side != 0 && side != 1 ? this.icons[1] : this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[]{iconRegister.registerIcon(this.getTextureName() + "_still"), iconRegister.registerIcon(this.getTextureName() + "_flow")};
    }

    public BlockBrewLiquidEffect setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockBrewLiquidEffect setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockBrewLiquidEffect setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockBrewLiquidEffect setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockBrewLiquidEffect setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockBrewLiquidEffect setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.getBlock(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        if (world.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        Material material = block.getMaterial();
        if (material.blocksMovement() || material == Material.portal) {
            return false;
        }
        int density = BlockBrewLiquidEffect.getDensity(world, x, y, z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z).isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (world.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
                return true;
            }
            return false;
        }
        Material material = block.getMaterial();
        if (material.blocksMovement() || material == Material.portal) {
            return false;
        }
        int density = BlockBrewLiquidEffect.getDensity((IBlockAccess)world, x, y, z);
        if (density == Integer.MAX_VALUE) {
            block.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            return true;
        }
        return this.density > density;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate);
    }

    public boolean func_149698_L() {
        return false;
    }

    public boolean getBlocksMovement(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return null;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }

    public int tickRate(World world) {
        return this.tickRate;
    }

    public void velocityToAddToEntity(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        if (this.densityDir > 0) {
            return;
        }
        Vec3 vec_flow = this.getFlowVector((IBlockAccess)world, x, y, z);
        vec.xCoord += vec_flow.xCoord * (double)(this.quantaPerBlock * 4);
        vec.yCoord += vec_flow.yCoord * (double)(this.quantaPerBlock * 4);
        vec.zCoord += vec_flow.zCoord * (double)(this.quantaPerBlock * 4);
    }

    public int getRenderType() {
        return Witchery.proxy.getBrewLiquidRenderId();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getMixedBrightnessForBlock(IBlockAccess world, int x, int y, int z) {
        int lightThis = world.getLightBrightnessForSkyBlocks(x, y, z, 0);
        int lightUp = world.getLightBrightnessForSkyBlocks(x, y + 1, z, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    public int getRenderBlockPass() {
        return this.renderPass;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.getBlock(x, y, z);
        if (block != this) {
            return !block.isOpaqueCube();
        }
        return block.getMaterial() == this.getMaterial() ? false : super.shouldSideBeRendered(world, x, y, z, side);
    }

    public static final int getDensity(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (!(block instanceof BlockBrewLiquidEffect)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockBrewLiquidEffect)block).density;
    }

    public static final int getTemperature(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (!(block instanceof BlockBrewLiquidEffect)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockBrewLiquidEffect)block).temperature;
    }

    public static double getFlowDirection(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (!block.getMaterial().isLiquid()) {
            return -1000.0;
        }
        Vec3 vec = ((BlockBrewLiquidEffect)block).getFlowVector(world, x, y, z);
        return vec.xCoord == 0.0 && vec.zCoord == 0.0 ? -1000.0 : Math.atan2(vec.zCoord, vec.xCoord) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(IBlockAccess world, int x, int y, int z, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(IBlockAccess world, int x, int y, int z, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(IBlockAccess world, int x, int y, int z) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public Vec3 getFlowVector(IBlockAccess world, int x, int y, int z) {
        Vec3 vec = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.getBlock(x2, y, z2).getMaterial().blocksMovement() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.addVector((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.addVector((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (world.getBlock(x, y + 1, z) == this) {
            boolean flag;
            boolean bl = flag = this.isBlockSolid(world, x, y, z - 1, 2) || this.isBlockSolid(world, x, y, z + 1, 3) || this.isBlockSolid(world, x - 1, y, z, 4) || this.isBlockSolid(world, x + 1, y, z, 5) || this.isBlockSolid(world, x, y + 1, z - 1, 2) || this.isBlockSolid(world, x, y + 1, z + 1, 3) || this.isBlockSolid(world, x - 1, y + 1, z, 4) || this.isBlockSolid(world, x + 1, y + 1, z, 5);
            if (flag) {
                vec = vec.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec = vec.normalize();
        return vec;
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.fluidName);
    }

    public float getFilledPercentage(World world, int x, int y, int z) {
        int quantaRemaining = this.getQuantaValue((IBlockAccess)world, x, y, z) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        if (world.getBlock(x, y, z) == Blocks.air) {
            return 0;
        }
        if (world.getBlock(x, y, z) != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - world.getBlockMetadata(x, y, z);
        return quantaRemaining;
    }

    public boolean canCollideCheck(int meta, boolean fullHit) {
        return fullHit && meta == 0;
    }

    public int getMaxRenderHeightMeta() {
        return 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y, z);
        }
        int data = this.quantaPerBlock - world.getBlockMetadata(x, y, z) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    private boolean isTargetBlock(World world, Block block, int x, int y, int z) {
        return block != null && (block != Blocks.air || world.getBlock(x, y - 1, z).getMaterial().isSolid()) && block != this;
    }

    public boolean isFlowingVertically(IBlockAccess world, int x, int y, int z) {
        return world.getBlock(x, y + this.densityDir, z) == this || world.getBlock(x, y, z) == this && this.canFlowInto(world, x, y + this.densityDir, z);
    }

    public boolean isSourceBlock(IBlockAccess world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this && world.getBlockMetadata(x, y, z) == 0;
    }

    protected boolean[] getOptimalFlowDirections(World world, int x, int y, int z) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock((IBlockAccess)world, x2, y2, z2)) continue;
            this.flowCost[side2] = this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2) ? 0 : this.calculateFlowCost(world, x2, y2, z2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, int x, int y, int z, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (adjSide) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock((IBlockAccess)world, x2, y2, z2)) continue;
            if (this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x2, y2, z2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta, TileEntityBrewFluid sourceFluid) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y, z)) {
            world.setBlock(x, y, z, (Block)this, meta, 3);
            TileEntityBrewFluid targetFluid = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBrewFluid.class);
            if (targetFluid != null && sourceFluid != null && sourceFluid.nbtEffect != null) {
                targetFluid.nbtEffect = (NBTTagCompound)sourceFluid.nbtEffect.copy();
                targetFluid.expansion = sourceFluid.expansion;
                targetFluid.color = sourceFluid.color;
                targetFluid.duration = sourceFluid.duration;
                targetFluid.thrower = sourceFluid.thrower;
            }
        }
    }

    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        if (world.getBlock(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        Block block = world.getBlock(x, y, z);
        if (block == this) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        Material material = block.getMaterial();
        if (material.blocksMovement() || material == Material.water || material == Material.lava || material == Material.portal) {
            return false;
        }
        int density = BlockBrewLiquidEffect.getDensity(world, x, y, z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(IBlockAccess world, int x, int y, int z, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    public FluidStack drain(World world, int x, int y, int z, boolean doDrain) {
        return null;
    }

    public boolean canDrain(World world, int x, int y, int z) {
        return false;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isRemote) {
            return;
        }
        boolean evaporated = false;
        TileEntityBrewFluid fluid = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBrewFluid.class);
        if (!world.isRemote && fluid != null && this.isSourceBlock((IBlockAccess)world, x, y, z)) {
            if (++fluid.updateCount > 3 && (fluid.duration == 0 || rand.nextInt(fluid.duration) == 0)) {
                world.setBlockToAir(x, y, z);
                evaporated = true;
            } else {
                world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate);
            }
        }
        if (!evaporated) {
            int quantaRemaining = this.quantaPerBlock - world.getBlockMetadata(x, y, z);
            int expQuanta = -101;
            if (quantaRemaining < this.quantaPerBlock) {
                int y2 = y - this.densityDir;
                if (world.getBlock(x, y2, z) == this || world.getBlock(x - 1, y2, z) == this || world.getBlock(x + 1, y2, z) == this || world.getBlock(x, y2, z - 1) == this || world.getBlock(x, y2, z + 1) == this) {
                    expQuanta = this.quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (expQuanta <= 0) {
                        world.setBlock(x, y, z, Blocks.air);
                    } else {
                        world.setBlockMetadataWithNotify(x, y, z, this.quantaPerBlock - expQuanta, 3);
                        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate);
                        world.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                    }
                }
            } else if (quantaRemaining >= this.quantaPerBlock) {
                world.setBlockMetadataWithNotify(x, y, z, 0, 2);
            }
            if (this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z)) {
                this.flowIntoBlock(world, x, y + this.densityDir, z, 1, fluid);
                return;
            }
            int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
            if (flowMeta >= this.quantaPerBlock) {
                return;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
                boolean[] flowTo;
                if (world.getBlock(x, y - this.densityDir, z) == this) {
                    flowMeta = 1;
                }
                if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                    this.flowIntoBlock(world, x - 1, y, z, flowMeta, fluid);
                }
                if (flowTo[1]) {
                    this.flowIntoBlock(world, x + 1, y, z, flowMeta, fluid);
                }
                if (flowTo[2]) {
                    this.flowIntoBlock(world, x, y, z - 1, flowMeta, fluid);
                }
                if (flowTo[3]) {
                    this.flowIntoBlock(world, x, y, z + 1, flowMeta, fluid);
                }
            }
            if (fluid != null && fluid.nbtEffect != null) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    int x2 = x + direction.offsetX;
                    int y2 = y + direction.offsetY;
                    int z2 = z + direction.offsetZ;
                    if (!(world.rand.nextDouble() < 0.01) || !this.isTargetBlock(world, world.getBlock(x2, y2, z2), x2, y2, z2)) continue;
                    ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, new EntityPosition((double)x + 0.5, (double)y, (double)z + 0.5), false, 0, EntityUtil.playerOrFake(world, fluid.thrower));
                    ++modifiers.strengthPenalty;
                    WitcheryBrewRegistry.INSTANCE.applyToBlock(world, x2, y2, z2, direction.getOpposite(), 1, fluid.nbtEffect, modifiers);
                }
                world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate);
            }
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        TileEntityBrewFluid liquid;
        if (entity != null && entity instanceof EntityLivingBase && !world.isRemote && world.rand.nextInt(10) == 4 && (liquid = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBrewFluid.class)) != null && liquid.nbtEffect != null) {
            EntityLivingBase living = (EntityLivingBase)entity;
            WitcheryBrewRegistry.INSTANCE.applyToEntity(world, living, liquid.nbtEffect, new ModifiersEffect(0.25, 0.5, false, new EntityPosition(x, y, z), false, 0, EntityUtil.playerOrFake(world, liquid.thrower)));
        }
    }

    static {
        defaultDisplacements.put(Blocks.wooden_door, false);
        defaultDisplacements.put(Blocks.iron_door, false);
        defaultDisplacements.put(Blocks.standing_sign, false);
        defaultDisplacements.put(Blocks.wall_sign, false);
        defaultDisplacements.put(Blocks.reeds, false);
    }
}

