/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseBush;
import com.emoniph.witchery.entity.EntityMandrake;
import com.emoniph.witchery.network.PacketParticles;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TargetPointUtil;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWitchCrop
extends BlockBaseBush
implements IGrowable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private ItemStack seedItemPrototype;
    private ItemStack cropItemPrototype;
    private final int growthStages;
    private final boolean waterPlant;
    private final boolean canFertilize;
    private static final int MIN_LIGHT_LEVEL = 9;
    private static final double NIGHT_MANDRAKE_SPAWN_CHANCE = 0.1;
    private static final double DAY_MANDRAKE_SPAWN_CHANCE = 0.9;

    public BlockWitchCrop(boolean waterPlant) {
        this(waterPlant, 4, true);
    }

    public BlockWitchCrop(boolean waterPlant, int growthStages, boolean canFertilize) {
        super(Material.plants);
        this.registerWithCreateTab = false;
        this.growthStages = growthStages;
        this.waterPlant = waterPlant;
        this.canFertilize = canFertilize;
        this.setTickRandomly(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
        this.setHardness(0.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.disableStats();
    }

    public BlockWitchCrop setSeedItem(ItemStack stack) {
        this.seedItemPrototype = stack;
        return this;
    }

    public BlockWitchCrop setCropItem(ItemStack stack) {
        this.cropItemPrototype = stack != null ? stack : this.seedItemPrototype.copy();
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.iconArray = new IIcon[this.getNumGrowthStages() + 1];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.registerIcon(this.getTextureName() + "_stage_" + i);
        }
    }

    protected boolean canPlaceBlockOn(Block block) {
        return this.waterPlant ? block == Blocks.water : block == Blocks.grass || block == Blocks.dirt || block == Blocks.farmland || block == this || block == Witchery.Blocks.CROP_WORMWOOD;
    }

    public int getNumGrowthStages() {
        return this.growthStages;
    }

    public void updateTick(World world, int posX, int posY, int posZ, Random rand) {
        super.updateTick(world, posX, posY, posZ, rand);
        if (world.getBlockLightValue(posX, posY + 1, posZ) >= 9) {
            Block blockBelow;
            int l = world.getBlockMetadata(posX, posY, posZ);
            if (l < this.getNumGrowthStages()) {
                float f = this.getGrowthRate(world, posX, posY, posZ);
                if (rand.nextInt((int)(25.0f / f) + 1) == 0) {
                    world.setBlockMetadataWithNotify(posX, posY, posZ, ++l, 2);
                }
            } else if (this == Witchery.Blocks.CROP_WORMWOOD && (blockBelow = BlockUtil.getBlock(world, posX, posY - 1, posZ)) != this && world.isAirBlock(posX, posY + 1, posZ)) {
                BlockUtil.setBlock(world, posX, posY + 1, posZ, (Block)this, 0, 3);
            }
        }
    }

    public boolean fertilize(World world, int posX, int posY, int posZ) {
        if (!world.isRemote) {
            int stages = this.getNumGrowthStages();
            int current = world.getBlockMetadata(posX, posY, posZ);
            if (current == stages) {
                return false;
            }
            int l = !this.canFertilize ? current + 1 : current + MathHelper.getRandomIntegerInRange((Random)world.rand, (int)2, (int)stages);
            if (l > stages) {
                l = stages;
            }
            world.setBlockMetadataWithNotify(posX, posY, posZ, l, 2);
            return true;
        }
        return false;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean flag) {
        return world.getBlockMetadata(x, y, z) != this.getNumGrowthStages();
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.fertilize(world, x, y, z);
    }

    private float getGrowthRate(World world, int posX, int posY, int posZ) {
        float f = 1.0f;
        Block l = world.getBlock(posX, posY, posZ - 1);
        Block i1 = world.getBlock(posX, posY, posZ + 1);
        Block j1 = world.getBlock(posX - 1, posY, posZ);
        Block k1 = world.getBlock(posX + 1, posY, posZ);
        Block l1 = world.getBlock(posX - 1, posY, posZ - 1);
        Block i2 = world.getBlock(posX + 1, posY, posZ - 1);
        Block j2 = world.getBlock(posX + 1, posY, posZ + 1);
        Block k2 = world.getBlock(posX - 1, posY, posZ + 1);
        boolean flag = j1 == this || k1 == this;
        boolean flag1 = l == this || i1 == this;
        boolean flag2 = l1 == this || i2 == this || j2 == this || k2 == this;
        for (int l2 = posX - 1; l2 <= posX + 1; ++l2) {
            for (int i3 = posZ - 1; i3 <= posZ + 1; ++i3) {
                Block j3 = world.getBlock(l2, posY - 1, i3);
                float f1 = 0.0f;
                if (j3 != null && j3.canSustainPlant((IBlockAccess)world, l2, posY - 1, i3, ForgeDirection.UP, (IPlantable)this)) {
                    f1 = 1.0f;
                    if (j3.isFertile(world, l2, posY - 1, i3)) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != posX || i3 != posZ) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        if (this.cropItemPrototype.getItem() == Witchery.Items.SEEDS_MINDRAKE) {
            f /= 1.5f;
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        int stages = this.getNumGrowthStages();
        if (par2 < 0 || par2 > stages) {
            par2 = stages;
        }
        return this.iconArray != null ? this.iconArray[par2] : null;
    }

    public int getRenderType() {
        return this == Witchery.Blocks.CROP_SNOWBELL || this == Witchery.Blocks.CROP_WOLFSBANE || this == Witchery.Blocks.CROP_WORMWOOD ? 1 : 6;
    }

    protected ItemStack getSeedItemStack() {
        return this.seedItemPrototype.copy();
    }

    protected ItemStack getCropItemStack() {
        return this.cropItemPrototype.copy();
    }

    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        super.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, par6, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret;
        block7: {
            block4: {
                block5: {
                    block6: {
                        ret = new ArrayList<ItemStack>();
                        Block block = world.getBlock(x, y, z);
                        if (metadata < this.getNumGrowthStages()) break block4;
                        if (!(!Witchery.Items.GENERIC.itemMandrakeRoot.isMatch(this.cropItemPrototype) || world.difficultySetting == EnumDifficulty.PEACEFUL || world.provider.isDaytime() && world.rand.nextDouble() > 0.9) && (world.provider.isDaytime() || !(world.rand.nextDouble() > 0.1))) break block5;
                        if (this.cropItemPrototype.getItem() != Witchery.Items.SEEDS_MINDRAKE) break block6;
                        ret.add(this.getSeedItemStack());
                        if (world.rand.nextInt(4) == 0) {
                            ret.add(this.getCropItemStack());
                        }
                        break block7;
                    }
                    for (int n = 0; n < 3 + fortune; ++n) {
                        if (world.rand.nextInt(15) > 7) continue;
                        ret.add(this.getSeedItemStack());
                    }
                    for (int i = 0; i < this.quantityDropped(world.rand); ++i) {
                        ret.add(this.getCropItemStack());
                    }
                    if (this.seedItemPrototype.getItem() != Witchery.Items.SEEDS_SNOWBELL || !(world.rand.nextDouble() <= 0.2)) break block7;
                    ret.add(Witchery.Items.GENERIC.itemIcyNeedle.createStack());
                    break block7;
                }
                if (world.isRemote) break block7;
                EntityMandrake mandrake = new EntityMandrake(world);
                mandrake.setLocationAndAngles(0.5 + (double)x, 0.05 + (double)y, 0.5 + (double)z, 0.0f, 0.0f);
                world.spawnEntityInWorld((Entity)mandrake);
                Witchery.packetPipeline.sendToAllAround(new PacketParticles(ParticleEffect.EXPLODE, SoundEffect.NONE, (Entity)mandrake, 0.5, 1.0), TargetPointUtil.from((Entity)mandrake, 16.0));
                break block7;
            }
            for (int i = 0; i < this.quantityDropped(world.rand); ++i) {
                ret.add(this.getSeedItemStack());
            }
        }
        return ret;
    }

    protected void dropBlockAsItem(World p_149642_1_, int p_149642_2_, int p_149642_3_, int p_149642_4_, ItemStack p_149642_5_) {
        if (!p_149642_1_.isRemote && p_149642_1_.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(p_149642_1_.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(p_149642_1_.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(p_149642_1_.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(p_149642_1_, (double)p_149642_2_ + d0, (double)p_149642_3_ + d1, (double)p_149642_4_ + d2, p_149642_5_);
            entityitem.delayBeforeCanPickup = 10;
            if (p_149642_5_ != null && p_149642_5_.getItem() == Witchery.Items.SEEDS_MINDRAKE) {
                entityitem.lifespan = TimeUtil.secsToTicks(3);
            }
            p_149642_1_.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public Item getItemDropped(int par1, Random rand, int par3) {
        return par1 == this.getNumGrowthStages() ? this.cropItemPrototype.getItem() : this.seedItemPrototype.getItem();
    }

    public int damageDropped(int par1) {
        return par1 == this.getNumGrowthStages() ? this.cropItemPrototype.getItemDamage() : this.seedItemPrototype.getItemDamage();
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.seedItemPrototype;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        if (this.waterPlant) {
            return EnumPlantType.Water;
        }
        return super.getPlantType(world, x, y, z);
    }
}

