/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.INullSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlockVoidBramble
extends BlockBaseContainer {
    public BlockVoidBramble() {
        super(Material.plants, TileEntityVoidBramble.class);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setLightLevel(0.125f);
        this.setStepSound(Block.soundTypeGrass);
        float f = 0.45f;
        this.setBlockBounds(0.050000012f, 0.0f, 0.050000012f, 0.95f, 1.0f, 0.95f);
    }

    public int getRenderType() {
        return 6;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void onEntityCollidedWithBlock(World world, int posX, int posY, int posZ, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            BlockVoidBramble.teleportRandomly(world, posX, posY, posZ, entity, 500);
        }
    }

    public static void teleportRandomly(World world, int posX, int posY, int posZ, Entity entity, int distance) {
        int doubleDistance = distance * 2;
        posX += world.rand.nextInt(doubleDistance) - distance;
        posZ += world.rand.nextInt(doubleDistance) - distance;
        int maxY = Math.min(posY + 64, 250);
        while (!world.getBlock(posX, posY, posZ).getMaterial().isSolid() && posY >= 0) {
            --posY;
        }
        while (!(world.getBlock(posX, posY, posZ).getMaterial().isSolid() && world.getBlock(posX, posY, posZ) != Blocks.bedrock && world.isAirBlock(posX, posY + 1, posZ) && world.isAirBlock(posX, posY + 2, posZ) && world.isAirBlock(posX, posY + 3, posZ) || posY >= maxY)) {
            ++posY;
        }
        if (posY > 0 && posY < maxY) {
            ItemGeneral.teleportToLocation(world, 0.5 + (double)posX, 1.0 + (double)posY, 0.5 + (double)posZ, world.provider.dimensionId, entity, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(2) == 0) {
            double d0 = (float)x + rand.nextFloat();
            double d1 = (double)((float)y + 0.15f + rand.nextFloat() * 0.3f) + 0.5;
            double d2 = (float)z + rand.nextFloat();
            world.spawnParticle(ParticleEffect.PORTAL.toString(), d0, d1, d2, 0.0, -1.2, 0.0);
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityVoidBramble tile;
        if (!world.isRemote && (tile = (TileEntityVoidBramble)world.getTileEntity(x, y, z)) != null && (player.capabilities.isCreativeMode || player.getCommandSenderName().equals(tile.getOwner()))) {
            int dy = y;
            while (world.getBlock(x, dy, z) == this) {
                world.setBlockToAir(x, dy, z);
                world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)dy, 0.5 + (double)z, new ItemStack((Block)this)));
                ++dy;
            }
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityVoidBramble tile = (TileEntityVoidBramble)world.getTileEntity(x, y, z);
            if (tile != null) {
                tile.setOwner(player.getCommandSenderName());
            }
        }
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityVoidBramble();
    }

    public static class TileEntityVoidBramble
    extends TileEntityBase
    implements INullSource {
        private String owner;
        private static final String OWNER_KEY = "WITCPlacer";

        @Override
        public boolean isPowerInvalid() {
            return this.isInvalid();
        }

        @Override
        protected void initiate() {
            super.initiate();
            if (!this.worldObj.isRemote) {
                if (this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) == Witchery.Blocks.VOID_BRAMBLE) {
                    Log.instance().debug("Initiating void bramble tile at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                    PowerSources.instance().registerNullSource(this);
                } else {
                    Log.instance().warning("Void bramble tile entity exists without a corresponding block at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                }
            }
        }

        public void invalidate() {
            super.invalidate();
            if (!this.worldObj.isRemote) {
                Log.instance().debug("Invalidating void bramble tile at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                PowerSources.instance().removeNullSource(this);
            }
        }

        public void setOwner(String username) {
            this.owner = username;
        }

        public String getOwner() {
            return this.owner != null ? this.owner : "";
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            nbtTag.setString(OWNER_KEY, this.getOwner());
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            this.owner = nbtTag.hasKey(OWNER_KEY) ? nbtTag.getString(OWNER_KEY) : "";
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        @Override
        public World getWorld() {
            return this.worldObj;
        }

        @Override
        public int getPosX() {
            return this.xCoord;
        }

        @Override
        public int getPosY() {
            return this.yCoord;
        }

        @Override
        public int getPosZ() {
            return this.zCoord;
        }

        @Override
        public float getRange() {
            return 32.0f;
        }
    }
}

