/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBase;
import com.emoniph.witchery.util.MultiItemBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStockade
extends BlockBase {
    public static final String[] WOOD_TEXTURES = new String[]{"log_oak", "log_spruce", "log_birch", "log_jungle", "witchery:log_rowan", "witchery:log_alder", "witchery:log_hawthorn", "log_acacia", "log_big_oak"};
    public static final String[] WOOD_NAMES = new String[]{"oak", "spruce", "birch", "jungle", "rowan", "alder", "hawthorn", "acacia", "big_oak"};
    public static final String[] ICE_TEXTURES = new String[]{"ice"};
    public static final String[] ICE_NAMES = new String[]{"ice"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] tree;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] tree_top;
    private final boolean alpha;
    private boolean tipTexturing;

    public int damageDropped(int metadata) {
        if (metadata < 0 || metadata >= (this.alpha ? ICE_NAMES.length : WOOD_NAMES.length)) {
            metadata = 0;
        }
        return metadata;
    }

    public BlockStockade(boolean alpha) {
        super(alpha ? Material.ice : Material.wood, ClassItemBlock.class);
        this.setHardness(25.0f);
        this.setResistance(20.0f);
        this.alpha = alpha;
    }

    public int getRenderType() {
        return Witchery.proxy.getStockageRenderId();
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.attackEntityFrom(DamageSource.cactus, 3.0f);
        }
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB bb, List list, Entity entity) {
        boolean connectN = this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1);
        boolean connectS = this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1);
        boolean connectW = this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z);
        boolean connectE = this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z);
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.375f;
        float f3 = 0.625f;
        if (connectN) {
            f2 = 0.0f;
        }
        if (connectS) {
            f3 = 1.0f;
        }
        if (!(connectN || connectS || connectE || connectW)) {
            this.setBlockBounds(0.3f, 0.0f, 0.3f, 0.7f, 0.9f, 0.7f);
            super.addCollisionBoxesToList(world, x, y, z, bb, list, entity);
        }
        if (connectN || connectS) {
            this.setBlockBounds(0.3f, 0.0f, 0.05f, 0.7f, connectE || connectW ? 1.0f : 0.9f, 0.95f);
            super.addCollisionBoxesToList(world, x, y, z, bb, list, entity);
        }
        if (connectE || connectW) {
            this.setBlockBounds(0.05f, 0.0f, 0.3f, 0.55f, connectN || connectS ? 1.0f : 0.9f, 0.7f);
            super.addCollisionBoxesToList(world, x, y, z, bb, list, entity);
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        boolean connectN = this.canConnectFenceTo(world, x, y, z - 1);
        boolean connectS = this.canConnectFenceTo(world, x, y, z + 1);
        boolean connectW = this.canConnectFenceTo(world, x - 1, y, z);
        boolean connectE = this.canConnectFenceTo(world, x + 1, y, z);
        float f = 0.3f;
        float f1 = 0.3f;
        float f2 = 0.7f;
        float f3 = 0.7f;
        if (connectN || connectS) {
            f1 = 0.05f;
            f3 = 0.95f;
        }
        if (connectE || connectW) {
            f = 0.05f;
            f2 = 0.95f;
        }
        this.setBlockBounds(f, 0.0f, f1, f2, !(!connectN && !connectS || !connectW && !connectE) ? 1.0f : 0.9f, f3);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderBlockPass() {
        return this.alpha ? 1 : super.getRenderBlockPass();
    }

    public boolean getBlocksMovement(IBlockAccess p_149655_1_, int p_149655_2_, int p_149655_3_, int p_149655_4_) {
        return false;
    }

    public boolean canConnectFenceTo(IBlockAccess p_149826_1_, int p_149826_2_, int p_149826_3_, int p_149826_4_) {
        Block block = p_149826_1_.getBlock(p_149826_2_, p_149826_3_, p_149826_4_);
        return block == this || block == Blocks.fence_gate || block == Witchery.Blocks.PERPETUAL_ICE_FENCE_GATE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (world.getBlock(x, y, z) == this) {
            if (side == 1) {
                boolean sideZ;
                boolean aboveX = world.getBlock(x + 1, y, z) == this || world.getBlock(x - 1, y, z) == this;
                boolean aboveZ = world.getBlock(x, y, z + 1) == this || world.getBlock(x, y, z - 1) == this;
                boolean sideX = world.getBlock(x + 1, y - 1, z) == this || world.getBlock(x - 1, y - 1, z) == this;
                boolean bl = sideZ = world.getBlock(x, y - 1, z + 1) == this || world.getBlock(x, y - 1, z - 1) == this;
                if (aboveX && sideX && aboveZ && sideZ) {
                    return false;
                }
                if (sideX && !aboveX) {
                    return true;
                }
                return sideZ && !aboveZ;
            }
            if (side == 0) {
                boolean aboveZ;
                boolean sideX = world.getBlock(x + 1, y, z) == this || world.getBlock(x - 1, y, z) == this;
                boolean sideZ = world.getBlock(x, y, z + 1) == this || world.getBlock(x, y, z - 1) == this;
                boolean aboveX = world.getBlock(x + 1, y + 1, z) == this || world.getBlock(x - 1, y + 1, z) == this;
                boolean bl = aboveZ = world.getBlock(x, y + 1, z + 1) == this || world.getBlock(x, y + 1, z - 1) == this;
                if (aboveX && sideX && aboveZ && sideZ) {
                    return false;
                }
                if (sideX && !aboveX) {
                    return true;
                }
                return sideZ && !aboveZ;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta < 0 || meta >= (this.alpha ? ICE_TEXTURES.length : WOOD_TEXTURES.length)) {
            meta = 0;
        }
        return side == 1 || side == 0 || this.tipTexturing ? this.tree_top[meta] : this.tree[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < (this.alpha ? ICE_TEXTURES.length : WOOD_TEXTURES.length); ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.tree = new IIcon[this.alpha ? ICE_TEXTURES.length : WOOD_TEXTURES.length];
        this.tree_top = new IIcon[this.alpha ? ICE_TEXTURES.length : WOOD_TEXTURES.length];
        if (this.alpha) {
            for (int i = 0; i < this.tree.length; ++i) {
                this.tree[i] = iconRegister.registerIcon(ICE_TEXTURES[i]);
                this.tree_top[i] = iconRegister.registerIcon(ICE_TEXTURES[i] + (ICE_TEXTURES[i].equals("ice") ? "" : "_top"));
            }
        } else {
            for (int i = 0; i < this.tree.length; ++i) {
                this.tree[i] = iconRegister.registerIcon(WOOD_TEXTURES[i]);
                this.tree_top[i] = iconRegister.registerIcon(WOOD_TEXTURES[i] + "_top");
            }
        }
    }

    public void setTipTexture(boolean b) {
        this.tipTexturing = b;
    }

    public static class ClassItemBlock
    extends MultiItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        @Override
        protected String[] getNames() {
            return ((BlockStockade)this.field_150939_a).alpha ? ICE_NAMES : WOOD_NAMES;
        }
    }
}

