/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStatueWerewolf
extends BlockBaseContainer {
    public BlockStatueWerewolf() {
        super(Material.rock, TileEntityStatueWerewolf.class);
        this.setResistance(1000.0f);
        this.setHardness(2.5f);
        this.setStepSound(soundTypeStone);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        switch (MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) {
            case 0: {
                world.setBlockMetadataWithNotify(x, y, z, 2, 2);
                break;
            }
            case 1: {
                world.setBlockMetadataWithNotify(x, y, z, 5, 2);
                break;
            }
            case 2: {
                world.setBlockMetadataWithNotify(x, y, z, 3, 2);
                break;
            }
            case 3: {
                world.setBlockMetadataWithNotify(x, y, z, 4, 2);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            TileEntityStatueWerewolf statue = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityStatueWerewolf.class);
            if (statue != null) {
                int meta = world.getBlockMetadata(x, y, z);
                ForgeDirection direction = ForgeDirection.getOrientation((int)meta);
                ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                ItemStack heldStack = player.getHeldItem();
                SoundEffect.WITCHERY_MOB_WOLFMAN_LORD.playOnlyTo(player, 1.0f, 1.0f);
                int level = playerEx.getWerewolfLevel();
                int GOLD_REQUIRED = 3;
                if (level >= 2 && heldStack != null && heldStack.getItem() == Items.gold_ingot && heldStack.stackSize >= 3) {
                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.mooncharmcrafted", new Object[0]);
                    heldStack.splitStack(3);
                    EntityItem itemEntity = new EntityItem(world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, new ItemStack(Witchery.Items.MOON_CHARM));
                    itemEntity.motionZ = 0.0;
                    itemEntity.motionY = 0.0;
                    itemEntity.motionX = 0.0;
                    world.spawnEntityInWorld((Entity)itemEntity);
                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_ORB, (Entity)itemEntity, 0.2, 0.2, 16);
                } else {
                    switch (level) {
                        case 0: {
                            ParticleEffect.MOB_SPELL.send(SoundEffect.NONE, (Entity)player, 1.0, 1.0, 16);
                            player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, TimeUtil.secsToTicks(60), 0));
                            ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.notworthy", new Object[0]);
                            break;
                        }
                        case 1: {
                            if (heldStack != null && heldStack.getItem() == Items.gold_ingot) {
                                if (heldStack.stackSize >= 3) {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level2complete", new Object[0]);
                                    heldStack.splitStack(3);
                                    EntityItem itemEntity = new EntityItem(world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, new ItemStack(Witchery.Items.MOON_CHARM));
                                    itemEntity.motionZ = 0.0;
                                    itemEntity.motionY = 0.0;
                                    itemEntity.motionX = 0.0;
                                    world.spawnEntityInWorld((Entity)itemEntity);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, (Entity)itemEntity, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                    break;
                                }
                                ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level2progress", Integer.valueOf(3).toString(), Integer.valueOf(3 - heldStack.stackSize).toString());
                                break;
                            }
                            ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level2begin", Integer.valueOf(3).toString());
                            break;
                        }
                        case 2: {
                            int MUTTON_REQUIRED = 30;
                            if (heldStack != null && Witchery.Items.GENERIC.itemMuttonRaw.isMatch(heldStack)) {
                                if (heldStack.stackSize >= 30) {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level3complete", new Object[0]);
                                    heldStack.splitStack(30);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                    break;
                                }
                                ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level3progress", Integer.valueOf(30).toString(), Integer.valueOf(30 - heldStack.stackSize).toString());
                                break;
                            }
                            ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level3begin", Integer.valueOf(30).toString());
                            break;
                        }
                        case 3: {
                            int TONGUES_REQUIRED = 10;
                            if (heldStack != null && Witchery.Items.GENERIC.itemDogTongue.isMatch(heldStack)) {
                                if (heldStack.stackSize >= 10) {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level4complete", new Object[0]);
                                    heldStack.splitStack(10);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                    break;
                                }
                                ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level4progress", Integer.valueOf(10).toString(), Integer.valueOf(10 - heldStack.stackSize).toString());
                                break;
                            }
                            ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level4begin", Integer.valueOf(10).toString());
                            break;
                        }
                        case 4: {
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level5begin", new Object[0]);
                                    EntityItem itemEntity = new EntityItem(world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, new ItemStack(Witchery.Items.HORN_OF_THE_HUNT));
                                    itemEntity.motionZ = 0.0;
                                    itemEntity.motionY = 0.0;
                                    itemEntity.motionX = 0.0;
                                    world.spawnEntityInWorld((Entity)itemEntity);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_FIZZ, (Entity)itemEntity, 0.2, 0.2, 16);
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level5progress", new Object[0]);
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level5complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 5: {
                            int KILLS_REQUIRED = 10;
                            if (playerEx.getWolfmanQuestCounter() >= 10) {
                                playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                            }
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level6begin", Integer.valueOf(10).toString());
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level6progress", Integer.valueOf(10).toString(), Integer.valueOf(10 - playerEx.getWolfmanQuestCounter()).toString());
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level6complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 6: {
                            int PLACES_HOWLED_AT = 16;
                            if (playerEx.getWolfmanQuestCounter() >= 16) {
                                playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                            }
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level7begin", Integer.valueOf(16).toString());
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level7progress", Integer.valueOf(16).toString(), Integer.valueOf(16 - playerEx.getWolfmanQuestCounter()).toString());
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level7complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 7: {
                            int WOLVES_TAMED = 6;
                            if (playerEx.getWolfmanQuestCounter() >= 6) {
                                playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                            }
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level8begin", Integer.valueOf(6).toString());
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level8progress", Integer.valueOf(6).toString(), Integer.valueOf(6 - playerEx.getWolfmanQuestCounter()).toString());
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level8complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 8: {
                            int PIGMEN_KILLED = 30;
                            if (playerEx.getWolfmanQuestCounter() >= 30) {
                                playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                            }
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level9begin", Integer.valueOf(30).toString());
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level9progress", Integer.valueOf(30).toString(), Integer.valueOf(30 - playerEx.getWolfmanQuestCounter()).toString());
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level9complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 9: {
                            boolean PEOPLE_KILLED = true;
                            if (playerEx.getWolfmanQuestCounter() >= 1) {
                                playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                            }
                            switch (playerEx.getWolfmanQuestState()) {
                                case NOT_STATED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level10begin", Integer.valueOf(1).toString());
                                    playerEx.setWolfmanQuestState(ExtendedPlayer.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level10progress", Integer.valueOf(1).toString(), Integer.valueOf(1 - playerEx.getWolfmanQuestCounter()).toString());
                                    break;
                                }
                                case COMPLETE: {
                                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level10complete", new Object[0]);
                                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_LEVELUP, world, (double)direction.offsetX + 0.5 + (double)x, 1.1 + (double)y, 0.5 + (double)z + (double)direction.offsetZ, 0.2, 0.2, 16);
                                    playerEx.increaseWerewolfLevel();
                                }
                            }
                            break;
                        }
                        case 10: {
                            SoundEffect.WITCHERY_MOB_WOLFMAN_LORD.playOnlyTo(player, 1.0f, 1.0f);
                            ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)player, "witchery.werewolf.level10complete", new Object[0]);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    public static class TileEntityStatueWerewolf
    extends TileEntity {
        public boolean canUpdate() {
            return false;
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
        }
    }
}

