/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityGoblinGulg;
import com.emoniph.witchery.entity.EntityGoblinMog;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.InfusionInfernal;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStatueOfWorship
extends BlockBaseContainer {
    public BlockStatueOfWorship() {
        super(Material.rock, TileEntityStatueOfWorship.class, ClassItemBlock.class);
        this.setHardness(3.5f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeStone);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public String getLocalizedName() {
        return super.getLocalizedName();
    }

    public void onBlockPlacedBy(World world, int posX, int posY, int posZ, EntityLivingBase player, ItemStack stack) {
        String playerName;
        NBTTagCompound nbtRoot;
        TileEntityStatueOfWorship tile;
        int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 2, 2);
        } else if (l == 1) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 5, 2);
        } else if (l == 2) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 3, 2);
        } else if (l == 3) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 4, 2);
        }
        if (stack != null && player instanceof EntityPlayer && (tile = BlockUtil.getTileEntity((IBlockAccess)world, posX, posY, posZ, TileEntityStatueOfWorship.class)) != null && (nbtRoot = stack.getTagCompound()) != null && nbtRoot.hasKey("WITCBoundPlayer") && (playerName = nbtRoot.getString("WITCBoundPlayer")) != null && !playerName.isEmpty()) {
            tile.setOwner(playerName);
        }
    }

    public void onBlockAdded(World world, int posX, int posY, int posZ) {
        super.onBlockAdded(world, posX, posY, posZ);
        BlockUtil.setBlockDefaultDirection(world, posX, posY, posZ);
    }

    public void onBlockHarvested(World world, int posX, int posY, int posZ, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.capabilities.isCreativeMode) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, par5 |= 8, 4);
        }
        this.dropBlockAsItem(world, posX, posY, posZ, par5, 0);
        super.onBlockHarvested(world, posX, posY, posZ, par5, par6EntityPlayer);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityStatueOfWorship tile;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((metadata & 8) == 0 && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityStatueOfWorship.class)) != null) {
            ItemStack stack = new ItemStack(tile.getBlockType());
            NBTTagCompound nbtRoot = new NBTTagCompound();
            stack.setTagCompound(nbtRoot);
            nbtRoot.setString("WITCBoundPlayer", tile.owner != null ? tile.owner : "");
            drops.add(stack);
        }
        return drops;
    }

    private static String getBoundPlayerName(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null) {
            return nbtRoot.getString("WITCBoundPlayer");
        }
        return "";
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hiyY, float hitZ) {
        if (!world.isRemote) {
            int worshippers;
            TileEntityStatueOfWorship tile;
            ItemStack item = player.getHeldItem();
            if (item != null && item.getItem() == Items.nether_star && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityStatueOfWorship.class)) != null && tile.owner != null && tile.owner.equals(player.getCommandSenderName()) && (worshippers = tile.updateWorshippersAndGetLevel()) >= 5 && tile.summonGoblinGods(player, 16.0, 8)) {
                if (!player.capabilities.isCreativeMode) {
                    if (--item.stackSize <= 0) {
                        player.setCurrentItemOrArmor(0, null);
                    }
                    double R = 8.0;
                    AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)((double)x + 0.5 - R), (double)((double)y + 0.5 - R), (double)((double)z + 0.5 - R), (double)((double)x + 0.5 + R), (double)((double)y + 0.5 + R), (double)((double)z + 0.5 + R));
                    List entities = world.getEntitiesWithinAABB(EntityGoblin.class, bb);
                    int iMax = Math.min(entities.size(), 5);
                    for (int i = 0; i < iMax; ++i) {
                        if (!(entities.get(i) instanceof EntityGoblin)) continue;
                        EntityGoblin goblin = (EntityGoblin)entities.get(i);
                        goblin.attackEntityFrom(DamageSource.magic, goblin.getMaxHealth());
                    }
                }
                ParticleEffect.FLAME.send(SoundEffect.MOB_ENDERDRAGON_GROWL, world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5, 0.5, 16);
                return true;
            }
            ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5, 0.5, 16);
        }
        return false;
    }

    public static class TileEntityStatueOfWorship
    extends TileEntityBase {
        private String owner;
        @SideOnly(value=Side.CLIENT)
        private ThreadDownloadImageData downloadImageSkin;
        @SideOnly(value=Side.CLIENT)
        private ResourceLocation locationSkin;

        public void setOwner(EntityPlayer player) {
            this.owner = player.getCommandSenderName();
            if (!this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public void setOwner(String player) {
            this.owner = player;
            if (!this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public boolean hasOwner() {
            return this.owner != null && !this.owner.isEmpty();
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setString("Owner", this.owner != null ? this.owner : "");
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
            this.owner = nbtRoot.getString("Owner");
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getLocationSkin() {
            if (this.locationSkin == null) {
                this.setupCustomSkin();
            }
            if (this.locationSkin != null) {
                return this.locationSkin;
            }
            return AbstractClientPlayer.locationStevePng;
        }

        @SideOnly(value=Side.CLIENT)
        private void setupCustomSkin() {
            if (this.owner != null && !this.owner.isEmpty()) {
                this.locationSkin = AbstractClientPlayer.getLocationSkin((String)this.owner);
                this.downloadImageSkin = AbstractClientPlayer.getDownloadImageSkin((ResourceLocation)this.locationSkin, (String)this.owner);
            }
        }

        public int updateWorshippersAndGetLevel() {
            double R = 8.0;
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)((double)this.xCoord + 0.5 - 8.0), (double)((double)this.yCoord + 0.5 - 8.0), (double)((double)this.zCoord + 0.5 - 8.0), (double)((double)this.xCoord + 0.5 + 8.0), (double)((double)this.yCoord + 0.5 + 8.0), (double)((double)this.zCoord + 0.5 + 8.0));
            List entities = this.worldObj.getEntitiesWithinAABB(EntityGoblin.class, bb);
            int worshipCount = 0;
            for (Object entity : entities) {
                if (!(entity instanceof EntityGoblin)) continue;
                EntityGoblin goblin = (EntityGoblin)entity;
                if (goblin.isWorshipping()) {
                    ++worshipCount;
                    continue;
                }
                goblin.beginWorship(this);
            }
            return worshipCount;
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && this.hasOwner()) {
                int PULSE_INTERVAL_IN_SECS = 5;
                if (TimeUtil.secondsElapsed(5, this.ticks)) {
                    int worshipCount = this.updateWorshippersAndGetLevel();
                    EntityPlayerMP player = MinecraftServer.getServer().getConfigurationManager().func_152612_a(this.owner);
                    if (player != null) {
                        ExtendedPlayer playerEx;
                        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
                        int WORSHIP_LEVEL_1 = 5;
                        int WORSHIP_LEVEL_2 = 10;
                        int WORSHIP_LEVEL_3 = 15;
                        if (worshipCount >= 5) {
                            int maxEnergy;
                            int currentEnergy;
                            int RECHARGE_RADIUS = 64;
                            int RECHARGE_RADIUS_SQ = 4096;
                            if (player.getDistanceSq(0.5 + (double)this.xCoord, 0.5 + (double)this.yCoord, 0.5 + (double)this.zCoord) <= 4096.0 && (currentEnergy = Infusion.getCurrentEnergy((EntityPlayer)player)) < (maxEnergy = Infusion.getMaxEnergy((EntityPlayer)player))) {
                                int ENERGY_PER_PULSE = 30;
                                Infusion.setCurrentEnergy((EntityPlayer)player, Math.min(currentEnergy + 30, maxEnergy));
                                ParticleEffect.INSTANT_SPELL.send(SoundEffect.NOTE_PLING, (Entity)player, 1.0, 2.0, 8);
                            }
                        }
                        if (worshipCount >= 10 && (playerEx = ExtendedPlayer.get((EntityPlayer)player)) != null) {
                            playerEx.addWorship(worshipCount >= 15 ? 1 : 0);
                        }
                        double GODS_SUMMON_CHANCE = 0.01 * (double)Config.instance().hobgoblinGodSpawnChance * 0.01;
                        if (worshipCount >= 15 && Config.instance().hobgoblinGodSpawnChance > 0 && this.worldObj.rand.nextDouble() < GODS_SUMMON_CHANCE) {
                            this.summonGoblinGods((EntityPlayer)player, 64.0, 16);
                        }
                    }
                }
            }
        }

        public boolean summonGoblinGods(EntityPlayer player, double detectDistance, int spawnDistance) {
            EntityCreature mog;
            double R2 = detectDistance;
            AxisAlignedBB bb2 = AxisAlignedBB.getBoundingBox((double)((double)this.xCoord + 0.5 - R2), (double)((double)this.yCoord + 0.5 - R2), (double)((double)this.zCoord + 0.5 - R2), (double)((double)this.xCoord + 0.5 + R2), (double)((double)this.yCoord + 0.5 + R2), (double)((double)this.zCoord + 0.5 + R2));
            if (this.worldObj.getEntitiesWithinAABB(EntityGoblinMog.class, bb2).size() == 0 && this.worldObj.getEntitiesWithinAABB(EntityGoblinGulg.class, bb2).size() == 0 && (mog = InfusionInfernal.spawnCreature(this.worldObj, EntityGoblinMog.class, this.xCoord, this.yCoord, this.zCoord, (EntityLivingBase)player, 0, spawnDistance, ParticleEffect.FLAME, SoundEffect.MOB_WITHER_SPAWN)) != null) {
                mog.onSpawnWithEgg(null);
                mog.setAttackTarget((EntityLivingBase)player);
                EntityGoblinGulg gulg = new EntityGoblinGulg(this.worldObj);
                gulg.setLocationAndAngles(mog.posX, mog.posY, mog.posZ, 0.0f, 0.0f);
                this.worldObj.spawnEntityInWorld((Entity)gulg);
                gulg.onSpawnWithEgg(null);
                gulg.setAttackTarget((EntityLivingBase)player);
                return true;
            }
            return false;
        }
    }

    public static class ClassItemBlock
    extends ItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        public String getItemStackDisplayName(ItemStack stack) {
            String s = super.getItemStackDisplayName(stack);
            String player = BlockStatueOfWorship.getBoundPlayerName(stack);
            if (player != null && !player.isEmpty()) {
                return s + " (" + player + ")";
            }
            return s;
        }
    }
}

