/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.entity.EntityFollower;
import com.emoniph.witchery.entity.EntityMirrorFace;
import com.emoniph.witchery.entity.EntityReflection;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.item.ItemSunGrenade;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import com.emoniph.witchery.util.TransformCreature;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockMirror
extends BlockBaseContainer {
    private final boolean unbreakable;
    private static String sendMeHome = null;
    private static String iGiveUp = null;

    public BlockMirror(boolean unbreakable) {
        super(Material.glass, TileEntityMirror.class);
        this.unbreakable = unbreakable;
        this.registerWithCreateTab = false;
        this.setLightLevel(0.7f);
        this.disableStats();
        this.setStepSound(soundTypeGlass);
        if (unbreakable) {
            this.setBlockUnbreakable();
            this.setResistance(9999.0f);
        } else {
            this.setHardness(1.0f);
            this.setResistance(9999.0f);
        }
    }

    public static int getDirection(int meta) {
        return meta & 3;
    }

    public static boolean isBlockTopOfMirror(int meta) {
        return (meta & 4) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean trySayMirrorMirrorSendMeHome(EntityPlayer player, String message) {
        if (player == null || player.worldObj.isRemote || player.dimension != Config.instance().dimensionMirrorID) {
            return false;
        }
        if (sendMeHome == null) {
            sendMeHome = Witchery.resource("witchery.rite.mirrormirrorsendmehome").toLowerCase().replace("'", "").replace(",", "").trim();
        }
        if (iGiveUp == null) {
            iGiveUp = Witchery.resource("witchery.rite.mirrormirrorigiveup").toLowerCase().replace("'", "").replace(",", "").trim();
        }
        ExtendedPlayer playerEx = ExtendedPlayer.get(player);
        if (message.toLowerCase().replace("'", "").replace(",", "").trim().startsWith(sendMeHome)) {
            if (playerEx.canEscapeMirrorWorld(1)) {
                Coord c = playerEx.getMirrorWorldEntryPoint();
                if (c == null) return false;
                playerEx.escapedMirrorWorld(1);
                player.setPositionAndRotation(player.posX, player.posY, player.posZ, 270.0f, player.rotationPitch);
                ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                ItemGeneral.teleportToLocation(player.worldObj, 0.5 + (double)c.x, 0.01 + (double)c.y, 0.5 + (double)c.z, player.dimension, (Entity)player, true, ParticleEffect.SPLASH, SoundEffect.RANDOM_SPLASH);
                return true;
            }
            ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.mirrormirror.escapecooldown", Long.valueOf(playerEx.getCooldownSecs(1)).toString());
            return true;
        }
        if (!message.toLowerCase().replace("'", "").replace(",", "").trim().startsWith(iGiveUp)) return false;
        if (playerEx.canEscapeMirrorWorld(2)) {
            ChunkCoordinates coords = player.getBedLocation(player.dimension);
            int dimension = player.dimension;
            World world = player.worldObj;
            if (coords == null) {
                coords = player.getBedLocation(0);
                dimension = 0;
                world = MinecraftServer.getServer().worldServerForDimension(0);
                if (coords == null) {
                    coords = world.getSpawnPoint();
                    while (world.getBlock(coords.posX, coords.posY, coords.posZ).isNormalCube() && coords.posY < 255) {
                        ++coords.posY;
                    }
                }
            }
            if (coords == null || (coords = Blocks.bed.getBedSpawnPosition((IBlockAccess)world, coords.posX, coords.posY, coords.posZ, null)) == null) return false;
            playerEx.escapedMirrorWorld(2);
            ItemGeneral cfr_ignored_1 = Witchery.Items.GENERIC;
            ItemGeneral.teleportToLocation(player.worldObj, coords.posX, coords.posY + 1, coords.posZ, dimension, (Entity)player, true);
            return true;
        }
        ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.mirrormirror.escapecooldown", Long.valueOf(playerEx.getCooldownSecs(2)).toString());
        return true;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isRemote && entity.ticksExisted % 5 == 1 && this.isTransportableEntity(entity)) {
            TileEntityMirror tile;
            int i1 = world.getBlockMetadata(x, y, z);
            int hitZoneyShift = 0;
            if (!BlockMirror.isBlockTopOfMirror(i1)) {
                ++y;
                if (entity.height <= 1.0f) {
                    hitZoneyShift = -1;
                }
                if (world.getBlock(x, y, z) != this) {
                    return;
                }
            }
            AxisAlignedBB box = this.getServerSelectedBoundingBoxFromPool(world, x, y + hitZoneyShift, z);
            double f = (double)entity.width * 0.5;
            double f1 = entity.height;
            AxisAlignedBB entityBox = AxisAlignedBB.getBoundingBox((double)(entity.posX - f), (double)(entity.posY - (double)entity.yOffset + (double)entity.ySize), (double)(entity.posZ - f), (double)(entity.posX + f), (double)(entity.posY - (double)entity.yOffset + (double)entity.ySize + f1), (double)(entity.posZ + f));
            if (entityBox.intersectsWith(box) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityMirror.class)) != null) {
                boolean inMirrorWorld;
                int side = BlockMirror.getDirection(world.getBlockMetadata(x, y, z));
                int facing = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                int dx = 0;
                int dz = 0;
                float shift = 0.7f;
                float xShift = 0.0f;
                float zShift = 0.0f;
                int scale = 1;
                int requiredSide = 0;
                boolean isLiving = entity instanceof EntityLivingBase;
                if (side == 0) {
                    dz = scale;
                    zShift = -shift;
                    requiredSide = 1;
                    if (isLiving && facing != 0) {
                        return;
                    }
                } else if (side == 1) {
                    dz = -scale;
                    zShift = shift;
                    requiredSide = 0;
                    if (isLiving && facing != 2) {
                        return;
                    }
                } else if (side == 2) {
                    dx = scale;
                    xShift = -shift;
                    requiredSide = 3;
                    if (isLiving && facing != 3) {
                        return;
                    }
                } else if (side == 3) {
                    dx = -scale;
                    requiredSide = 2;
                    xShift = shift;
                    if (isLiving && facing != 1) {
                        return;
                    }
                }
                boolean bl = inMirrorWorld = entity.dimension == Config.instance().dimensionMirrorID;
                if (!this.unbreakable) {
                    Block block;
                    int nz;
                    int ny;
                    int nx;
                    int i;
                    if (inMirrorWorld || tile.demonKilled) {
                        for (i = 1; i < 32; ++i) {
                            nx = x + dx * i;
                            ny = y;
                            nz = z + dz * i;
                            block = world.getBlock(nx, ny, nz);
                            if (block != this || BlockMirror.getDirection(world.getBlockMetadata(nx, ny, nz)) != requiredSide) continue;
                            ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                            ItemGeneral.teleportToLocation(world, 0.5 + (double)nx - (double)xShift, (double)(ny - 1) + 0.01, 0.5 + (double)nz - (double)zShift, world.provider.dimensionId, entity, true, ParticleEffect.SPLASH, SoundEffect.RANDOM_SPLASH);
                            return;
                        }
                    }
                    if (inMirrorWorld) {
                        for (i = 1; i < 10; ++i) {
                            IPowerSource power;
                            int cz;
                            int cy;
                            int cx;
                            boolean isEntryCell;
                            nx = x + dx * i;
                            ny = y;
                            nz = z + dz * i;
                            if (!world.isAirBlock(nx, ny, nz) || !world.isAirBlock(nx, ny - 1, nz)) continue;
                            boolean isPlayerEntryCell = false;
                            if (entity instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)entity;
                                ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                                isPlayerEntryCell = playerEx.isMirrorWorldEntryPoint(nx, ny, nz);
                            }
                            boolean bl2 = isEntryCell = world.getBlock(cx = (nx >> 4 << 4) + 4, cy = (ny >> 4 << 4) + 8, cz = (nz >> 4 << 4) + 8) == Witchery.Blocks.MIRROR_UNBREAKABLE;
                            if ((!isEntryCell || isPlayerEntryCell) && (power = PowerSources.findClosestPowerSource(world, x, y, z)) != null && power.consumePower(3000.0f)) {
                                ItemGeneral cfr_ignored_1 = Witchery.Items.GENERIC;
                                ItemGeneral.teleportToLocation(world, 0.5 + (double)nx - (double)xShift, (double)ny + 0.01, 0.5 + (double)nz - (double)zShift, world.provider.dimensionId, entity, true, ParticleEffect.SPLASH, SoundEffect.RANDOM_SPLASH);
                            }
                            return;
                        }
                    } else if (tile.demonKilled) {
                        int meta;
                        int dy;
                        for (dy = 2; dy < 16; ++dy) {
                            nx = x;
                            ny = y + dy;
                            nz = z;
                            block = world.getBlock(nx, ny, nz);
                            if (block != this || BlockMirror.getDirection(meta = world.getBlockMetadata(nx, ny, nz)) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                --ny;
                            }
                            ItemGeneral cfr_ignored_2 = Witchery.Items.GENERIC;
                            ItemGeneral.teleportToLocation(world, 0.5 + (double)nx + (double)xShift, (double)ny + 0.01, 0.5 + (double)nz + (double)zShift, world.provider.dimensionId, entity, true, ParticleEffect.SPLASH, SoundEffect.RANDOM_SPLASH);
                            if (entity instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)entity;
                                double yaw = player.rotationYaw + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                S08PacketPlayerPosLook packet = new S08PacketPlayerPosLook(player.posX, player.posY, player.posZ, rev, player.rotationPitch, false);
                                Witchery.packetPipeline.sendTo((Packet)packet, player);
                            }
                            return;
                        }
                        for (dy = 2; dy < 16; ++dy) {
                            nx = x;
                            ny = y - dy;
                            nz = z;
                            block = world.getBlock(nx, ny, nz);
                            if (block != this || BlockMirror.getDirection(meta = world.getBlockMetadata(nx, ny, nz)) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                --ny;
                            }
                            ItemGeneral cfr_ignored_3 = Witchery.Items.GENERIC;
                            ItemGeneral.teleportToLocation(world, 0.5 + (double)nx + (double)xShift, (double)ny + 0.01, 0.5 + (double)nz + (double)zShift, world.provider.dimensionId, entity, true, ParticleEffect.SPLASH, SoundEffect.RANDOM_SPLASH);
                            if (entity instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)entity;
                                double yaw = player.rotationYaw + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                S08PacketPlayerPosLook packet = new S08PacketPlayerPosLook(player.posX, player.posY, player.posZ, rev, player.rotationPitch, false);
                                Witchery.packetPipeline.sendTo((Packet)packet, player);
                            }
                            return;
                        }
                    }
                }
                if (entity instanceof EntityPlayer) {
                    Coord dimCoords;
                    EntityPlayer player = (EntityPlayer)entity;
                    ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                    if ((!inMirrorWorld || playerEx.isMirrorWorldEntryPoint(x, y, z)) && (dimCoords = tile.getDimCoords()) != null) {
                        Block block;
                        float dimX = (float)dimCoords.x + 0.5f;
                        float dimY = (float)dimCoords.y + 0.01f;
                        float dimZ = (float)dimCoords.z + 0.5f;
                        int targetDimension = !inMirrorWorld ? Config.instance().dimensionMirrorID : tile.dim;
                        WorldServer otherWorld = MinecraftServer.getServer().worldServerForDimension(targetDimension);
                        float face = 0.0f;
                        if (otherWorld != null && ((block = otherWorld.getBlock(dimCoords.x, dimCoords.y, dimCoords.z)) == Witchery.Blocks.MIRROR || block == Witchery.Blocks.MIRROR_UNBREAKABLE)) {
                            int mside = BlockMirror.getDirection(otherWorld.getBlockMetadata(dimCoords.x, dimCoords.y, dimCoords.z));
                            float distance = 1.0f;
                            if (mside == 0) {
                                face = 180.0f;
                                dimZ -= distance;
                            } else if (mside == 1) {
                                face = 0.0f;
                                dimZ += distance;
                            } else if (mside == 2) {
                                face = 90.0f;
                                dimX -= distance;
                            } else if (mside == 3) {
                                face = 270.0f;
                                dimX += distance;
                            }
                            player.rotationYaw = face;
                            TileEntityMirror otherTile = BlockUtil.getTileEntity((IBlockAccess)otherWorld, dimCoords.x, dimCoords.y, dimCoords.z, TileEntityMirror.class);
                            if (otherTile != null) {
                                if (otherTile.onCooldown()) {
                                    return;
                                }
                                otherTile.addCooldown(60);
                            }
                        }
                        ParticleEffect.SPLASH.send(SoundEffect.RANDOM_SPLASH, entity, 0.5, 2.0, 16);
                        if (entity.dimension != Config.instance().dimensionMirrorID) {
                            float cellMidZ;
                            double RY;
                            float cellMidY;
                            double R;
                            float cellMidX;
                            AxisAlignedBB bounds;
                            List EntityReflection2;
                            if (!tile.demonKilled && (EntityReflection2 = otherWorld.getEntitiesWithinAABB(EntityReflection.class, bounds = AxisAlignedBB.getBoundingBox((double)((double)(cellMidX = (float)(dimCoords.x + 4)) - (R = 7.0)), (double)((double)(cellMidY = (float)dimCoords.y) - (RY = 6.0)), (double)((double)(cellMidZ = (float)dimCoords.z) - R), (double)((double)cellMidX + R), (double)((double)cellMidY + RY), (double)((double)cellMidZ + R)))).size() == 0) {
                                EntityReflection reflection = new EntityReflection((World)otherWorld);
                                reflection.setPositionAndRotation(0.5 + (double)cellMidX, 1.1 + (double)cellMidY, 0.5 + (double)cellMidZ, 0.0f, 0.0f);
                                reflection.func_110163_bv();
                                reflection.worldObj.spawnEntityInWorld((Entity)reflection);
                            }
                            playerEx.setMirrorWorldEntryPoint(dimCoords.x, dimCoords.y, dimCoords.z);
                            player.setPositionAndRotation((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player.rotationPitch);
                            ItemGeneral cfr_ignored_4 = Witchery.Items.GENERIC;
                            ItemGeneral.travelToDimension(player, Config.instance().dimensionMirrorID);
                            player.setPositionAndUpdate((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else if (tile.isConnected) {
                            player.setPositionAndRotation((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player.rotationPitch);
                            ItemGeneral cfr_ignored_5 = Witchery.Items.GENERIC;
                            ItemGeneral.travelToDimension(player, tile.dim);
                            player.setPositionAndUpdate((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else {
                            double targetX = dimX;
                            double targetY = dimY - 1.0f;
                            double targetZ = dimZ;
                            int targetDim = tile.dim;
                            boolean CHECK_PLAYER_INV = true;
                            MinecraftServer server = MinecraftServer.getServer();
                            for (WorldServer worldServer : server.worldServers) {
                                block5: for (Object obj : worldServer.playerEntities) {
                                    EntityPlayer otherPlayer = (EntityPlayer)obj;
                                    for (ItemStack stack : otherPlayer.inventory.mainInventory) {
                                        boolean isMirror;
                                        if (stack == null || stack.getItem() != Witchery.Items.MIRROR || !(isMirror = tile.isTargettedBy(stack))) continue;
                                        if (otherPlayer.dimension == Config.instance().dimensionMirrorID) continue block5;
                                        targetX = otherPlayer.posX;
                                        targetY = otherPlayer.posY;
                                        targetZ = otherPlayer.posZ;
                                        targetDim = otherPlayer.dimension;
                                        continue block5;
                                    }
                                }
                            }
                            player.setPositionAndRotation(targetX, targetY, targetZ, face, player.rotationPitch);
                            ItemGeneral cfr_ignored_6 = Witchery.Items.GENERIC;
                            ItemGeneral.travelToDimension(player, targetDim);
                            player.setPositionAndUpdate(targetX, targetY, targetZ);
                        }
                        ParticleEffect.SPLASH.send(SoundEffect.RANDOM_SPLASH, entity, 0.5, 2.0, 16);
                    }
                }
            }
        }
    }

    public void demonSlain(World world, double posX, double posY, double posZ) {
        if (!world.isRemote) {
            int z;
            double R = 7.0;
            double RY = 6.0;
            int x = (MathHelper.floor_double((double)posX) >> 4 << 4) + 4;
            int xmid = x + 4;
            int y = (MathHelper.floor_double((double)posY) >> 4 << 4) + 8;
            if (world.getBlock(x, y, z = (MathHelper.floor_double((double)posZ) >> 4 << 4) + 8) == Witchery.Blocks.MIRROR_UNBREAKABLE) {
                TileEntityMirror tile;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)((double)xmid - R), (double)((double)y - RY), (double)((double)z - R), (double)((double)xmid + R), (double)((double)y + RY), (double)((double)z + R));
                List reflections = world.getEntitiesWithinAABB(EntityReflection.class, bounds);
                int livingDemons = 0;
                for (EntityReflection entity : reflections) {
                    if (entity == null || !entity.isEntityAlive()) continue;
                    ++livingDemons;
                }
                if (livingDemons == 0 && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityMirror.class)) != null) {
                    TileEntityMirror otherTile;
                    Coord dimCoords = tile.getDimCoords();
                    int dim = tile.dim;
                    WorldServer otherWorld = MinecraftServer.getServer().worldServerForDimension(dim);
                    if (otherWorld != null && (otherTile = BlockUtil.getTileEntity((IBlockAccess)otherWorld, dimCoords.x, dimCoords.y, dimCoords.z, TileEntityMirror.class)) != null) {
                        otherTile.demonKilled = true;
                    }
                }
            }
        }
    }

    private boolean isTransportableEntity(Entity entity) {
        return !(entity instanceof EntityMirrorFace) && (entity instanceof EntityLivingBase || entity instanceof EntityItem);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (!this.unbreakable) {
            int i1 = world.getBlockMetadata(x, y, z);
            int origX = x;
            int origZ = z;
            if (!BlockMirror.isBlockTopOfMirror(i1) && world.getBlock(x, ++y, z) != this) {
                return true;
            }
            TileEntityMirror tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityMirror.class);
            if (tile != null) {
                tile.depolyDemon(player);
            } else {
                return true;
            }
        }
        return true;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int side = BlockMirror.getDirection(world.getBlockMetadata(x, y, z));
        float w = 0.15f;
        if (side == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.85f, 1.0f, 1.0f, 1.0f);
        } else if (side == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.15f);
        } else if (side == 2) {
            this.setBlockBounds(0.85f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (side == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.15f, 1.0f, 1.0f);
        }
        AxisAlignedBB bounds = super.getCollisionBoundingBoxFromPool(world, x, y, z);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return bounds;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int side = BlockMirror.getDirection(world.getBlockMetadata(x, y, z));
        float w = 0.32f;
        if (side == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.68f, 1.0f, 1.0f, 1.0f);
        } else if (side == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.32f);
        } else if (side == 2) {
            this.setBlockBounds(0.68f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (side == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.32f, 1.0f, 1.0f);
        }
        AxisAlignedBB bounds = super.getSelectedBoundingBoxFromPool(world, x, y, z);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return bounds;
    }

    public AxisAlignedBB getServerSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int side = BlockMirror.getDirection(world.getBlockMetadata(x, y, z));
        float w = 0.32f;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        if (side == 0) {
            minZ = 0.68f;
        } else if (side == 1) {
            maxZ = 0.32f;
        } else if (side == 2) {
            minX = 0.68f;
        } else if (side == 3) {
            maxZ = 0.32f;
        }
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
        return bounds;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = BlockMirror.getDirection(l);
        if (BlockMirror.isBlockTopOfMirror(l)) {
            if (world.getBlock(x, y - 1, z) != this) {
                if (!world.isRemote) {
                    this.dropBlockAsItem(world, x, y, z, l, 0);
                }
                world.setBlockToAir(x, y, z);
            }
        } else if (world.getBlock(x, y + 1, z) != this) {
            world.setBlockToAir(x, y, z);
        }
    }

    public Item getItemDropped(int meta, Random rand, int p_149650_3_) {
        return BlockMirror.isBlockTopOfMirror(meta) ? Witchery.Items.MIRROR : Item.getItemById((int)0);
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int p_149690_5_, float p_149690_6_, int p_149690_7_) {
        if (BlockMirror.isBlockTopOfMirror(p_149690_5_)) {
            super.dropBlockAsItemWithChance(world, x, y, z, p_149690_5_, p_149690_6_, 0);
        }
    }

    public int getMobilityFlag() {
        return super.getMobilityFlag();
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return Witchery.Items.MIRROR;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (player.capabilities.isCreativeMode && BlockMirror.isBlockTopOfMirror(meta)) {
            if (world.getBlock(x, y - 1, z) == this) {
                world.setBlockToAir(x, y - 1, z);
            }
            world.setBlockMetadataWithNotify(x, y, z, meta |= 8, 4);
        }
        this.dropBlockAsItem(world, x, y, z, meta, 0);
        super.onBlockHarvested(world, x, y, z, meta, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        TileEntityMirror tile;
        boolean brokenInCreativeMode;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        boolean bl = brokenInCreativeMode = (meta & 8) != 0;
        if (!brokenInCreativeMode && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityMirror.class)) != null) {
            ItemStack stack = new ItemStack(Witchery.Items.MIRROR);
            NBTTagCompound nbtRoot = new NBTTagCompound();
            tile.writeItemDataToNBT(nbtRoot);
            stack.setTagCompound(nbtRoot);
            if (world.provider.dimensionId != Config.instance().dimensionMirrorID && tile.isDimLinked()) {
                TileEntityMirror otherTile;
                Coord dimCoords = tile.getDimCoords();
                WorldServer otherWorld = MinecraftServer.getServer().worldServerForDimension(Config.instance().dimensionMirrorID);
                if (otherWorld != null && otherWorld.getBlock(dimCoords.x, dimCoords.y, dimCoords.z) == Witchery.Blocks.MIRROR && (otherTile = BlockUtil.getTileEntity((IBlockAccess)otherWorld, dimCoords.x, dimCoords.y, dimCoords.z, TileEntityMirror.class)) != null) {
                    otherTile.isConnected = false;
                    otherTile.markBlockForUpdate(false);
                }
            }
            drops.add(stack);
        }
        return drops;
    }

    public void loadFromItem(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        NBTTagCompound nbtRoot;
        TileEntityMirror tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityMirror.class);
        if (tile != null && (nbtRoot = stack.getTagCompound()) != null) {
            tile.readItemDataFromNBT(nbtRoot);
            if (world.provider.dimensionId != Config.instance().dimensionMirrorID && tile.isDimLinked()) {
                TileEntityMirror otherTile;
                Coord dimCoords = tile.getDimCoords();
                WorldServer otherWorld = MinecraftServer.getServer().worldServerForDimension(Config.instance().dimensionMirrorID);
                if (otherWorld != null && otherWorld.getBlock(dimCoords.x, dimCoords.y, dimCoords.z) == Witchery.Blocks.MIRROR_UNBREAKABLE && (otherTile = BlockUtil.getTileEntity((IBlockAccess)otherWorld, dimCoords.x, dimCoords.y, dimCoords.z, TileEntityMirror.class)) != null) {
                    otherTile.isConnected = true;
                    otherTile.dimCoords = new Coord(x, y, z);
                    otherTile.markBlockForUpdate(false);
                }
            }
        }
    }

    public static class TileEntityMirror
    extends TileEntityBase {
        public int men;
        private Coord dimCoords;
        private int dim;
        private boolean isConnected;
        private boolean demonKilled;
        private GameProfile favorite;
        private UUID fairest;
        private Set<String> playersSeen = new HashSet<String>();
        long cooldown;
        long lastFairestSpawn = 0L;

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (this.ticks % (long)(this.worldObj.isRemote ? 10 : 40) == 1L) {
                int side = BlockMirror.getDirection(this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord));
                int xMin = -1;
                int xMax = 1;
                int zMin = -1;
                int zMax = 1;
                int scale = 4;
                if (side == 0) {
                    zMin = -4;
                    zMax = 0;
                } else if (side == 1) {
                    zMin = 0;
                    zMax = 4;
                } else if (side == 2) {
                    xMin = -4;
                    xMax = 0;
                } else if (side == 3) {
                    xMin = 0;
                    xMax = 4;
                }
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.xCoord + xMin), (double)this.yCoord, (double)(this.zCoord + zMin), (double)(this.xCoord + xMax + 1), (double)(this.yCoord + 1), (double)(this.zCoord + zMax + 1));
                List entities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
                this.men = entities.size();
                if (!this.worldObj.isRemote) {
                    for (EntityLivingBase entity : entities) {
                        if (!(entity instanceof EntityPlayer)) continue;
                        this.playersSeen.add(entity.getCommandSenderName());
                    }
                }
            }
        }

        public void addCooldown(int i) {
            this.cooldown = this.ticks + (long)i;
        }

        public boolean onCooldown() {
            return this.ticks < this.cooldown;
        }

        public boolean isTargettedBy(ItemStack stack) {
            Coord coords;
            NBTTagCompound nbtRoot;
            if (stack != null && stack.getItem() == Witchery.Items.MIRROR && stack.getTagCompound() != null && (nbtRoot = stack.getTagCompound()).hasKey("DimCoords") && nbtRoot.hasKey("Dimension") && this.worldObj.provider.dimensionId == nbtRoot.getInteger("Dimension") && (coords = Coord.fromTagNBT(nbtRoot.getCompoundTag("DimCoords"))) != null) {
                return coords.isMatch(this.xCoord, this.yCoord, this.zCoord);
            }
            return false;
        }

        private void depolyDemon(EntityPlayer player) {
            if (!this.demonKilled && this.worldObj.provider.dimensionId != Config.instance().dimensionMirrorID) {
                if (player.getHeldItem() != null && player.getHeldItem().getItem() == Witchery.Items.TAGLOCK_KIT) {
                    ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                    TransformCreature currentTransform = playerEx.getCreatureType();
                    if (currentTransform == TransformCreature.NONE || currentTransform == TransformCreature.PLAYER) {
                        String username = Witchery.Items.TAGLOCK_KIT.getBoundUsername(player.getHeldItem(), 1);
                        if (username == null || username.isEmpty() || username.equals(player.getCommandSenderName())) {
                            if (currentTransform == TransformCreature.PLAYER) {
                                ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)player, 0.5, 2.0, 16);
                                Shapeshift.INSTANCE.shiftTo(player, TransformCreature.NONE);
                            } else {
                                ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, (Entity)player, 0.5, 2.0, 16);
                            }
                        } else {
                            IPowerSource power = PowerSources.findClosestPowerSource(this);
                            if (power != null && power.consumePower(4000.0f)) {
                                ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)player, 0.5, 2.0, 16);
                                playerEx.setOtherPlayerSkin(username);
                                Shapeshift.INSTANCE.shiftTo(player, TransformCreature.PLAYER);
                            } else {
                                ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, (Entity)player, 0.5, 2.0, 16);
                            }
                        }
                    }
                } else if (player.getHeldItem() != null && Witchery.Items.GENERIC.itemQuartzSphere.isMatch(player.getHeldItem())) {
                    IPowerSource power = PowerSources.findClosestPowerSource(this);
                    if (power != null && power.consumePower(2000.0f)) {
                        ParticleEffect.SMOKE.send(SoundEffect.RANDOM_ORB, (Entity)player, 0.5, 2.0, 16);
                        ItemStack itemstack = player.getHeldItem();
                        if (itemstack.stackSize > 1) {
                            ItemStack newStack = new ItemStack(Witchery.Items.DUP_GRENADE);
                            ItemSunGrenade.setOwnerName(newStack, player.getCommandSenderName());
                            --itemstack.stackSize;
                            if (itemstack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                            }
                            if (!player.inventory.addItemStackToInventory(newStack)) {
                                this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                            } else if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                        } else {
                            ItemStack newStack = new ItemStack(Witchery.Items.DUP_GRENADE);
                            ItemSunGrenade.setOwnerName(newStack, player.getCommandSenderName());
                            player.setCurrentItemOrArmor(0, newStack);
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                        }
                    } else {
                        ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, (Entity)player, 0.5, 2.0, 16);
                    }
                } else {
                    List faces = this.worldObj.getEntitiesWithinAABB(EntityMirrorFace.class, Witchery.Blocks.MIRROR.getCollisionBoundingBoxFromPool(this.worldObj, this.xCoord, this.yCoord, this.zCoord));
                    if (faces.size() == 0) {
                        this.showMirrorHead(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                        ParticleEffect.SPELL_COLORED.send(SoundEffect.WITCHERY_MOB_REFLECTION_SPEECH, this, 0.5, 0.5, 16, 0x7777FF);
                        double RANGE = 64.0;
                        List players = this.worldObj.playerEntities;
                        for (EntityPlayer otherPlayer : players) {
                            if (!(player.getDistanceSq((double)this.xCoord, (double)this.yCoord, (double)this.zCoord) <= RANGE * RANGE)) continue;
                            ChatUtil.sendTranslated((ICommandSender)otherPlayer, "witchery.rite.mirrormirror", player.getCommandSenderName());
                        }
                        boolean fairestFound = false;
                        if (this.fairest != null) {
                            double R = 100.0;
                            double RY = 32.0;
                            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)((double)this.xCoord - 100.0), (double)((double)this.yCoord - 32.0), (double)((double)this.zCoord - 100.0), (double)((double)this.xCoord + 100.0), (double)((double)this.yCoord + 32.0), (double)((double)this.zCoord + 100.0));
                            List followers = this.worldObj.getEntitiesWithinAABB(EntityFollower.class, bounds);
                            for (EntityFollower follower : followers) {
                                if (!follower.getPersistentID().equals(this.fairest) || !follower.isEntityAlive()) continue;
                                this.sayNotFairest(player, follower);
                                fairestFound = true;
                                break;
                            }
                        }
                        if (!fairestFound) {
                            boolean isFairestAllowed = this.worldObj.getTotalWorldTime() > this.lastFairestSpawn + (long)TimeUtil.minsToTicks(2);
                            this.fairest = null;
                            if (this.favorite == null || this.isFavorite(player)) {
                                this.favorite = player.getGameProfile();
                                double CHANCE_OF_NEW_FAIREST = Config.instance().fairestSpawnChance;
                                if (isFairestAllowed && this.worldObj.rand.nextDouble() < CHANCE_OF_NEW_FAIREST) {
                                    EntityFollower follower = new EntityFollower(this.worldObj);
                                    int followerType = this.worldObj.rand.nextInt(4) + 1;
                                    follower.setCustomNameTag(EntityFollower.generateFollowerName(followerType));
                                    follower.func_110163_bv();
                                    follower.setFollowerType(followerType);
                                    Coord coord = null;
                                    int minRange = 50;
                                    block2: for (int i = 0; i < 25 && coord == null; ++i) {
                                        int x = this.xCoord + (this.worldObj.rand.nextBoolean() ? 1 : -1) * (50 + this.worldObj.rand.nextInt(50));
                                        int z = this.zCoord + (this.worldObj.rand.nextBoolean() ? 1 : -1) * (50 + this.worldObj.rand.nextInt(50));
                                        int yMin = Math.max(this.yCoord - 20, 2);
                                        for (int y = Math.min(this.yCoord + 20, 250); y >= yMin; --y) {
                                            if (!this.worldObj.getBlock(x, y, z).isNormalCube() || !this.worldObj.getBlock(x, y + 1, z).getMaterial().isReplaceable() || !this.worldObj.isAirBlock(x, y + 2, z)) continue;
                                            coord = new Coord(x, y, z);
                                            continue block2;
                                        }
                                    }
                                    if (coord != null) {
                                        follower.setPositionAndRotation(0.5 + (double)coord.x, 1.01 + (double)coord.y, 0.5 + (double)coord.z, 0.0f, 0.0f);
                                        this.worldObj.spawnEntityInWorld((Entity)follower);
                                        this.fairest = follower.getPersistentID();
                                        fairestFound = true;
                                        this.lastFairestSpawn = this.worldObj.getTotalWorldTime();
                                        this.sayNotFairest(player, follower);
                                    }
                                }
                                if (!fairestFound) {
                                    ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.you", new Object[0]);
                                }
                            } else {
                                ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.anotherplayer", new Object[0]);
                                EntityPlayer otherPlayer = this.worldObj.getPlayerEntityByName(this.favorite.getName());
                                if (otherPlayer != null) {
                                    this.sayBearing(player, (EntityLivingBase)otherPlayer);
                                }
                            }
                        }
                        if (this.playersSeen.size() > 1) {
                            ArrayList<String> seen = new ArrayList<String>(this.playersSeen);
                            Collections.sort(seen);
                            StringBuffer sb = new StringBuffer();
                            for (String s : seen) {
                                if (s.equals(player.getCommandSenderName())) continue;
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append(s);
                            }
                            if (sb.length() > 0) {
                                ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.playersseen", sb.toString());
                            } else {
                                ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.playersnotseen", new Object[0]);
                            }
                        } else {
                            ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.playersnotseen", new Object[0]);
                        }
                        if (this.isFavorite(player)) {
                            this.playersSeen.clear();
                        }
                    }
                }
            }
        }

        public void sayNotFairest(EntityPlayer player, EntityFollower follower) {
            if (follower.getFollowerType() == 4) {
                ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.anotherm", new Object[0]);
            } else {
                ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.anotherf", new Object[0]);
            }
            this.sayBearing(player, (EntityLivingBase)follower);
        }

        public void sayBearing(EntityPlayer player, EntityLivingBase otherEntity) {
            int bearingIndex;
            double bearingRadians = Math.atan2(0.5 + (double)this.zCoord - otherEntity.posZ, 0.5 + (double)this.xCoord - otherEntity.posX);
            double bearing = (Math.toDegrees(bearingRadians) + 180.0 + 90.0) % 360.0;
            if (bearing < 0.0) {
                bearing += 360.0;
            }
            if ((bearingIndex = (int)bearing / 45) > 7 || bearingIndex < 0) {
                bearingIndex = 0;
            }
            ChatUtil.sendTranslated(EnumChatFormatting.AQUA, (ICommandSender)player, "witchery.rite.mirrormirror.bearing" + bearingIndex, new Object[0]);
        }

        private void showMirrorHead(World world, int x, int y, int z) {
            int side = BlockMirror.getDirection(world.getBlockMetadata(x, y, z));
            float dx = 0.0f;
            float dz = 0.0f;
            float scale = 0.4f;
            float rotation = 0.0f;
            if (side == 0) {
                dz = 0.4f;
                rotation = -90.0f;
            } else if (side == 1) {
                dz = -0.4f;
                rotation = 90.0f;
            } else if (side == 2) {
                dx = 0.4f;
                rotation = 0.0f;
            } else if (side == 3) {
                dx = -0.4f;
                rotation = -90.0f;
            }
            EntityMirrorFace face = new EntityMirrorFace(world);
            face.setPosition((double)x + 0.5 + (double)dx, (double)y + 0.1, (double)z + 0.5 + (double)dz);
            world.spawnEntityInWorld((Entity)face);
        }

        private boolean isDimLinked() {
            return this.dimCoords != null;
        }

        private Coord getDimCoords() {
            WorldServer mworld;
            if (this.dimCoords == null && this.worldObj.provider.dimensionId != Config.instance().dimensionMirrorID && (mworld = MinecraftServer.getServer().worldServerForDimension(Config.instance().dimensionMirrorID)) != null) {
                int[][] map = new int[][]{{0, 1}, {1, 0}};
                int cellX = 0;
                int cellZ = 0;
                int sign = 1;
                for (int i = 0; i < 256; ++i) {
                    for (int spin = 0; spin <= i; ++spin) {
                        for (int j = 0; j < map.length; ++j) {
                            if (i > 0) {
                                cellX += map[j][0] * sign;
                                cellZ += map[j][1] * sign;
                            }
                            int Y_LEVELS = Config.instance().shrinkMirrorWorld ? 8 : 15;
                            for (int cellY = 0; cellY < Y_LEVELS; ++cellY) {
                                int dimX = (cellX << 4) + 4;
                                int dimY = (cellY << 4) + 8;
                                int dimZ = (cellZ << 4) + 8;
                                if (!mworld.isAirBlock(dimX, dimY, dimZ) || !mworld.isAirBlock(dimX, dimY - 1, dimZ)) continue;
                                boolean stop = false;
                                for (int y = dimY - 1; y <= dimY + 6 && !stop; ++y) {
                                    block5: for (int x = dimX; x <= dimX + 8 && !stop; ++x) {
                                        for (int z = dimZ - 4; z <= dimZ + 4 && !stop; ++z) {
                                            Block block = mworld.getBlock(x, y, z);
                                            if (mworld.isAirBlock(x, y, z)) continue;
                                            stop = true;
                                            continue block5;
                                        }
                                    }
                                }
                                if (stop) continue;
                                BlockMirror mirror = Witchery.Blocks.MIRROR_UNBREAKABLE;
                                int meta = 3;
                                mworld.setBlock(dimX, dimY, dimZ, (Block)mirror, meta | 4, 3);
                                TileEntityMirror tile = BlockUtil.getTileEntity((IBlockAccess)mworld, dimX, dimY, dimZ, TileEntityMirror.class);
                                if (tile != null) {
                                    tile.dimCoords = new Coord(this.xCoord, this.yCoord, this.zCoord);
                                    tile.dim = this.worldObj.provider.dimensionId;
                                }
                                if (mworld.getBlock(dimX, dimY, dimZ) == mirror) {
                                    mworld.setBlock(dimX, dimY - 1, dimZ, (Block)mirror, meta, 3);
                                }
                                this.dimCoords = new Coord(dimX, dimY, dimZ);
                                return this.dimCoords;
                            }
                        }
                    }
                    sign *= -1;
                }
            }
            return this.dimCoords;
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            NBTTagCompound nbtTag = packet.func_148857_g();
            this.readFromNBT(nbtTag);
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setLong("LastFairestSpawnTime", this.lastFairestSpawn);
            this.writeItemDataToNBT(nbtRoot);
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
            this.lastFairestSpawn = nbtRoot.getLong("LastFairestSpawnTime");
            this.readItemDataFromNBT(nbtRoot);
        }

        private void writeItemDataToNBT(NBTTagCompound nbtRoot) {
            if (this.dimCoords != null) {
                NBTTagCompound nbtDim = this.dimCoords.toTagNBT();
                nbtDim.setInteger("Dimension", this.dim);
                nbtRoot.setTag("DimCoords", (NBTBase)nbtDim);
            }
            nbtRoot.setBoolean("DemonSlain", this.demonKilled);
            if (this.favorite != null) {
                NBTTagCompound nbtPlayer = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)nbtPlayer, (GameProfile)this.favorite);
                nbtRoot.setTag("Favorite", (NBTBase)nbtPlayer);
            }
            if (this.fairest != null) {
                nbtRoot.setString("Fairest", this.fairest.toString());
            }
            NBTTagList players = new NBTTagList();
            for (String player : this.playersSeen) {
                players.appendTag((NBTBase)new NBTTagString(player));
            }
            nbtRoot.setTag("PlayersSeen", (NBTBase)players);
        }

        public void readItemDataFromNBT(NBTTagCompound nbtRoot) {
            if (nbtRoot.hasKey("DimCoords")) {
                NBTTagCompound nbtDim = nbtRoot.getCompoundTag("DimCoords");
                this.dimCoords = Coord.fromTagNBT(nbtDim);
                this.dim = nbtDim.getInteger("Dimension");
            }
            this.demonKilled = nbtRoot.getBoolean("DemonSlain");
            this.favorite = nbtRoot.hasKey("Favorite", 10) ? NBTUtil.func_152459_a((NBTTagCompound)nbtRoot.getCompoundTag("Favorite")) : null;
            this.fairest = nbtRoot.hasKey("Fairest") ? UUID.fromString(nbtRoot.getString("Fairest")) : null;
            this.playersSeen.clear();
            if (nbtRoot.hasKey("PlayersSeen")) {
                NBTTagList players = nbtRoot.getTagList("PlayersSeen", 8);
                for (int i = 0; i < players.tagCount(); ++i) {
                    this.playersSeen.add(players.getStringTagAt(i));
                }
            }
        }

        public boolean isFavorite(EntityPlayer player) {
            return this.favorite != null && player != null && this.favorite.equals((Object)player.getGameProfile());
        }
    }
}

