/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.util.ChatUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLeechChest
extends BlockBaseContainer {
    private final Random random = new Random();
    public final int chestType;

    public BlockLeechChest() {
        super(Material.rock, TileEntityLeechChest.class);
        this.chestType = 1;
        this.setHardness(25.0f);
        this.setResistance(1000.0f);
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (par1IBlockAccess.getBlock(par2, par3, par4 - 1) == this) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
        } else if (par1IBlockAccess.getBlock(par2, par3, par4 + 1) == this) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
        } else if (par1IBlockAccess.getBlock(par2 - 1, par3, par4) == this) {
            this.setBlockBounds(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        } else if (par1IBlockAccess.getBlock(par2 + 1, par3, par4) == this) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
        } else {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        }
    }

    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        Block l = par1World.getBlock(par2, par3, par4 - 1);
        Block i1 = par1World.getBlock(par2, par3, par4 + 1);
        Block j1 = par1World.getBlock(par2 - 1, par3, par4);
        Block k1 = par1World.getBlock(par2 + 1, par3, par4);
        int b0 = 0;
        int l1 = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l1 == 0) {
            b0 = 2;
        }
        if (l1 == 1) {
            b0 = 5;
        }
        if (l1 == 2) {
            b0 = 3;
        }
        if (l1 == 3) {
            b0 = 4;
        }
        if (l != this && i1 != this && j1 != this && k1 != this) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, b0, 3);
        } else {
            if (!(l != this && i1 != this || b0 != 4 && b0 != 5)) {
                if (l == this) {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 - 1, b0, 3);
                } else {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 + 1, b0, 3);
                }
                par1World.setBlockMetadataWithNotify(par2, par3, par4, b0, 3);
            }
            if (!(j1 != this && k1 != this || b0 != 2 && b0 != 3)) {
                if (j1 == this) {
                    par1World.setBlockMetadataWithNotify(par2 - 1, par3, par4, b0, 3);
                } else {
                    par1World.setBlockMetadataWithNotify(par2 + 1, par3, par4, b0, 3);
                }
                par1World.setBlockMetadataWithNotify(par2, par3, par4, b0, 3);
            }
        }
        TileEntity tile = par1World.getTileEntity(par2, par3, par4);
        if (tile != null && tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest chest = (TileEntityLeechChest)tile;
            if (par6ItemStack.hasDisplayName()) {
                chest.setChestGuiName(par6ItemStack.getDisplayName());
            }
            if (!par1World.isRemote && par6ItemStack.hasTagCompound() && par6ItemStack.getTagCompound().hasKey("WITCPlayers")) {
                NBTTagList nbtPlayersList = par6ItemStack.getTagCompound().getTagList("WITCPlayers", 10);
                chest.players.clear();
                for (int i = 0; i < nbtPlayersList.tagCount(); ++i) {
                    NBTTagCompound nbtPlayer = nbtPlayersList.getCompoundTagAt(i);
                    String s = nbtPlayer.getString("Player");
                    if (s == null || s.isEmpty()) continue;
                    chest.players.add(s);
                }
                chest.sync();
            }
        }
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return true;
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, Block par5) {
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
        TileEntity tile = par1World.getTileEntity(par2, par3, par4);
        if (tile != null && tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest tileentitychest = (TileEntityLeechChest)tile;
            tileentitychest.updateContainingBlockInfo();
        }
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntity tileentity = par1World.getTileEntity(par2, par3, par4);
        if (tileentity != null && tileentity instanceof TileEntityLeechChest) {
            TileEntityLeechChest tileentitychest = (TileEntityLeechChest)tileentity;
            for (int j1 = 0; j1 < tileentitychest.getSizeInventory(); ++j1) {
                ItemStack itemstack = tileentitychest.getStackInSlot(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.stackSize) {
                        k1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.getItem(), k1, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    if (itemstack.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    par1World.spawnEntityInWorld((Entity)entityitem);
                }
            }
            par1World.func_147453_f(par2, par3, par4, par5);
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    public void onBlockHarvested(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (!par1World.isRemote) {
            ItemStack itemstack = new ItemStack((Block)this);
            TileEntity tileentity = par1World.getTileEntity(par2, par3, par4);
            if (tileentity != null && tileentity instanceof TileEntityLeechChest) {
                TileEntityLeechChest chest = (TileEntityLeechChest)tileentity;
                if (chest.players.size() > 0) {
                    itemstack.setTagCompound(new NBTTagCompound());
                    NBTTagList nbtPlayers = new NBTTagList();
                    for (int i = 0; i < chest.players.size(); ++i) {
                        NBTTagCompound nbtPlayer = new NBTTagCompound();
                        nbtPlayer.setString("Player", chest.players.get(i));
                        nbtPlayers.appendTag((NBTBase)nbtPlayer);
                    }
                    itemstack.getTagCompound().setTag("WITCPlayers", (NBTBase)nbtPlayers);
                }
            }
            this.dropBlockAsItem(par1World, par2, par3, par4, itemstack);
        }
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (par1World.isRemote) {
            return true;
        }
        IInventory iinventory = this.getInventory(par1World, par2, par3, par4);
        if (iinventory != null) {
            TileEntity tileEntity = par1World.getTileEntity(par2, par3, par4);
            if (tileEntity != null && tileEntity instanceof TileEntityLeechChest) {
                TileEntityLeechChest chest = (TileEntityLeechChest)tileEntity;
                chest.storePlayer(player);
            }
            player.displayGUIChest(iinventory);
        }
        return true;
    }

    public IInventory getInventory(World par1World, int par2, int par3, int par4) {
        TileEntity object = par1World.getTileEntity(par2, par3, par4);
        if (object == null) {
            return null;
        }
        if (par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN)) {
            return null;
        }
        if (BlockLeechChest.isOcelotBlockingChest(par1World, par2, par3, par4)) {
            return null;
        }
        if (par1World.getBlock(par2 - 1, par3, par4) == this && (par1World.isSideSolid(par2 - 1, par3 + 1, par4, ForgeDirection.DOWN) || BlockLeechChest.isOcelotBlockingChest(par1World, par2 - 1, par3, par4))) {
            return null;
        }
        if (par1World.getBlock(par2 + 1, par3, par4) == this && (par1World.isSideSolid(par2 + 1, par3 + 1, par4, ForgeDirection.DOWN) || BlockLeechChest.isOcelotBlockingChest(par1World, par2 + 1, par3, par4))) {
            return null;
        }
        if (par1World.getBlock(par2, par3, par4 - 1) == this && (par1World.isSideSolid(par2, par3 + 1, par4 - 1, ForgeDirection.DOWN) || BlockLeechChest.isOcelotBlockingChest(par1World, par2, par3, par4 - 1))) {
            return null;
        }
        if (par1World.getBlock(par2, par3, par4 + 1) == this && (par1World.isSideSolid(par2, par3 + 1, par4 + 1, ForgeDirection.DOWN) || BlockLeechChest.isOcelotBlockingChest(par1World, par2, par3, par4 + 1))) {
            return null;
        }
        return (IInventory)object;
    }

    public boolean canProvidePower() {
        return this.chestType == 1;
    }

    public int isProvidingWeakPower(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (!this.canProvidePower()) {
            return 0;
        }
        TileEntity tile = par1IBlockAccess.getTileEntity(par2, par3, par4);
        if (tile != null && tile instanceof TileEntityLeechChest) {
            int i1 = ((TileEntityLeechChest)tile).numUsingPlayers;
            return MathHelper.clamp_int((int)i1, (int)0, (int)15);
        }
        return 0;
    }

    public int isProvidingStrongPower(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par5 == 1 ? this.isProvidingWeakPower(par1IBlockAccess, par2, par3, par4, par5) : 0;
    }

    public static boolean isOcelotBlockingChest(World par0World, int par1, int par2, int par3) {
        EntityOcelot entityocelot1;
        EntityOcelot entityocelot;
        Iterator iterator = par0World.getEntitiesWithinAABB(EntityOcelot.class, AxisAlignedBB.getBoundingBox((double)par1, (double)(par2 + 1), (double)par3, (double)(par1 + 1), (double)(par2 + 2), (double)(par3 + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityocelot = (entityocelot1 = (EntityOcelot)iterator.next())).isSitting());
        return true;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World par1World, int par2, int par3, int par4, int par5) {
        return Container.calcRedstoneFromInventory((IInventory)this.getInventory(par1World, par2, par3, par4));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("planks_oak");
    }

    public static class TileEntityLeechChest
    extends TileEntity
    implements IInventory {
        private ItemStack[] chestContents = new ItemStack[36];
        public boolean adjacentChestChecked;
        public TileEntity adjacentChestZNeg;
        public TileEntity adjacentChestXPos;
        public TileEntity adjacentChestXNeg;
        public TileEntity adjacentChestZPosition;
        public float lidAngle;
        public float prevLidAngle;
        public int numUsingPlayers;
        private int ticksSinceSync;
        private int cachedChestType;
        private String customName;
        public ArrayList<String> players = new ArrayList();

        public TileEntityLeechChest() {
            this.cachedChestType = -1;
        }

        public void sync() {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }

        public void storePlayer(EntityPlayer player) {
            if (!this.worldObj.isRemote && player != null && !this.players.contains(player.getCommandSenderName())) {
                this.players.add(player.getCommandSenderName());
                while (this.players.size() > 3) {
                    this.players.remove(0);
                }
                this.sync();
            }
        }

        public String popUserExcept(EntityPlayer usingPlayer) {
            String missingPlayers = "";
            for (int i = this.players.size() - 1; i >= 0; --i) {
                String foundPlayerName = this.players.get(i);
                if (!foundPlayerName.equals(usingPlayer.getCommandSenderName())) {
                    if (usingPlayer.worldObj.getPlayerEntityByName(foundPlayerName) != null) {
                        this.players.remove(i);
                        this.sync();
                        return foundPlayerName;
                    }
                    missingPlayers = missingPlayers + foundPlayerName + " ";
                    continue;
                }
                if (this.players.size() != 1) continue;
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)usingPlayer, "tile.witcheryLeechChest.onlyowntaglock", new Object[0]);
                return null;
            }
            if (!missingPlayers.isEmpty()) {
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)usingPlayer, "tile.witcheryLeechChest.playernotloggedin", missingPlayers);
            }
            return null;
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        @SideOnly(value=Side.CLIENT)
        public TileEntityLeechChest(int par1) {
            this.cachedChestType = par1;
        }

        public int getSizeInventory() {
            return 27;
        }

        public ItemStack getStackInSlot(int par1) {
            return this.chestContents[par1];
        }

        public ItemStack decrStackSize(int par1, int par2) {
            if (this.chestContents[par1] != null) {
                if (this.chestContents[par1].stackSize <= par2) {
                    ItemStack itemstack = this.chestContents[par1];
                    this.chestContents[par1] = null;
                    this.markDirty();
                    return itemstack;
                }
                ItemStack itemstack = this.chestContents[par1].splitStack(par2);
                if (this.chestContents[par1].stackSize == 0) {
                    this.chestContents[par1] = null;
                }
                this.markDirty();
                return itemstack;
            }
            return null;
        }

        public ItemStack getStackInSlotOnClosing(int par1) {
            if (this.chestContents[par1] != null) {
                ItemStack itemstack = this.chestContents[par1];
                this.chestContents[par1] = null;
                return itemstack;
            }
            return null;
        }

        public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
            this.chestContents[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
                par2ItemStack.stackSize = this.getInventoryStackLimit();
            }
            this.markDirty();
        }

        public String getInventoryName() {
            return this.hasCustomInventoryName() ? this.customName : "container.chest";
        }

        public boolean hasCustomInventoryName() {
            return this.customName != null && this.customName.length() > 0;
        }

        public void setChestGuiName(String par1Str) {
            this.customName = par1Str;
        }

        public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
            super.readFromNBT(par1NBTTagCompound);
            NBTTagList nbtItemsList = par1NBTTagCompound.getTagList("Items", 10);
            this.chestContents = new ItemStack[this.getSizeInventory()];
            if (par1NBTTagCompound.hasKey("CustomName")) {
                this.customName = par1NBTTagCompound.getString("CustomName");
            }
            for (int i = 0; i < nbtItemsList.tagCount(); ++i) {
                NBTTagCompound nbtItem = nbtItemsList.getCompoundTagAt(i);
                int j = nbtItem.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.chestContents.length) continue;
                this.chestContents[j] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtItem);
            }
            this.players.clear();
            NBTTagList nbtPlayersList = par1NBTTagCompound.getTagList("WITCPlayers", 10);
            for (int i = 0; i < nbtPlayersList.tagCount(); ++i) {
                NBTTagCompound nbtPlayer = nbtPlayersList.getCompoundTagAt(i);
                String s = nbtPlayer.getString("Player");
                if (s == null || s.isEmpty()) continue;
                this.players.add(s);
            }
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            NBTTagList nbtItemsList = new NBTTagList();
            for (int i = 0; i < this.chestContents.length; ++i) {
                if (this.chestContents[i] == null) continue;
                NBTTagCompound nbtItem = new NBTTagCompound();
                nbtItem.setByte("Slot", (byte)i);
                this.chestContents[i].writeToNBT(nbtItem);
                nbtItemsList.appendTag((NBTBase)nbtItem);
            }
            nbtTag.setTag("Items", (NBTBase)nbtItemsList);
            if (this.hasCustomInventoryName()) {
                nbtTag.setString("CustomName", this.customName);
            }
            NBTTagList nbtPlayers = new NBTTagList();
            for (int i = 0; i < this.players.size(); ++i) {
                NBTTagCompound nbtPlayer = new NBTTagCompound();
                nbtPlayer.setString("Player", this.players.get(i));
                nbtPlayers.appendTag((NBTBase)nbtPlayer);
            }
            nbtTag.setTag("WITCPlayers", (NBTBase)nbtPlayers);
        }

        public int getInventoryStackLimit() {
            return 64;
        }

        public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
            return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
        }

        public void updateContainingBlockInfo() {
            super.updateContainingBlockInfo();
            this.adjacentChestChecked = false;
        }

        public void updateEntity() {
            float f;
            super.updateEntity();
            ++this.ticksSinceSync;
            if (!this.worldObj.isRemote && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.xCoord + this.yCoord + this.zCoord) % 200 == 0) {
                this.numUsingPlayers = 0;
                f = 5.0f;
                List list = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)((float)this.xCoord - f), (double)((float)this.yCoord - f), (double)((float)this.zCoord - f), (double)((float)(this.xCoord + 1) + f), (double)((float)(this.yCoord + 1) + f), (double)((float)(this.zCoord + 1) + f)));
                for (EntityPlayer entityplayer : list) {
                    IInventory iinventory;
                    if (!(entityplayer.openContainer instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.openContainer).getLowerChestInventory()) != this) continue;
                    ++this.numUsingPlayers;
                }
            }
            this.prevLidAngle = this.lidAngle;
            f = 0.1f;
            if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
                double d1 = (double)this.xCoord + 0.5;
                double d0 = (double)this.zCoord + 0.5;
                this.worldObj.playSoundEffect(d1, (double)this.yCoord + 0.5, d0, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
                float f2;
                float f1 = this.lidAngle;
                this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                    double d0 = (double)this.xCoord + 0.5;
                    double d2 = (double)this.zCoord + 0.5;
                    this.worldObj.playSoundEffect(d0, (double)this.yCoord + 0.5, d2, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }

        public boolean receiveClientEvent(int par1, int par2) {
            if (par1 == 1) {
                this.numUsingPlayers = par2;
                return true;
            }
            return super.receiveClientEvent(par1, par2);
        }

        public void openInventory() {
            if (this.numUsingPlayers < 0) {
                this.numUsingPlayers = 0;
            }
            ++this.numUsingPlayers;
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }

        public void closeInventory() {
            if (this.getBlockType() != null && this.getBlockType() instanceof BlockLeechChest) {
                --this.numUsingPlayers;
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
            }
        }

        public boolean isItemValidForSlot(int par1, ItemStack par2ItemStack) {
            return true;
        }

        public void invalidate() {
            super.invalidate();
            this.updateContainingBlockInfo();
        }

        public int getChestType() {
            if (this.cachedChestType == -1) {
                if (this.worldObj == null || !(this.getBlockType() instanceof BlockLeechChest)) {
                    return 0;
                }
                this.cachedChestType = ((BlockLeechChest)this.getBlockType()).chestType;
            }
            return this.cachedChestType;
        }
    }
}

