/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.crafting.KettleRecipes;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockKettle
extends BlockBaseContainer {
    static final int POWER_SOURCE_RADIUS = 16;

    public BlockKettle() {
        super(Material.anvil, TileEntityKettle.class);
        this.setHardness(2.0f);
        this.setStepSound(soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBox((double)((float)x + f), (double)y, (double)((float)z + f), (double)((float)(x + 1) - f), (double)((float)(y + 1) - f), (double)((float)(z + 1) - f));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, Block par5) {
        this.func_111046_k(par1World, par2, par3, par4);
    }

    private boolean func_111046_k(World par1World, int par2, int par3, int par4) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            par1World.setBlockToAir(par2, par3, par4);
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return true;
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    private static IPowerSource findNewPowerSource(World world, int posX, int posY, int posZ) {
        ArrayList<PowerSources.RelativePowerSource> sources = PowerSources.instance() != null ? PowerSources.instance().get(world, new Coord(posX, posY, posZ), 16) : null;
        return sources != null && sources.size() > 0 ? ((PowerSources.RelativePowerSource)sources.get(0)).source() : null;
    }

    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem(stack)) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntityKettle tileEntity = (TileEntityKettle)world.getTileEntity(x, y, z);
        if (tileEntity != null) {
            double d0 = (float)x + 0.45f;
            double d1 = (float)y + 0.4f;
            double d2 = (float)z + 0.5f;
            if (tileEntity.isRuined()) {
                world.spawnParticle(ParticleEffect.LARGE_SMOKE.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
            } else if (tileEntity.isReady()) {
                world.spawnParticle(ParticleEffect.SLIME.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
                if (tileEntity.isPowered) {
                    world.spawnParticle(ParticleEffect.SPELL.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
                } else {
                    world.spawnParticle(ParticleEffect.MOB_SPELL.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            } else if (tileEntity.isBrewing()) {
                world.spawnParticle(ParticleEffect.MOB_SPELL.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean tryFillWith(World world, int x, int y, int z, FluidStack fluidStack) {
        if (world.isRemote) {
            return true;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile == null || !(tile instanceof TileEntityKettle)) {
            return false;
        }
        TileEntityKettle tank = (TileEntityKettle)tile;
        if (tank != null && tank.canFill(ForgeDirection.UNKNOWN, fluidStack.getFluid())) {
            int qty = tank.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            fluidStack.amount -= qty;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            }
            if (qty > 0) {
                world.markBlockForUpdate(x, y, z);
                SoundEffect.WATER_SWIM.playAt(world, x, y, z);
            }
            return qty > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onBlockActivated(World world, int posX, int posY, int posZ, EntityPlayer player, int par6, float par7, float par8, float par9) {
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null) {
            ItemStack filled;
            TileEntity tile = world.getTileEntity(posX, posY, posZ);
            if (tile == null || !(tile instanceof TileEntityKettle)) {
                return false;
            }
            TileEntityKettle tank = (TileEntityKettle)tile;
            if (current.getItem() == Items.glass_bottle && tank.isReady()) {
                if (KettleRecipes.instance().isBrewableBy(tank.furnaceItemStacks[6], player)) {
                    ItemStack itemstack1 = null;
                    try {
                        tank.setConsumeBottle(false);
                        itemstack1 = tank.decrStackSize(6, 1);
                    }
                    finally {
                        tank.setConsumeBottle(true);
                    }
                    double bonusChance = 0.0;
                    double bonusChance2 = 0.0;
                    if (player.inventory.armorItemInSlot(3) != null && player.inventory.armorItemInSlot(3).getItem() == Witchery.Items.WITCH_HAT) {
                        bonusChance += 0.35;
                    } else if (player.inventory.armorItemInSlot(3) != null && player.inventory.armorItemInSlot(3).getItem() == Witchery.Items.BABAS_HAT) {
                        bonusChance += 0.25;
                        bonusChance2 += 0.25;
                    }
                    if (!Witchery.Items.GENERIC.itemBrewOfRaising.isMatch(itemstack1) && Witchery.Items.WITCH_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    } else if (Witchery.Items.GENERIC.itemBrewOfRaising.isMatch(itemstack1) && Witchery.Items.NECROMANCERS_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    }
                    if (Familiar.hasActiveBrewMasteryFamiliar(player)) {
                        bonusChance += 0.05;
                        if (player.inventory.armorItemInSlot(3) != null && player.inventory.armorItemInSlot(3).getItem() == Witchery.Items.BABAS_HAT) {
                            bonusChance2 += 0.05;
                        }
                    }
                    if (bonusChance > 0.0 && world.rand.nextDouble() <= bonusChance) {
                        itemstack1.stackSize += KettleRecipes.instance().getHatBonus(itemstack1);
                    }
                    if (bonusChance2 > 0.0 && world.rand.nextDouble() <= bonusChance2) {
                        itemstack1.stackSize += KettleRecipes.instance().getHatBonus(itemstack1);
                    }
                    if (!world.isRemote) {
                        if (current.stackSize == 1) {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, itemstack1);
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                        } else {
                            if (!player.inventory.addItemStackToInventory(itemstack1)) {
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)posX + 0.5, (double)posY + 1.5, (double)posZ + 0.5, itemstack1));
                            } else if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                            --current.stackSize;
                            if (current.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                            }
                        }
                    }
                    SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                }
                return true;
            }
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (liquid != null) {
                if (tank.canFill(ForgeDirection.UNKNOWN, liquid.getFluid())) {
                    int qty = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (qty != 0 && !player.capabilities.isCreativeMode) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockKettle.consumeItem(current));
                    }
                    tank.reset(false);
                    SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                }
                return true;
            }
            if (current.getItem() == Witchery.Items.BREW_ENDLESS_WATER) {
                if (this.tryFillWith(world, posX, posY, posZ, new FluidStack(FluidRegistry.WATER, 1000))) {
                    current.damageItem(1, (EntityLivingBase)player);
                }
                return true;
            }
            FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (!player.capabilities.isCreativeMode) {
                    if (current.stackSize > 1) {
                        if (!player.inventory.addItemStackToInventory(filled)) {
                            return false;
                        }
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockKettle.consumeItem(current));
                    } else {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockKettle.consumeItem(current));
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, filled);
                    }
                }
                tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                tank.reset(false);
                SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                return true;
            }
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int posX, int posY, int posZ, Entity entity) {
        TileEntityKettle tileEntity;
        if (!world.isRemote && entity instanceof EntityItem && (tileEntity = (TileEntityKettle)world.getTileEntity(posX, posY, posZ)) != null) {
            EntityItem itemEntity = (EntityItem)entity;
            if (itemEntity.getEntityItem().getItem() == Items.glass_bottle) {
                ItemStack stack = tileEntity.getStackInSlot(7);
                if (stack == null) {
                    tileEntity.setInventorySlotContents(7, itemEntity.getEntityItem());
                    itemEntity.setDead();
                } else if (stack.stackSize + itemEntity.getEntityItem().stackSize <= tileEntity.getInventoryStackLimit()) {
                    stack.stackSize += itemEntity.getEntityItem().stackSize;
                    tileEntity.setInventorySlotContents(7, stack);
                    itemEntity.setDead();
                }
            } else if (tileEntity.isFilled()) {
                boolean spaceFound = false;
                for (int i = 0; i < tileEntity.getSizeInventory() - 2; ++i) {
                    if (tileEntity.getStackInSlot(i) != null) continue;
                    tileEntity.setInventorySlotContents(i, itemEntity.getEntityItem());
                    spaceFound = true;
                    break;
                }
                if (!spaceFound && !tileEntity.isRuined()) {
                    tileEntity.setRuined();
                }
                itemEntity.setDead();
                ParticleEffect.SPLASH.send(SoundEffect.WATER_SPLASH, world, (double)posX + 0.5, (double)posY + 0.2, (double)posZ + 0.5, 0.5, 0.5, 5);
            }
        }
    }

    public static class TileEntityKettle
    extends TileEntityBase
    implements ISidedInventory,
    IFluidHandler {
        private static final int RESULT_SLOT = 6;
        private static final int BOTTLE_SLOT = 7;
        private ItemStack[] furnaceItemStacks = new ItemStack[8];
        private boolean isRuined = false;
        private boolean isPowered = false;
        private int color;
        private static final int[] side_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        private int lastExtractionQuantity = 0;
        private boolean consumeBottles = true;
        private FluidTank tank = new FluidTank(1000);

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && !this.isRuined && this.ticks % 20L == 0L && this.isFilled() && (this.someFilled() || this.furnaceItemStacks[6] != null)) {
                boolean sendPacket = false;
                if (this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord).getMaterial() != Material.fire) {
                    this.isRuined = true;
                    this.color = 0;
                    this.furnaceItemStacks[6] = null;
                } else if (this.furnaceItemStacks[6] == null) {
                    if (this.allFilled()) {
                        KettleRecipes.KettleRecipe recipe = KettleRecipes.instance().getResult(this.furnaceItemStacks, this.furnaceItemStacks.length - 2, false, this.worldObj);
                        if (recipe == null) {
                            this.color = 0;
                            this.isRuined = true;
                            this.furnaceItemStacks[6] = null;
                        } else {
                            this.color = recipe.getColor();
                            boolean wasPowered = this.isPowered;
                            float powerNeeded = recipe.getRequiredPower();
                            if (powerNeeded == 0.0f) {
                                this.isPowered = true;
                            } else {
                                IPowerSource powerSource = BlockKettle.findNewPowerSource(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                                boolean bl = this.isPowered = powerSource != null && powerSource.consumePower(powerNeeded);
                            }
                            if (this.isPowered) {
                                this.furnaceItemStacks[6] = recipe.getOutput(null, true);
                                for (int i = 0; i < this.furnaceItemStacks.length - 2; ++i) {
                                    this.furnaceItemStacks[i] = null;
                                }
                            }
                            sendPacket = this.isPowered || wasPowered != this.isPowered;
                        }
                    } else {
                        KettleRecipes.KettleRecipe recipe = KettleRecipes.instance().getResult(this.furnaceItemStacks, this.furnaceItemStacks.length - 2, true, this.worldObj);
                        if (recipe == null || recipe.getColor() == 0) {
                            this.color = 0;
                            this.isRuined = true;
                            this.furnaceItemStacks[6] = null;
                        } else if (recipe.getColor() != this.color) {
                            this.color = recipe.getColor();
                            sendPacket = true;
                        }
                        if (!this.isRuined) {
                            IPowerSource powerSource;
                            boolean wasPowered = this.isPowered;
                            float powerNeeded = recipe.getRequiredPower();
                            this.isPowered = powerNeeded == 0.0f ? true : (powerSource = BlockKettle.findNewPowerSource(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) != null && powerSource.getCurrentPower() >= powerNeeded;
                            boolean bl = sendPacket = wasPowered != this.isPowered;
                        }
                    }
                }
                if (this.isRuined || sendPacket) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }

        public void reset(boolean flushWater) {
            if (!this.worldObj.isRemote) {
                Log.instance().debug(String.format("Reset kettle %s", flushWater ? "Flush" : "No Flush"));
                if (flushWater) {
                    FluidStack drained = this.tank.drain(this.tank.getFluidAmount(), true);
                    Log.instance().debug(String.format("Drained %d remaining %d of  %d", drained.amount, this.tank.getFluidAmount(), this.tank.getCapacity()));
                }
                this.isRuined = false;
                this.isPowered = false;
                for (int i = 0; i < this.furnaceItemStacks.length - 1; ++i) {
                    this.furnaceItemStacks[i] = null;
                }
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public boolean allFilled() {
            for (int i = 0; i < this.furnaceItemStacks.length - 2; ++i) {
                if (this.furnaceItemStacks[i] != null) continue;
                return false;
            }
            return true;
        }

        public boolean someFilled() {
            for (int i = 0; i < this.furnaceItemStacks.length - 2; ++i) {
                if (this.furnaceItemStacks[i] == null) continue;
                return true;
            }
            return false;
        }

        public int getSizeInventory() {
            return this.furnaceItemStacks.length;
        }

        public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
            Log.instance().debug(String.format("isItemValidForSlot(%d, %s)", slot, itemstack.toString()));
            ItemStack stackInSlot = this.getStackInSlot(slot);
            if (slot == 6) {
                return true;
            }
            if (slot == 7) {
                return itemstack.getItem() == Items.glass_bottle && (stackInSlot != null ? stackInSlot.stackSize : 0) + itemstack.stackSize <= this.getInventoryStackLimit();
            }
            return this.getStackInSlot(6) == null && (stackInSlot != null ? stackInSlot.stackSize : 0) + itemstack.stackSize <= this.getInventoryStackLimit();
        }

        public int[] getAccessibleSlotsFromSide(int var1) {
            return side_slots;
        }

        public boolean canInsertItem(int slot, ItemStack stack, int side) {
            ItemStack stackInSlot = this.getStackInSlot(slot);
            if (slot == 6) {
                return false;
            }
            if (slot == 7) {
                return stack.getItem() == Items.glass_bottle && (stackInSlot != null ? stackInSlot.stackSize : 0) + stack.stackSize <= this.getInventoryStackLimit();
            }
            return stack.getItem() != Items.glass_bottle && this.getStackInSlot(6) == null && this.isFilled();
        }

        public boolean canExtractItem(int slot, ItemStack stack, int side) {
            boolean canExtract;
            Log.instance().debug(String.format("canExtract(%d, %s, %d)", slot, stack.toString(), side));
            ItemStack bottles = this.getStackInSlot(7);
            boolean bl = canExtract = slot == 6 && this.isFilled() && this.isReady() && bottles != null && bottles.stackSize >= stack.stackSize;
            if (canExtract) {
                if (!KettleRecipes.instance().isBrewableBy(stack, null)) {
                    return false;
                }
                this.lastExtractionQuantity = stack.stackSize;
            }
            return canExtract;
        }

        public int getLiquidColor() {
            return this.color;
        }

        public ItemStack getStackInSlot(int par1) {
            return this.furnaceItemStacks[par1];
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            Log.instance().debug("setInventorySlotContents");
            if (slot == 6 && this.consumeBottles) {
                ItemStack resultStack = this.getStackInSlot(6);
                ItemStack bottleStack = this.getStackInSlot(7);
                if (stack == null && resultStack != null && bottleStack != null) {
                    bottleStack.stackSize -= resultStack.stackSize;
                    if (bottleStack.stackSize <= 0) {
                        this.furnaceItemStacks[7] = null;
                    }
                } else if (stack != null && resultStack != null && bottleStack != null) {
                    int reduction = resultStack.stackSize - stack.stackSize;
                    if (reduction == 0) {
                        reduction = this.lastExtractionQuantity;
                    }
                    this.lastExtractionQuantity = 0;
                    Log.instance().debug(String.format("bottles; %d %s %s", reduction, stack.toString(), resultStack.toString()));
                    bottleStack.stackSize -= reduction;
                    if (bottleStack.stackSize <= 0) {
                        this.furnaceItemStacks[7] = null;
                    }
                }
            }
            this.furnaceItemStacks[slot] = stack;
            if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
                stack.stackSize = this.getInventoryStackLimit();
            } else if (stack == null && slot == 6) {
                this.reset(true);
                return;
            }
            if (!this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public void setConsumeBottle(boolean consume) {
            this.consumeBottles = consume;
        }

        public ItemStack decrStackSize(int slot, int quantity) {
            Log.instance().debug("decrStackSize");
            if (this.furnaceItemStacks[slot] != null) {
                ItemStack bottles = this.getStackInSlot(7);
                if (this.consumeBottles && bottles != null) {
                    bottles.stackSize -= quantity;
                }
                if (bottles != null && bottles.stackSize <= 0) {
                    this.furnaceItemStacks[7] = null;
                }
                if (this.furnaceItemStacks[slot].stackSize <= quantity) {
                    ItemStack itemstack = this.furnaceItemStacks[slot];
                    this.furnaceItemStacks[slot] = null;
                    if (slot == 6) {
                        this.reset(true);
                    } else if (!this.worldObj.isRemote) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                    return itemstack;
                }
                ItemStack itemstack = this.furnaceItemStacks[slot].splitStack(quantity);
                if (this.furnaceItemStacks[slot].stackSize == 0) {
                    this.furnaceItemStacks[slot] = null;
                    if (slot == 6) {
                        this.reset(true);
                    } else if (!this.worldObj.isRemote) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                } else if (!this.worldObj.isRemote) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
                return itemstack;
            }
            return null;
        }

        public ItemStack getStackInSlotOnClosing(int par1) {
            Log.instance().debug("getStackInSlotOnClosing");
            if (this.furnaceItemStacks[par1] != null) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                if (par1 == 6) {
                    this.reset(true);
                } else if (!this.worldObj.isRemote) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
                return itemstack;
            }
            return null;
        }

        public String getInventoryName() {
            return this.getBlockType().getLocalizedName();
        }

        public boolean hasCustomInventoryName() {
            return true;
        }

        public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
            super.readFromNBT(par1NBTTagCompound);
            if (this.tank.getFluidAmount() > 0) {
                this.tank.drain(this.tank.getFluidAmount(), true);
            }
            this.tank.readFromNBT(par1NBTTagCompound);
            NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
            this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                byte b0 = nbttagcompound1.getByte("Slot");
                if (b0 < 0 || b0 >= this.furnaceItemStacks.length) continue;
                this.furnaceItemStacks[b0] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
            }
            this.isRuined = par1NBTTagCompound.getBoolean("Ruined");
            this.isPowered = par1NBTTagCompound.getBoolean("Powered");
            this.color = par1NBTTagCompound.getInteger("LiquidColor");
        }

        public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
            super.writeToNBT(par1NBTTagCompound);
            par1NBTTagCompound.setBoolean("Ruined", this.isRuined);
            par1NBTTagCompound.setBoolean("Powered", this.isPowered);
            par1NBTTagCompound.setInteger("LiquidColor", this.color);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
                if (this.furnaceItemStacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.furnaceItemStacks[i].writeToNBT(nbttagcompound1);
                nbttaglist.appendTag((NBTBase)nbttagcompound1);
            }
            par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
            this.tank.writeToNBT(par1NBTTagCompound);
        }

        public int getInventoryStackLimit() {
            return 64;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
            return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public boolean isFilled() {
            return this.tank.getFluidAmount() == this.tank.getCapacity();
        }

        public boolean isBrewing() {
            return this.isFilled() && this.someFilled() && !this.isRuined();
        }

        public boolean isReady() {
            return !this.isRuined() && this.furnaceItemStacks[6] != null;
        }

        public boolean isRuined() {
            return this.isRuined;
        }

        public void setRuined() {
            this.isRuined = true;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            int result = this.tank.fill(resource, doFill);
            return result;
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
                return null;
            }
            return this.tank.drain(resource.amount, doDrain);
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            return this.tank.drain(maxDrain, doDrain);
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            if (fluid == null) {
                return false;
            }
            return fluid.getName().equals(FluidRegistry.WATER.getName());
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            if (fluid == null) {
                return false;
            }
            return fluid.getName().equals(FluidRegistry.WATER.getName());
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }

        public int bottleCount() {
            ItemStack stack = this.getStackInSlot(7);
            return stack != null ? stack.stackSize : 0;
        }
    }
}

