/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.entity.EntityCorpse;
import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityIllusion;
import com.emoniph.witchery.entity.EntitySpirit;
import com.emoniph.witchery.familiar.IFamiliar;
import com.emoniph.witchery.infusion.infusions.spirit.IFetishTile;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritEffect;
import com.emoniph.witchery.item.ItemTaglockKit;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockFetish
extends BlockBaseContainer {
    public BlockFetish() {
        super(Material.wood, TileEntityFetish.class, ClassItemBlock.class);
        this.setBlockBounds(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
        this.setResistance(100000.0f);
        this.setHardness(3.5f);
        this.setStepSound(soundTypeWood);
    }

    public void getSubBlocks(Item item, CreativeTabs tabs, List list) {
        super.getSubBlocks(item, tabs, list);
        if (Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_SCARECROW) == item) {
            list.add(InfusedSpiritEffect.setEffect(new ItemStack(item, 1, 0), InfusedSpiritEffect.POPPET_ENHANCEMENT));
        }
        if (Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_SCARECROW) == item || Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_WITCHS_LADDER) == item) {
            list.add(InfusedSpiritEffect.setEffect(new ItemStack(item, 1, 0), InfusedSpiritEffect.SCREAMER));
        }
        if (Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_SCARECROW) == item) {
            list.add(InfusedSpiritEffect.setEffect(new ItemStack(item, 1, 0), InfusedSpiritEffect.SENTINAL));
        }
        if (Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_SCARECROW) == item) {
            list.add(InfusedSpiritEffect.setEffect(new ItemStack(item, 1, 0), InfusedSpiritEffect.TWISTER));
        }
        if (Item.getItemFromBlock((Block)Witchery.Blocks.FETISH_SCARECROW) == item) {
            list.add(InfusedSpiritEffect.setEffect(new ItemStack(item, 1, 0), InfusedSpiritEffect.GHOST_WALKER));
        }
    }

    public void onBlockAdded(World world, int posX, int posY, int posZ) {
        super.onBlockAdded(world, posX, posY, posZ);
        BlockUtil.setBlockDefaultDirection(world, posX, posY, posZ);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int posX, int posY, int posZ) {
        TileEntityFetish tile = BlockUtil.getTileEntity((IBlockAccess)world, posX, posY, posZ, TileEntityFetish.class);
        if (this == Witchery.Blocks.FETISH_WITCHS_LADDER || tile != null && tile.isSpectral()) {
            return null;
        }
        return super.getCollisionBoundingBoxFromPool(world, posX, posY, posZ);
    }

    public float getBlockHardness(World world, int posX, int posY, int posZ) {
        TileEntityFetish tile = BlockUtil.getTileEntity((IBlockAccess)world, posX, posY, posZ, TileEntityFetish.class);
        if (tile == null || !tile.isSpectral()) {
            return super.getBlockHardness(world, posX, posY, posZ);
        }
        return -1.0f;
    }

    public void onBlockPlacedBy(World world, int posX, int posY, int posZ, EntityLivingBase player, ItemStack stack) {
        WorldServer overworld;
        TileEntityFetish tile;
        int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 2, 2);
        } else if (l == 1) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 5, 2);
        } else if (l == 2) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 3, 2);
        } else if (l == 3) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, 4, 2);
        }
        if (stack != null && (tile = BlockUtil.getTileEntity((IBlockAccess)world, posX, posY, posZ, TileEntityFetish.class)) != null) {
            NBTTagCompound nbtRoot = stack.getTagCompound();
            tile.setEffectType(InfusedSpiritEffect.getEffectID(stack));
            if (nbtRoot != null && nbtRoot.hasKey("TileData")) {
                NBTTagCompound nbtTileData = nbtRoot.getCompoundTag("TileData");
                tile.readSubDataFromNBT(nbtTileData);
                if (tile.getEffectType() == 0 && InfusedSpiritEffect.getEffectID(stack) != 0) {
                    tile.setEffectType(InfusedSpiritEffect.getEffectID(stack));
                }
            }
        }
        if (!world.isRemote && world.provider.dimensionId == Config.instance().dimensionDreamID && (overworld = MinecraftServer.getServer().worldServerForDimension(0)) != null && overworld.isAirBlock(posX, posY, posZ)) {
            BlockUtil.setBlock((World)overworld, posX, posY, posZ, (Block)this);
            this.onBlockPlacedBy((World)overworld, posX, posY, posZ, player, stack);
            TileEntityFetish tile2 = BlockUtil.getTileEntity((IBlockAccess)overworld, posX, posY, posZ, TileEntityFetish.class);
            if (tile2 != null) {
                tile2.setSpectral(true);
            }
        }
    }

    public void onBlockHarvested(World world, int posX, int posY, int posZ, int par5, EntityPlayer par6EntityPlayer) {
        WorldServer overworld;
        if (par6EntityPlayer.capabilities.isCreativeMode) {
            world.setBlockMetadataWithNotify(posX, posY, posZ, par5 |= 8, 4);
        }
        this.dropBlockAsItem(world, posX, posY, posZ, par5, 0);
        super.onBlockHarvested(world, posX, posY, posZ, par5, par6EntityPlayer);
        if (!world.isRemote && world.provider.dimensionId == Config.instance().dimensionDreamID && (overworld = MinecraftServer.getServer().worldServerForDimension(0)) != null && BlockUtil.getBlock((World)overworld, posX, posY, posZ) == this) {
            overworld.setBlockToAir(posX, posY, posZ);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityFetish tile;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((metadata & 8) == 0 && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityFetish.class)) != null) {
            ItemStack stack = new ItemStack(tile.getBlockType());
            NBTTagCompound nbtRoot = new NBTTagCompound();
            stack.setTagCompound(nbtRoot);
            nbtRoot.setByte("BlockColor", (byte)tile.getColor());
            InfusedSpiritEffect.setEffectID(stack, tile.getEffectType());
            NBTTagCompound nbtTileData = new NBTTagCompound();
            tile.writeSubDataToNBT(nbtTileData);
            nbtRoot.setTag("TileData", (NBTBase)nbtTileData);
            drops.add(stack);
        }
        return drops;
    }

    public int getRenderType() {
        return this == Witchery.Blocks.FETISH_WITCHS_LADDER ? 1 : super.getRenderType();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this == Witchery.Blocks.FETISH_WITCHS_LADDER;
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        TileEntityFetish tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityFetish.class);
        if (tile != null && player != null && (stack = player.getHeldItem()) != null) {
            if (!tile.isSpectral()) {
                if (stack.getItem() == Items.dye) {
                    int color = BlockColored.func_150032_b((int)stack.getItemDamage());
                    tile.setColor(color);
                    if (!player.capabilities.isCreativeMode && --stack.stackSize == 0) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                    }
                    return true;
                }
                if (stack.getItem() == Items.water_bucket) {
                    tile.clearBoundEntities(stack, player);
                    SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                    return true;
                }
                if (stack.getItem() == Witchery.Items.BOLINE) {
                    tile.cycleBoundMode(player);
                    return true;
                }
            }
            if (stack.getItem() == Witchery.Items.TAGLOCK_KIT) {
                tile.setBoundEntity(stack, player, tile.isSpectral());
                return true;
            }
        }
        return false;
    }

    public int isProvidingWeakPower(IBlockAccess par1IBlockAccess, int posX, int posY, int posZ, int side) {
        TileEntityFetish tile = BlockUtil.getTileEntity(par1IBlockAccess, posX, posY, posZ, TileEntityFetish.class);
        if (tile != null) {
            return tile.getPowerLevel();
        }
        return super.isProvidingWeakPower(par1IBlockAccess, posX, posY, posZ, side);
    }

    public int isProvidingStrongPower(IBlockAccess par1IBlockAccess, int posX, int posY, int posZ, int side) {
        return side == 1 ? this.isProvidingWeakPower(par1IBlockAccess, posX, posY, posZ, side) : 0;
    }

    public boolean canProvidePower() {
        return true;
    }

    private static class CreatureID {
        UUID id;
        String name;

        public CreatureID(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof UUID) {
                return this.id.equals((UUID)obj);
            }
            if (obj.getClass() == this.getClass()) {
                return this.id.equals(((CreatureID)obj).id);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TileEntityFetish
    extends TileEntityBase
    implements IFetishTile {
        private CreatureID testID = new CreatureID(new UUID(0L, 0L), "");
        boolean lastRaiseAlarm;
        long lastActivationTime;
        final int TRIGGER_WHEN_PLAYER_NOT_IN_WHITELIST = 0;
        final int TRIGGER_WHEN_PLAYER_IN_BLACKLIST = 1;
        final int TRIGGER_WHEN_CREATURE_NOT_IN_WHITELIST = 2;
        final int TRIGGER_WHEN_NOT_ALL_CREATURES_FOUND = 3;
        final int TRIGGER_WHEN_SOME_CREATURES_NOT_FOUND = 4;
        final int TRIGGER_OFF = 5;
        int alarmMode = 5;
        private Block expectedBlock;
        private boolean spectral;
        private int color = 0;
        private int effectType = 0;
        private static ArrayList<String> groupables = null;
        private ArrayList<String> knownPlayers = new ArrayList();
        private ArrayList<String> knownCreatureTypes = new ArrayList();
        private ArrayList<CreatureID> knownCreatures = new ArrayList();

        public TileEntityFetish setExpectedBlock(Block block) {
            this.expectedBlock = block;
            return this;
        }

        public Block getExpectedBlock() {
            return this.expectedBlock;
        }

        @Override
        public void updateEntity() {
            InfusedSpiritEffect effect;
            super.updateEntity();
            if (!this.worldObj.isRemote && TimeUtil.secondsElapsed(1, this.ticks) && (effect = InfusedSpiritEffect.getEffect(this)) != null && effect.getRadius() > 0.0) {
                boolean someFound = false;
                int found = 0;
                int someLeft = 0;
                HashSet<String> foundTypes = new HashSet<String>();
                List entities = null;
                ArrayList<EntityLivingBase> foundEntities = new ArrayList<EntityLivingBase>();
                if (this.alarmMode != 5) {
                    double RADIUS = effect.getRadius();
                    double RADIUS_SQ = RADIUS * RADIUS;
                    AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(0.5 + (double)this.xCoord - RADIUS), (double)(0.5 + (double)this.yCoord - RADIUS), (double)(0.5 + (double)this.zCoord - RADIUS), (double)(0.5 + (double)this.xCoord + RADIUS), (double)(0.5 + (double)this.yCoord + RADIUS), (double)(0.5 + (double)this.zCoord + RADIUS));
                    entities = this.alarmMode == 0 || this.alarmMode == 1 ? this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bb) : this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, bb);
                    someLeft = entities.size();
                    for (Object obj : entities) {
                        if (obj instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)obj;
                            if (this.knownPlayers != null && this.knownPlayers.contains(player.getCommandSenderName())) {
                                someFound = true;
                                ++found;
                                --someLeft;
                                if (this.alarmMode != 1) continue;
                                foundEntities.add((EntityLivingBase)player);
                                continue;
                            }
                            if (this.alarmMode != 2 && this.alarmMode != 0) continue;
                            foundEntities.add((EntityLivingBase)player);
                            continue;
                        }
                        if (!(obj instanceof EntityLiving) || this.isIgnorableEntity((EntityLiving)obj)) continue;
                        EntityLiving creature = (EntityLiving)obj;
                        if (this.knownCreatureTypes != null && this.knownCreatureTypes.contains(creature.getCommandSenderName())) {
                            someFound = true;
                            foundTypes.add(creature.getCommandSenderName());
                            --someLeft;
                            continue;
                        }
                        this.testID.id = creature.getUniqueID();
                        if (this.knownCreatures != null && this.knownCreatures.contains(this.testID)) {
                            someFound = true;
                            ++found;
                            --someLeft;
                            continue;
                        }
                        if (this.alarmMode != 2) continue;
                        foundEntities.add((EntityLivingBase)creature);
                    }
                }
                boolean raiseAlarm = false;
                switch (this.alarmMode) {
                    case 0: 
                    case 2: {
                        raiseAlarm = someLeft > 0;
                        break;
                    }
                    case 1: {
                        raiseAlarm = someFound;
                        break;
                    }
                    case 3: {
                        raiseAlarm = found != this.knownCreatures.size() + this.knownPlayers.size() || this.knownCreatureTypes.size() != foundTypes.size();
                        break;
                    }
                    case 4: {
                        raiseAlarm = !someFound;
                    }
                }
                int cooldown = effect.getCooldownTicks();
                long currentTime = this.worldObj.getTotalWorldTime();
                if ((cooldown == -1 || currentTime > this.lastActivationTime + (long)cooldown) && effect.doUpdateEffect(this, raiseAlarm, foundEntities)) {
                    this.lastActivationTime = currentTime;
                }
                if (this.lastRaiseAlarm != raiseAlarm) {
                    this.lastRaiseAlarm = raiseAlarm;
                    if (effect.isRedstoneSignaller()) {
                        BlockUtil.notifyNeighborsOfBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
                    }
                }
            }
        }

        private boolean isFamiliar(Entity entity) {
            if (entity instanceof IFamiliar) {
                IFamiliar familiar = (IFamiliar)entity;
                return familiar.isFamiliar();
            }
            return false;
        }

        private boolean isIgnorableEntity(EntityLiving entity) {
            return entity instanceof EntityCorpse || entity instanceof EntityIllusion || entity instanceof EntitySpirit || this.isFamiliar((Entity)entity);
        }

        public boolean isSpectral() {
            return this.spectral;
        }

        public void setSpectral(boolean spectral) {
            this.spectral = spectral;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public int getPowerLevel() {
            InfusedSpiritEffect effect = InfusedSpiritEffect.getEffect(this);
            if (effect != null && effect.isRedstoneSignaller()) {
                return this.lastRaiseAlarm ? 15 : 0;
            }
            return 0;
        }

        public void setColor(int dyeColor) {
            this.color = dyeColor;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.syncSpectralEntities();
            }
        }

        public int getColor() {
            return this.color;
        }

        @Override
        public int getEffectType() {
            return this.effectType;
        }

        public void setEffectType(int effectID) {
            this.effectType = effectID;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        @Override
        public int getX() {
            return this.xCoord;
        }

        @Override
        public int getY() {
            return this.yCoord;
        }

        @Override
        public int getZ() {
            return this.zCoord;
        }

        public void syncSpectralEntities() {
            TileEntityFetish tile;
            WorldServer overworld;
            if (this.worldObj != null && !this.worldObj.isRemote && this.worldObj.provider.dimensionId == Config.instance().dimensionDreamID && (overworld = MinecraftServer.getServer().worldServerForDimension(0)) != null && BlockUtil.getBlock((World)overworld, this.xCoord, this.yCoord, this.zCoord) == this.getBlockType() && (tile = BlockUtil.getTileEntity((IBlockAccess)overworld, this.xCoord, this.yCoord, this.zCoord, TileEntityFetish.class)) != null) {
                NBTTagCompound nbtOurData = new NBTTagCompound();
                this.writeSubDataToNBT(nbtOurData);
                tile.readSubDataFromNBT(nbtOurData);
            }
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
            this.lastActivationTime = nbtRoot.getLong("LastActivation");
            if (nbtRoot.hasKey("Spectral")) {
                this.spectral = nbtRoot.getBoolean("Spectral");
            }
            this.readSubDataFromNBT(nbtRoot);
        }

        public void readSubDataFromNBT(NBTTagCompound nbtRoot) {
            String playerName;
            int i;
            if (nbtRoot.hasKey("BlockColor")) {
                this.color = nbtRoot.getByte("BlockColor");
            }
            if (nbtRoot.hasKey("EffectTypeID")) {
                this.effectType = nbtRoot.getInteger("EffectTypeID");
            }
            this.alarmMode = nbtRoot.hasKey("AlarmMode") ? nbtRoot.getInteger("AlarmMode") : 5;
            if (nbtRoot.hasKey("KnownPlayers")) {
                NBTTagList nbtPlayers = nbtRoot.getTagList("KnownPlayers", 10);
                this.knownPlayers = new ArrayList();
                for (i = 0; i < nbtPlayers.tagCount(); ++i) {
                    NBTTagCompound nbtKnownPlayer = nbtPlayers.getCompoundTagAt(i);
                    playerName = nbtKnownPlayer.getString("PlayerName");
                    if (playerName == null || playerName.isEmpty()) continue;
                    this.knownPlayers.add(playerName);
                }
            }
            if (nbtRoot.hasKey("KnownCreatureTypes")) {
                NBTTagList nbtCreatureTypes = nbtRoot.getTagList("KnownCreatureTypes", 10);
                this.knownCreatureTypes = new ArrayList();
                for (i = 0; i < nbtCreatureTypes.tagCount(); ++i) {
                    NBTTagCompound nbtKnownCreatureType = nbtCreatureTypes.getCompoundTagAt(i);
                    String typeName = nbtKnownCreatureType.getString("CreatureTypeName");
                    if (typeName == null || typeName.isEmpty()) continue;
                    this.knownCreatureTypes.add(typeName);
                }
            }
            if (nbtRoot.hasKey("KnownCreatures")) {
                NBTTagList nbtCreatures = nbtRoot.getTagList("KnownCreatures", 10);
                this.knownCreatures = new ArrayList();
                for (i = 0; i < nbtCreatures.tagCount(); ++i) {
                    NBTTagCompound nbtKnownCreature = nbtCreatures.getCompoundTagAt(i);
                    playerName = nbtKnownCreature.getString("PlayerName");
                    long uuidMost = nbtKnownCreature.getLong("CreatureMost");
                    long uuidLeast = nbtKnownCreature.getLong("CreatureLeast");
                    String cname = nbtKnownCreature.getString("CreatureName");
                    if (uuidMost == 0L && uuidLeast == 0L) continue;
                    UUID creatureID = new UUID(uuidMost, uuidLeast);
                    this.knownCreatures.add(new CreatureID(creatureID, cname));
                }
            }
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setLong("LastActivation", this.lastActivationTime);
            nbtRoot.setBoolean("Spectral", this.spectral);
            this.writeSubDataToNBT(nbtRoot);
        }

        public void writeSubDataToNBT(NBTTagCompound nbtRoot) {
            nbtRoot.setByte("BlockColor", (byte)this.color);
            nbtRoot.setInteger("EffectTypeID", this.effectType);
            nbtRoot.setInteger("AlarmMode", this.alarmMode);
            if (this.knownPlayers.size() > 0) {
                NBTTagList nbtPlayers = new NBTTagList();
                for (String playerName : this.knownPlayers) {
                    NBTTagCompound nbtKnownPlayer = new NBTTagCompound();
                    nbtKnownPlayer.setString("PlayerName", playerName);
                    nbtPlayers.appendTag((NBTBase)nbtKnownPlayer);
                }
                nbtRoot.setTag("KnownPlayers", (NBTBase)nbtPlayers);
            }
            if (this.knownCreatureTypes.size() > 0) {
                NBTTagList nbtCreatureTypes = new NBTTagList();
                for (String typeName : this.knownCreatureTypes) {
                    NBTTagCompound nbtKnownCreatureType = new NBTTagCompound();
                    nbtKnownCreatureType.setString("CreatureTypeName", typeName);
                    nbtCreatureTypes.appendTag((NBTBase)nbtKnownCreatureType);
                }
                nbtRoot.setTag("KnownCreatureTypes", (NBTBase)nbtCreatureTypes);
            }
            if (this.knownCreatures.size() > 0) {
                NBTTagList nbtCreatures = new NBTTagList();
                for (CreatureID creatureID : this.knownCreatures) {
                    NBTTagCompound nbtKnownCreature = new NBTTagCompound();
                    nbtKnownCreature.setLong("CreatureMost", creatureID.id.getMostSignificantBits());
                    nbtKnownCreature.setLong("CreatureLeast", creatureID.id.getLeastSignificantBits());
                    nbtKnownCreature.setString("CreatureName", creatureID.name);
                    nbtCreatures.appendTag((NBTBase)nbtKnownCreature);
                }
                nbtRoot.setTag("KnownCreatures", (NBTBase)nbtCreatures);
            }
        }

        private boolean isGroupableCreature(UUID otherCreature, String creatureName) {
            if (groupables == null) {
                groupables = new ArrayList();
                this.addGroupableType(EntityVillager.class);
                this.addGroupableType(EntityGoblin.class);
                this.addGroupableType(EntitySheep.class);
                this.addGroupableType(EntityCow.class);
                this.addGroupableType(EntityMooshroom.class);
                this.addGroupableType(EntityChicken.class);
                this.addGroupableType(EntityPig.class);
                this.addGroupableType(EntityHorse.class);
                this.addGroupableType(EntityBat.class);
                this.addGroupableType(EntitySquid.class);
                this.addGroupableType(EntityCovenWitch.class);
            }
            return groupables.contains(creatureName);
        }

        public void setBoundEntity(ItemStack stack, EntityPlayer player, boolean readonly) {
            if (!this.worldObj.isRemote && stack != null) {
                ItemTaglockKit.BoundType boundEntityType = Witchery.Items.TAGLOCK_KIT.getBoundEntityType(stack, 1);
                switch (boundEntityType) {
                    case PLAYER: {
                        if (!readonly) {
                            String otherUsername = Witchery.Items.TAGLOCK_KIT.getBoundUsername(stack, 1);
                            if (!this.knownPlayers.contains(otherUsername)) {
                                this.knownPlayers.add(otherUsername);
                            } else {
                                this.knownPlayers.remove(otherUsername);
                            }
                            if (!player.capabilities.isCreativeMode && --stack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                            }
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                            this.syncSpectralEntities();
                        }
                        this.showCurrentKnownEntities(player);
                        break;
                    }
                    case CREATURE: {
                        if (!readonly) {
                            String creatureName;
                            UUID otherCreature = Witchery.Items.TAGLOCK_KIT.getBoundCreatureID(stack, 1);
                            if (this.isGroupableCreature(otherCreature, creatureName = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1))) {
                                if (!this.knownCreatureTypes.contains(creatureName)) {
                                    this.knownCreatureTypes.add(creatureName);
                                } else {
                                    this.knownCreatureTypes.remove(creatureName);
                                }
                            } else {
                                CreatureID creatureID = new CreatureID(otherCreature, creatureName);
                                if (!this.knownCreatures.contains(creatureID)) {
                                    this.knownCreatures.add(creatureID);
                                } else {
                                    this.knownCreatures.remove(creatureID);
                                }
                            }
                            if (!player.capabilities.isCreativeMode && --stack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                            }
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                            this.syncSpectralEntities();
                        }
                        this.showCurrentKnownEntities(player);
                        break;
                    }
                    case NONE: {
                        this.showCurrentKnownEntities(player);
                    }
                }
            }
        }

        public void clearBoundEntities(ItemStack stack, EntityPlayer player) {
            if (player != null && !player.worldObj.isRemote && stack != null) {
                this.knownCreatureTypes.clear();
                this.knownCreatures.clear();
                this.knownPlayers.clear();
                if (!player.capabilities.isCreativeMode) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, new ItemStack(Items.bucket));
                }
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
                this.syncSpectralEntities();
                this.showCurrentKnownEntities(player);
            }
        }

        public void cycleBoundMode(EntityPlayer player) {
            if (!this.worldObj.isRemote) {
                if (++this.alarmMode > 5) {
                    this.alarmMode = 0;
                }
                this.syncSpectralEntities();
                this.showCurrentKnownEntities(player);
            }
        }

        private void addGroupableType(Class<? extends EntityLiving> className) {
            String name = (String)EntityList.classToStringMapping.get(className);
            if (name != null) {
                String localName = StatCollector.translateToLocal((String)("entity." + name + ".name"));
                groupables.add(localName);
            }
        }

        private void showCurrentKnownEntities(EntityPlayer player) {
            StringBuffer sb = new StringBuffer();
            for (String s : this.knownPlayers) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            for (String s : this.knownCreatureTypes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("#");
                sb.append(s);
            }
            for (CreatureID cid : this.knownCreatures) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(cid.toString());
            }
            String message = sb.toString();
            String key = "";
            switch (this.alarmMode) {
                case 0: {
                    key = "tile.witchery.scarecrow.operation.playerwhitelist";
                    break;
                }
                case 1: {
                    key = "tile.witchery.scarecrow.operation.playerblacklist";
                    break;
                }
                case 2: {
                    key = "tile.witchery.scarecrow.operation.creaturewhitelist";
                    break;
                }
                case 3: {
                    key = "tile.witchery.scarecrow.operation.allnotfound";
                    break;
                }
                case 4: {
                    key = "tile.witchery.scarecrow.operation.onenotfound";
                    break;
                }
                case 5: {
                    key = "tile.witchery.scarecrow.operation.off";
                }
            }
            ChatUtil.sendTranslated((ICommandSender)player, key, message);
        }
    }

    public static class ClassItemBlock
    extends ItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        public String getItemStackDisplayName(ItemStack stack) {
            String s = super.getItemStackDisplayName(stack);
            String effect = InfusedSpiritEffect.getEffectDisplayName(stack);
            if (effect != null) {
                return s + " (" + effect + ")";
            }
            return s;
        }
    }
}

