/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.Config;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDreamCatcher
extends BlockBaseContainer {
    public BlockDreamCatcher() {
        super(Material.vine, TileEntityDreamCatcher.class);
        this.registerWithCreateTab = false;
        this.disableStats();
        this.setHardness(1.0f);
        this.setStepSound(soundTypeWood);
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return Blocks.planks.getBlockTextureFromSide(par1);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int posX, int posY, int posZ) {
        int side = par1IBlockAccess.getBlockMetadata(posX, posY, posZ);
        float bottom = 0.28125f;
        float top = 0.78125f;
        float left = 0.0f;
        float width = 1.0f;
        float depth = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        float minY = 0.0f;
        float maxY = 0.87f;
        float minX = 0.0f;
        float maxX = 0.08f;
        float minZ = 0.25f;
        float maxZ = 0.75f;
        if (side == 2) {
            this.setBlockBounds(minZ, minY, 1.0f - minX, maxZ, maxY, 1.0f - maxX);
        } else if (side == 3) {
            this.setBlockBounds(1.0f - maxZ, minY, minX, 1.0f - minZ, maxY, maxX);
        } else if (side == 4) {
            this.setBlockBounds(1.0f - minX, minY, minZ, 1.0f - maxX, maxY, maxZ);
        } else if (side == 5) {
            this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void breakBlock(World world, int posX, int posY, int posZ, Block par5, int par6) {
        TileEntityDreamCatcher tileEntityDreamCatcher;
        ItemGeneral.DreamWeave weave;
        TileEntity tileEntity;
        if (!world.isRemote && (tileEntity = world.getTileEntity(posX, posY, posZ)) != null && tileEntity instanceof TileEntityDreamCatcher && (weave = (tileEntityDreamCatcher = (TileEntityDreamCatcher)tileEntity).getWeave()) != null) {
            world.spawnEntityInWorld((Entity)new EntityItem(world, (double)posX, (double)posY, (double)posZ, weave.createStack()));
        }
        super.breakBlock(world, posX, posY, posZ, par5, par6);
    }

    public ArrayList<ItemStack> getDrops(World world, int posX, int posY, int posZ, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }

    public void onNeighborBlockChange(World world, int posX, int posY, int posZ, Block par5) {
        int metadata = world.getBlockMetadata(posX, posY, posZ);
        boolean flag = true;
        if (metadata == 2 && world.getBlock(posX, posY, posZ + 1).getMaterial().isSolid()) {
            flag = false;
        }
        if (metadata == 3 && world.getBlock(posX, posY, posZ - 1).getMaterial().isSolid()) {
            flag = false;
        }
        if (metadata == 4 && world.getBlock(posX + 1, posY, posZ).getMaterial().isSolid()) {
            flag = false;
        }
        if (metadata == 5 && world.getBlock(posX - 1, posY, posZ).getMaterial().isSolid()) {
            flag = false;
        }
        if (flag) {
            this.dropBlockAsItem(world, posX, posY, posZ, world.getBlockMetadata(posX, posY, posZ), 0);
            world.setBlockToAir(posX, posY, posZ);
        }
        super.onNeighborBlockChange(world, posX, posY, posZ, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
    }

    public static boolean causesNightmares(World world, int posX, int posY, int posZ) {
        TileEntity tileEntity = world.getTileEntity(posX, posY, posZ);
        if (tileEntity != null && tileEntity instanceof TileEntityDreamCatcher) {
            TileEntityDreamCatcher tileEntityDreamCatcher = (TileEntityDreamCatcher)tileEntity;
            return tileEntityDreamCatcher.dreamWeave == Witchery.Items.GENERIC.itemDreamNightmare;
        }
        return false;
    }

    public static boolean enhancesDreams(World world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityDreamCatcher) {
            TileEntityDreamCatcher tileEntityDreamCatcher = (TileEntityDreamCatcher)tileEntity;
            return tileEntityDreamCatcher.dreamWeave == Witchery.Items.GENERIC.itemDreamIntensity;
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityDreamCatcher catcherEntity;
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityDreamCatcher && (catcherEntity = (TileEntityDreamCatcher)tileEntity).getWeave() != null) {
            return catcherEntity.getWeave().createStack();
        }
        return Witchery.Items.GENERIC.itemDreamMove.createStack();
    }

    public static class TileEntityDreamCatcher
    extends TileEntity {
        private boolean buffIfDay;
        private boolean buffIfNight;
        private ItemGeneral.DreamWeave dreamWeave;
        private static final String DREAM_WEAVE_KEY = "WITCWeaveID";

        public void setEffect(ItemGeneral.DreamWeave dreamWeave) {
            this.dreamWeave = dreamWeave;
            if (!this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }

        public ItemGeneral.DreamWeave getWeave() {
            return this.dreamWeave;
        }

        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && this.dreamWeave != null) {
                if (this.buffIfDay || this.buffIfNight) {
                    boolean day = this.worldObj.isDaytime();
                    if (this.buffIfDay && day || this.buffIfNight && !day) {
                        boolean isDream = true;
                        boolean isEnhanced = false;
                        int r = 5;
                        boolean done = false;
                        for (int y = this.yCoord - 5; y <= this.yCoord + 5 && !done; ++y) {
                            for (int x = this.xCoord - 5; x <= this.xCoord + 5 && !done; ++x) {
                                for (int z = this.zCoord - 5; z <= this.zCoord + 5 && !done; ++z) {
                                    if (y == this.yCoord && x == this.xCoord && z == this.zCoord || this.worldObj.getBlock(x, y, z) != Witchery.Blocks.DREAM_CATCHER) continue;
                                    if (BlockDreamCatcher.causesNightmares(this.worldObj, x, y, z)) {
                                        isDream = false;
                                        done = isEnhanced;
                                        continue;
                                    }
                                    if (!BlockDreamCatcher.enhancesDreams(this.worldObj, x, y, z)) continue;
                                    isEnhanced = true;
                                    done = !isDream;
                                }
                            }
                        }
                        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.xCoord - 5), (double)(this.yCoord - 5), (double)(this.zCoord - 5), (double)(this.xCoord + 5), (double)(this.yCoord + 5), (double)(this.zCoord + 5));
                        List list = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                        for (EntityPlayer player : list) {
                            ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                            if ((!day || playerEx.isVampire()) && (day || !playerEx.isVampire())) continue;
                            this.dreamWeave.applyEffect(player, isDream, isEnhanced);
                        }
                    }
                    this.buffIfNight = false;
                    this.buffIfDay = false;
                }
                if (!this.buffIfDay && !this.buffIfNight && this.areAllPlayersAsleep(this.worldObj)) {
                    this.buffIfDay = !this.worldObj.provider.isDaytime();
                    this.buffIfNight = !this.buffIfDay;
                }
            }
        }

        private boolean areAllPlayersAsleep(World world) {
            Iterator iterator = world.playerEntities.iterator();
            int sleepThreshold = MathHelper.floor_float((float)(0.01f * (float)Config.instance().percentageOfPlayersSleepingForBuff * (float)world.playerEntities.size()));
            while (iterator.hasNext()) {
                EntityPlayer entityplayer = (EntityPlayer)iterator.next();
                if (!entityplayer.isPlayerSleeping() || --sleepThreshold > 0) continue;
                return true;
            }
            return false;
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            if (this.dreamWeave != null) {
                nbtTag.setInteger(DREAM_WEAVE_KEY, this.dreamWeave.weaveID);
            }
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            if (nbtTag.hasKey(DREAM_WEAVE_KEY)) {
                int dreamWeaveID = nbtTag.getInteger(DREAM_WEAVE_KEY);
                this.dreamWeave = Witchery.Items.GENERIC.weaves.get(dreamWeaveID);
            }
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

