/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.util.BlockUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCoffin
extends BlockBaseContainer {
    private static final int[][] DIRECTIONS = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockCoffin() {
        super(Material.wood, TileEntityCoffin.class);
        this.registerWithCreateTab = false;
        this.setHardness(1.0f);
        this.disableStats();
        this.setupBounds();
    }

    public static int getDirection(int meta) {
        return meta & 3;
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return true;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int j1;
        if (world.isRemote) {
            return true;
        }
        int i1 = world.getBlockMetadata(x, y, z);
        int origX = x;
        int origZ = z;
        if (!BlockCoffin.isBlockHeadOfBed(i1)) {
            j1 = BlockCoffin.getDirection(i1);
            if (world.getBlock(x += DIRECTIONS[j1][0], y, z += DIRECTIONS[j1][1]) != this) {
                return true;
            }
            i1 = world.getBlockMetadata(x, y, z);
        } else {
            j1 = BlockCoffin.getDirection(i1);
            origX -= DIRECTIONS[j1][0];
            origZ -= DIRECTIONS[j1][1];
        }
        if (player.isSneaking()) {
            TileEntityCoffin tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCoffin.class);
            if (tile != null) {
                TileEntityCoffin tile2;
                if (tile.open && BlockCoffin.isBedOccupied(i1)) {
                    EntityPlayer entityplayer1 = null;
                    for (EntityPlayer entityplayer2 : world.playerEntities) {
                        if (!entityplayer2.isPlayerSleeping()) continue;
                        ChunkCoordinates chunkcoordinates = entityplayer2.playerLocation;
                        if (chunkcoordinates.posX != x || chunkcoordinates.posY != y || chunkcoordinates.posZ != z) continue;
                        entityplayer1 = entityplayer2;
                    }
                    if (entityplayer1 != null) {
                        return true;
                    }
                }
                if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || world.isSideSolid(origX, y + 1, origZ, ForgeDirection.DOWN)) {
                    return true;
                }
                tile.open = !tile.open;
                if (!BlockCoffin.isBlockHeadOfBed(i1)) {
                    int j12 = BlockCoffin.getDirection(i1);
                    tile2 = BlockUtil.getTileEntity((IBlockAccess)world, x + DIRECTIONS[j12][0], y, z + DIRECTIONS[j12][1], TileEntityCoffin.class);
                    if (tile2 != null) {
                        tile2.open = tile.open;
                        world.markBlockForUpdate(tile2.xCoord, tile2.yCoord, tile2.zCoord);
                    }
                } else {
                    int j13 = BlockCoffin.getDirection(i1);
                    tile2 = BlockUtil.getTileEntity((IBlockAccess)world, x - DIRECTIONS[j13][0], y, z - DIRECTIONS[j13][1], TileEntityCoffin.class);
                    if (tile2 != null) {
                        tile2.open = tile.open;
                        world.markBlockForUpdate(tile2.xCoord, tile2.yCoord, tile2.zCoord);
                    }
                }
                world.markBlockForUpdate(x, y, z);
            }
            return true;
        }
        TileEntityCoffin tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCoffin.class);
        if (tile != null) {
            if (!tile.open) {
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("witchery.nosleep.closedcoffin", new Object[0]));
                return true;
            }
        } else {
            return true;
        }
        if (world.provider.canRespawnHere() && world.getBiomeGenForCoords(x, z) != BiomeGenBase.hell) {
            EntityPlayer.EnumStatus enumstatus;
            if (BlockCoffin.isBedOccupied(i1)) {
                EntityPlayer entityplayer1 = null;
                for (EntityPlayer entityplayer2 : world.playerEntities) {
                    if (!entityplayer2.isPlayerSleeping()) continue;
                    ChunkCoordinates chunkcoordinates = entityplayer2.playerLocation;
                    if (chunkcoordinates.posX != x || chunkcoordinates.posY != y || chunkcoordinates.posZ != z) continue;
                    entityplayer1 = entityplayer2;
                }
                if (entityplayer1 != null) {
                    player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("tile.bed.occupied", new Object[0]));
                    return true;
                }
                BlockCoffin.setBedOccupied(world, x, y, z, false);
            }
            if ((enumstatus = player.sleepInBedAt(x, y, z)) == EntityPlayer.EnumStatus.OK) {
                BlockCoffin.setBedOccupied(world, x, y, z, true);
                return true;
            }
            if (enumstatus == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
            } else if (enumstatus == EntityPlayer.EnumStatus.NOT_SAFE) {
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return true;
        }
        double d2 = (double)x + 0.5;
        double d0 = (double)y + 0.5;
        double d1 = (double)z + 0.5;
        world.setBlockToAir(x, y, z);
        int k1 = BlockCoffin.getDirection(i1);
        if (world.getBlock(x += DIRECTIONS[k1][0], y, z += DIRECTIONS[k1][1]) == this) {
            world.setBlockToAir(x, y, z);
            d2 = (d2 + (double)x + 0.5) / 2.0;
            d0 = (d0 + (double)y + 0.5) / 2.0;
            d1 = (d1 + (double)z + 0.5) / 2.0;
        }
        world.newExplosion((Entity)null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
        return true;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        super.setBlockBoundsBasedOnState(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = BlockCoffin.getDirection(l);
        if (BlockCoffin.isBlockHeadOfBed(l)) {
            if (world.getBlock(x - DIRECTIONS[i1][0], y, z - DIRECTIONS[i1][1]) != this) {
                world.setBlockToAir(x, y, z);
            }
        } else if (world.getBlock(x + DIRECTIONS[i1][0], y, z + DIRECTIONS[i1][1]) != this) {
            world.setBlockToAir(x, y, z);
            if (!world.isRemote) {
                this.dropBlockAsItem(world, x, y, z, l, 0);
            }
        }
    }

    public Item getItemDropped(int meta, Random rand, int p_149650_3_) {
        return BlockCoffin.isBlockHeadOfBed(meta) ? Item.getItemById((int)0) : Witchery.Items.COFFIN;
    }

    private void setupBounds() {
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List boxes, Entity entity) {
        TileEntityCoffin tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCoffin.class);
        if (tile != null && !tile.open) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        float baseHeight = 0.4375f;
        float wallThick = 0.05f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, baseHeight, 1.0f);
        super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
        int direction = BlockCoffin.getDirection(meta);
        boolean head = BlockCoffin.isBlockHeadOfBed(meta);
        boolean n = true;
        boolean s = true;
        boolean e = true;
        boolean w = true;
        boolean n1 = false;
        boolean s1 = false;
        boolean e1 = false;
        boolean w1 = false;
        switch (direction) {
            case 0: {
                n = !head;
                s = head;
                e1 = true;
                break;
            }
            case 1: {
                e = !head;
                w = head;
                s1 = true;
                break;
            }
            case 2: {
                s = !head;
                n = head;
                w1 = true;
                break;
            }
            case 3: {
                w = !head;
                e = head;
                n1 = true;
            }
        }
        if (n) {
            this.setBlockBounds(0.0f, baseHeight, 0.0f, 1.0f, n1 ? 2.0f : 1.0f, wallThick);
            super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
        }
        if (s) {
            this.setBlockBounds(0.0f, baseHeight, 1.0f - wallThick, 1.0f, s1 ? 2.0f : 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
        }
        if (w) {
            this.setBlockBounds(0.0f, baseHeight, 0.0f, wallThick, w1 ? 2.0f : 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
        }
        if (e) {
            this.setBlockBounds(1.0f - wallThick, baseHeight, 0.0f, 1.0f, e1 ? 2.0f : 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, mask, boxes, entity);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        this.setupBounds();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + 1.0), (double)((double)z + this.maxZ));
    }

    public static boolean isBlockHeadOfBed(int meta) {
        return (meta & 8) != 0;
    }

    public static boolean isBedOccupied(int meta) {
        return (meta & 4) != 0;
    }

    public static void setBedOccupied(World world, int x, int y, int z, boolean p_149979_4_) {
        int l = world.getBlockMetadata(x, y, z);
        l = p_149979_4_ ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.setBlockMetadataWithNotify(x, y, z, l, 3);
    }

    public static ChunkCoordinates func_149977_a(World world, int x, int y, int z, int p_149977_4_) {
        int i1 = world.getBlockMetadata(x, y, z);
        int j1 = BlockDirectional.getDirection((int)i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = x - DIRECTIONS[j1][0] * k1 - 1;
            int i2 = z - DIRECTIONS[j1][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)l2, (int)(y - 1), (int)i3) || world.getBlock(l2, y, i3).getMaterial().isOpaque() || world.getBlock(l2, y + 1, i3).getMaterial().isOpaque()) continue;
                    if (p_149977_4_ <= 0) {
                        return new ChunkCoordinates(l2, y, i3);
                    }
                    --p_149977_4_;
                }
            }
        }
        return null;
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int p_149690_5_, float p_149690_6_, int p_149690_7_) {
        if (!BlockCoffin.isBlockHeadOfBed(p_149690_5_)) {
            super.dropBlockAsItemWithChance(world, x, y, z, p_149690_5_, p_149690_6_, 0);
        }
    }

    public int getMobilityFlag() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return Witchery.Items.COFFIN;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        int i1;
        if (player.capabilities.isCreativeMode && BlockCoffin.isBlockHeadOfBed(meta) && world.getBlock(x -= DIRECTIONS[i1 = BlockCoffin.getDirection(meta)][0], y, z -= DIRECTIONS[i1][1]) == this) {
            world.setBlockToAir(x, y, z);
        }
    }

    public static class TileEntityCoffin
    extends TileEntity {
        private boolean open;
        public float lidAngle;
        public float prevLidAngle;

        public void updateEntity() {
            this.prevLidAngle = this.lidAngle;
            if (this.open && this.lidAngle == 0.0f) {
                double d1 = (double)this.xCoord + 0.5;
                double d0 = (double)this.zCoord + 0.5;
                this.worldObj.playSoundEffect(d1, (double)this.yCoord + 0.5, d0, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (!this.open && this.lidAngle > 0.0f || this.open && this.lidAngle < 1.0f) {
                float f2;
                float f = 0.1f;
                float f1 = this.lidAngle;
                this.lidAngle = this.open ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                    double d0 = (double)this.xCoord + 0.5;
                    double d2 = (double)this.zCoord + 0.5;
                    this.worldObj.playSoundEffect(d0, (double)this.yCoord + 0.5, d2, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            nbtTag.setFloat("Angle", this.lidAngle);
            nbtTag.setFloat("AnglePrev", this.prevLidAngle);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            NBTTagCompound nbtTag = packet.func_148857_g();
            this.readFromNBT(nbtTag);
            this.lidAngle = nbtTag.getFloat("Angle");
            this.prevLidAngle = nbtTag.getFloat("AnglePrev");
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setBoolean("Opened", this.open);
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
            this.open = nbtRoot.getBoolean("Opened");
        }
    }
}

