/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBase;
import com.emoniph.witchery.client.particle.NaturePowerFX;
import com.emoniph.witchery.util.ParticleEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCircleGlyph
extends BlockBase {
    private int color;
    private boolean charged;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockCircleGlyph(int color, boolean charged) {
        super(Material.vine);
        this.registerWithCreateTab = false;
        this.color = color;
        this.charged = charged;
        this.setResistance(1000.0f);
        this.setHardness(2.0f);
        float f = 0.5f;
        float f1 = 0.015625f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
    }

    public void onBlockClicked(World world, int posX, int posY, int posZ, EntityPlayer player) {
        ItemStack itemstack;
        if (!world.isRemote && (itemstack = player.getHeldItem()) != null && (Witchery.Items.GENERIC.itemBroom.isMatch(itemstack) || Witchery.Items.GENERIC.itemBroomEnchanted.isMatch(itemstack))) {
            world.func_147480_a(posX, posY, posZ, false);
        }
    }

    public void harvestBlock(World world, EntityPlayer player, int posX, int posY, int posZ, int meta) {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegistrar) {
        this.icons = new IIcon[12];
        for (int glyph = 0; glyph < this.icons.length; ++glyph) {
            this.icons[glyph] = iconRegistrar.registerIcon(this.getTextureName() + String.format("%d.%d", this.color + 1, glyph + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int face, int metadata) {
        return this.icons[MathHelper.clamp_int((int)metadata, (int)0, (int)12)];
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (this.color > 0) {
            double d0 = (float)x + 0.4f + rand.nextFloat() * 0.2f;
            double d1 = (float)y + 0.1f + rand.nextFloat() * 0.3f;
            double d2 = (float)z + 0.4f + rand.nextFloat() * 0.2f;
            world.spawnParticle(this.color == 2 ? ParticleEffect.FLAME.toString() : ParticleEffect.PORTAL.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
        } else if (this.charged) {
            double d0 = (float)x + 0.3f + rand.nextFloat() * 0.4f;
            double d1 = (float)y + 0.1f + rand.nextFloat() * 0.3f;
            double d2 = (float)z + 0.3f + rand.nextFloat() * 0.4f;
            NaturePowerFX sparkle = new NaturePowerFX(world, d0, d1, d2);
            sparkle.setScale(0.6f);
            sparkle.setGravity(0.01f);
            sparkle.setCanMove(true);
            double maxSpeed = 0.01;
            double doubleSpeed = 0.02;
            sparkle.setVelocity(rand.nextDouble() * 0.02 - 0.01, rand.nextDouble() * 0.02 + 0.01, rand.nextDouble() * 0.02 - 0.01);
            sparkle.setMaxAge(10 + rand.nextInt(5));
            float maxColorShift = 0.2f;
            float doubleColorShift = maxColorShift * 2.0f;
            float colorshiftR = rand.nextFloat() * doubleColorShift - maxColorShift;
            float colorshiftG = rand.nextFloat() * doubleColorShift - maxColorShift;
            float colorshiftB = rand.nextFloat() * doubleColorShift - maxColorShift;
            float red = 1.0f;
            float green = 0.8f;
            float blue = 0.2f;
            sparkle.setRBGColorF(red + colorshiftR, green + colorshiftG, blue + colorshiftB);
            sparkle.setAlphaF(0.1f);
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)sparkle);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        this.func_111046_k(world, x, y, z);
    }

    private boolean func_111046_k(World world, int x, int y, int z) {
        if (!this.canBlockStay(world, x, y, z)) {
            world.setBlockToAir(x, y, z);
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        Material materialBelow = world.getBlock(x, y - 1, z).getMaterial();
        return !world.isAirBlock(x, y - 1, z) && materialBelow != null && materialBelow.isOpaque() && materialBelow.isSolid();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return side == 1;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block == Witchery.Blocks.GLYPH_INFERNAL) {
            return new ItemStack(Witchery.Items.CHALK_INFERNAL);
        }
        if (block == Witchery.Blocks.GLYPH_OTHERWHERE) {
            return new ItemStack(Witchery.Items.CHALK_OTHERWHERE);
        }
        return new ItemStack(Witchery.Items.CHALK_RITUAL);
    }
}

