/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.util.ChatUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockBloodRose
extends BlockBaseContainer
implements IPlantable {
    private final float RADIUS = 0.2f;
    @SideOnly(value=Side.CLIENT)
    private IIcon fullIcon;

    public BlockBloodRose() {
        super(Material.plants, TileEntityBloodRose.class);
        this.setHardness(0.0f);
        this.setStepSound(soundTypeGrass);
        this.setBlockBounds(0.3f, 0.0f, 0.3f, 0.7f, 0.6f, 0.7f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 1;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBox((double)((float)par2 + 0.5f - 0.2f + 0.0625f), (double)par3, (double)((float)par4 + 0.5f - 0.2f + 0.0625f), (double)((float)par2 + 0.5f + 0.2f - 0.0625f), (double)((float)par3 + 0.6f - 0.0625f), (double)((float)par4 + 0.5f + 0.2f - 0.0625f));
    }

    public void onEntityCollidedWithBlock(World world, int posX, int posY, int posZ, Entity entity) {
        TileEntity tileentity;
        if (!world.isRemote && entity instanceof EntityPlayer && (tileentity = world.getTileEntity(posX, posY, posZ)) != null && tileentity instanceof TileEntityBloodRose) {
            TileEntityBloodRose chest = (TileEntityBloodRose)tileentity;
            chest.storePlayer((EntityPlayer)entity);
        }
    }

    public int damageDropped(int par1) {
        return 0;
    }

    public Item getItemDropped(int par1, Random rand, int fortune) {
        return null;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        TileEntityBloodRose tileentitychest = new TileEntityBloodRose();
        return tileentitychest;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon(this.getTextureName());
        this.fullIcon = par1IconRegister.registerIcon(this.getTextureName() + "_full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 0) {
            return super.getIcon(side, meta);
        }
        return this.fullIcon;
    }

    public static class TileEntityBloodRose
    extends TileEntity {
        private String customName;
        public ArrayList<String> players = new ArrayList();

        public boolean canUpdate() {
            return false;
        }

        public void sync() {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }

        public void storePlayer(EntityPlayer player) {
            if (!this.worldObj.isRemote && player != null) {
                if (this.players.size() == 0) {
                    this.players.add(player.getCommandSenderName());
                } else {
                    this.players.set(0, player.getCommandSenderName());
                }
                if (this.getBlockMetadata() != 1) {
                    this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 1, 3);
                    this.sync();
                }
            }
        }

        public String popUserExcept(EntityPlayer usingPlayer, boolean excludeUser) {
            String missingPlayers = "";
            for (int i = this.players.size() - 1; i >= 0; --i) {
                String foundPlayerName = this.players.get(i);
                if (!excludeUser || !foundPlayerName.equals(usingPlayer.getCommandSenderName())) {
                    if (this.worldObj.getPlayerEntityByName(foundPlayerName) != null) {
                        this.players.remove(i);
                        this.sync();
                        if (this.players.size() == 0) {
                            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 3);
                        }
                        return foundPlayerName;
                    }
                    missingPlayers = missingPlayers + foundPlayerName + " ";
                    continue;
                }
                if (this.players.size() != 1) continue;
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)usingPlayer, "tile.witcheryLeechChest.onlyowntaglock", new Object[0]);
                return null;
            }
            if (!missingPlayers.isEmpty()) {
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)usingPlayer, "tile.witcheryLeechChest.playernotloggedin", missingPlayers);
            }
            return null;
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
            super.readFromNBT(par1NBTTagCompound);
            this.players.clear();
            NBTTagList nbtPlayersList = par1NBTTagCompound.getTagList("WITCPlayers", 10);
            for (int i = 0; i < nbtPlayersList.tagCount(); ++i) {
                NBTTagCompound nbtPlayer = nbtPlayersList.getCompoundTagAt(i);
                String s = nbtPlayer.getString("Player");
                if (s == null || s.isEmpty()) continue;
                this.players.add(s);
            }
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            NBTTagList nbtItemsList = new NBTTagList();
            NBTTagList nbtPlayers = new NBTTagList();
            for (int i = 0; i < this.players.size(); ++i) {
                NBTTagCompound nbtPlayer = new NBTTagCompound();
                nbtPlayer.setString("Player", this.players.get(i));
                nbtPlayers.appendTag((NBTBase)nbtPlayer);
            }
            nbtTag.setTag("WITCPlayers", (NBTBase)nbtPlayers);
        }
    }
}

