/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBarrier
extends BlockBaseContainer {
    public static void setBlock(World world, int posX, int posY, int posZ, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner) {
        BlockBarrier.setBlock(world, posX, posY, posZ, ticksUntilExpiration, blocksPlayers, owner, false);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner, boolean skipCreate) {
        TileEntity entity;
        if (!skipCreate) {
            world.setBlock(posX, posY, posZ, Witchery.Blocks.BARRIER, 0, 3);
        }
        if ((entity = world.getTileEntity(posX, posY, posZ)) != null && entity instanceof TileEntityBarrier) {
            TileEntityBarrier tileEntity = (TileEntityBarrier)entity;
            tileEntity.setTicksUntilExpiration(ticksUntilExpiration);
            tileEntity.setBlocksPlayers(blocksPlayers);
            tileEntity.setOwner(owner);
        }
    }

    public BlockBarrier() {
        super(Material.glass, TileEntityBarrier.class);
        this.registerWithCreateTab = false;
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setLightOpacity(0);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int posX, int posY, int posZ) {
        TileEntity te = world.getTileEntity(posX, posY, posZ);
        if (te != null && te instanceof TileEntityBarrier) {
            TileEntityBarrier tileEntity = (TileEntityBarrier)te;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)((double)posY + 0.9), (double)(posZ + 1));
            List players = world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
            for (EntityPlayer player : players) {
                if (player == null || tileEntity.getBlocksPlayers() && (!player.capabilities.isCreativeMode || !player.isSneaking()) && !tileEntity.isOwner(player)) continue;
                return null;
            }
        }
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBox((double)((float)posX + 0.0625f), (double)((float)posY + 0.0625f), (double)((float)posZ + 0.0625f), (double)((float)(posX + 1) - 0.0625f), (double)((float)(posY + 1) - 0.0625f), (double)((float)(posZ + 1) - 0.0625f));
    }

    protected boolean canSilkHarvest() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean shouldSideBeRendered(IBlockAccess blockAccess, int posX, int posY, int posZ, int side) {
        Block i1 = blockAccess.getBlock(posX, posY, posZ);
        return i1 == this ? false : super.shouldSideBeRendered(blockAccess, posX, posY, posZ, side);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }

    public static class TileEntityBarrier
    extends TileEntity {
        private int ticksUntilExpiration = 60;
        private boolean blocksPlayers;
        private String ownerName = "";
        private static final String KEY_REMAINING_TICKS = "remainingTicks";
        private static final String KEY_BLOCKS_PLAYERS = "blocksPlayers";
        private static final String KEY_OWNER_NAME = "owner";

        public void updateEntity() {
            super.updateEntity();
            if (--this.ticksUntilExpiration <= 0 && !this.worldObj.isRemote) {
                this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.air, 0, 3);
            }
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            nbtTag.setInteger(KEY_REMAINING_TICKS, this.ticksUntilExpiration);
            nbtTag.setBoolean(KEY_BLOCKS_PLAYERS, this.blocksPlayers);
            nbtTag.setString(KEY_OWNER_NAME, this.ownerName);
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            this.ticksUntilExpiration = nbtTag.getInteger(KEY_REMAINING_TICKS);
            this.blocksPlayers = nbtTag.getBoolean(KEY_BLOCKS_PLAYERS);
            this.ownerName = nbtTag.getString(KEY_OWNER_NAME);
        }

        public void setTicksUntilExpiration(int ticksUntilExpiration) {
            this.ticksUntilExpiration = ticksUntilExpiration;
        }

        public void setBlocksPlayers(boolean blocksPlayers) {
            this.blocksPlayers = blocksPlayers;
        }

        public boolean getBlocksPlayers() {
            return this.blocksPlayers;
        }

        public void setOwner(EntityPlayer owner) {
            this.ownerName = owner != null ? owner.getCommandSenderName() : "";
        }

        public boolean isOwner(EntityPlayer player) {
            return player != null && player.getCommandSenderName().equals(this.ownerName);
        }
    }
}

