/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.BlockChalice;
import com.emoniph.witchery.blocks.BlockPlacedItem;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.client.particle.NaturePowerFX;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.util.BlockSide;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;

public class BlockAltar
extends BlockBaseContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon blockIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon blockIconJoined;
    @SideOnly(value=Side.CLIENT)
    private IIcon blockIconTopJoined;
    private static final int ELEMENTS_IN_COMPLETE_ALTAR = 6;

    public BlockAltar() {
        super(Material.rock, TileEntityAltar.class);
        this.setHardness(2.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityAltar();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        switch (BlockSide.fromInteger(side)) {
            case TOP: {
                return metadata == 0 ? this.blockIconTop : this.blockIconTopJoined;
            }
            case BOTTOM: {
                return this.blockIconTop;
            }
        }
        return metadata == 0 ? this.blockIcon : this.blockIconJoined;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int i = Minecraft.getMinecraft().gameSettings.particleSetting;
        if (i == 2 || i == 1 && rand.nextInt(3) == 0) {
            return;
        }
        if (world.getBlockMetadata(x, y, z) == 1) {
            int plantZ;
            int plantY;
            int RADIUS = 16;
            int VERT = 4;
            int plantX = x - 16 + rand.nextInt(32) + 1;
            Block block = world.getBlock(plantX, plantY = y - 4 + rand.nextInt(8) + 1, plantZ = z - 16 + rand.nextInt(32) + 1);
            if (block != null && (block instanceof BlockFlower || block instanceof BlockLeaves || block instanceof BlockCrops || block instanceof IPlantable)) {
                int dir_x = x - plantX;
                int dir_y = y - plantY;
                int dir_z = z - plantZ;
                double distance = Math.sqrt(dir_x * dir_x + dir_y * dir_y + dir_z * dir_z);
                double speed = 0.25;
                double factor = speed / distance;
                double vel_x = (double)dir_x * factor;
                double vel_y = (double)dir_y * factor;
                double vel_z = (double)dir_z * factor;
                NaturePowerFX sparkle = new NaturePowerFX(world, 0.5 + (double)plantX, 0.5 + (double)plantY, 0.5 + (double)plantZ);
                sparkle.setMaxAge((int)(distance / speed)).setGravity(0.0f).setScale(1.0f).setVelocity(vel_x, vel_y, vel_z);
                sparkle.setCanMove(true);
                sparkle.setRBGColorF(0.2f, 0.8f, 0.0f);
                Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)sparkle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon(this.getTextureName());
        this.blockIconTop = iconRegister.registerIcon(this.getTextureName() + "_top");
        this.blockIconJoined = iconRegister.registerIcon(this.getTextureName() + "_joined");
        this.blockIconTopJoined = iconRegister.registerIcon(this.getTextureName() + "_joined_top");
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityAltar tileEntity = (TileEntityAltar)world.getTileEntity(x, y, z);
        if (tileEntity.isValidAndUpdate()) {
            player.openGui((Object)Witchery.instance, 0, world, x, y, z);
            return true;
        }
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        super.onBlockPlacedBy(world, x, y, z, par5EntityLivingBase, par6ItemStack);
        this.updateMultiblock(world, x, y, z, null);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        this.updateMultiblock(world, x, y, z, new Coord(x, y, z));
        super.breakBlock(world, x, y, z, block, par6);
    }

    public void onBlockDestroyedByExplosion(World world, int posX, int posY, int posZ, Explosion explosion) {
        TileEntityAltar tileEntity = (TileEntityAltar)world.getTileEntity(posX, posY, posZ);
        this.updateMultiblock(world, posX, posY, posZ, null);
    }

    public void onNeighborBlockChange(World world, int posX, int posY, int posZ, Block block) {
        TileEntity tileEntity = world.getTileEntity(posX, posY, posZ);
        if (tileEntity != null && tileEntity instanceof TileEntityAltar && !world.isRemote) {
            TileEntityAltar tileEntityAltar = (TileEntityAltar)tileEntity;
            tileEntityAltar.updateCoreArtefacts();
        }
        super.onNeighborBlockChange(world, posX, posY, posZ, block);
    }

    private void updateMultiblock(World world, int x, int y, int z, Coord exclude) {
        if (!world.isRemote) {
            TileEntity te;
            ArrayList<Coord> visited = new ArrayList<Coord>();
            ArrayList<Coord> toVisit = new ArrayList<Coord>();
            toVisit.add(new Coord(x, y, z));
            boolean valid = true;
            while (toVisit.size() > 0) {
                Coord coord = (Coord)toVisit.get(0);
                toVisit.remove(0);
                int neighbours = 0;
                for (Coord newCoord : new Coord[]{coord.north(), coord.south(), coord.east(), coord.west()}) {
                    if (newCoord.getBlock(world) != this) continue;
                    if (!visited.contains(newCoord) && !toVisit.contains(newCoord)) {
                        toVisit.add(newCoord);
                    }
                    ++neighbours;
                }
                if (coord.equals(exclude)) continue;
                if (neighbours < 2 || neighbours > 3) {
                    valid = false;
                }
                visited.add(coord);
            }
            Coord newCore = valid && visited.size() == 6 ? (Coord)visited.get(0) : null;
            for (Coord coord : visited) {
                TileEntity te2 = coord.getBlockTileEntity(world);
                if (te2 == null || !(te2 instanceof TileEntityAltar)) continue;
                TileEntityAltar tile = (TileEntityAltar)te2;
                tile.setCore(newCore);
            }
            if (exclude != null && (te = exclude.getBlockTileEntity(world)) != null && te instanceof TileEntityAltar) {
                TileEntityAltar tile = (TileEntityAltar)te;
                tile.setCore(null);
            }
        }
    }

    public static class TileEntityAltar
    extends TileEntityBase
    implements IPowerSource {
        private Coord core;
        private float power;
        private float maxPower;
        private int powerScale;
        private int rechargeScale;
        private int enhancementLevel;
        private int rangeScale = 1;
        long lastPowerUpdate = 0L;
        private static final int SCAN_DISTANCE = 14;
        private ArrayList<Block> extraNatureIDs = null;

        @Override
        public boolean isPowerInvalid() {
            return this.isInvalid();
        }

        @Override
        protected void initiate() {
            super.initiate();
            if (!this.worldObj.isRemote && this.isCore()) {
                if (this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) == Witchery.Blocks.ALTAR) {
                    Log.instance().debug("Initiating altar tile at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                    PowerSources.instance().registerPowerSource(this);
                } else {
                    Log.instance().warning("Altar tile entity exists without a corresponding block at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                }
            }
        }

        public void invalidate() {
            super.invalidate();
            if (!this.worldObj.isRemote) {
                if (this.isCore()) {
                    Log.instance().debug("Invalidating void bramble tile at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                }
                PowerSources.instance().removePowerSource(this);
            }
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote) {
                float maxPowerScaled = this.maxPower * (float)this.powerScale;
                if (this.isCore()) {
                    if (this.power < maxPowerScaled) {
                        float basePowerPerUpdate = 10.0f;
                        if (this.ticks % 20L == 0L) {
                            this.power = (int)Math.min(this.power + 10.0f * (float)this.rechargeScale, maxPowerScaled);
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                    } else if (this.power > maxPowerScaled && this.ticks % 20L == 0L) {
                        this.power = maxPowerScaled;
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            }
        }

        @Override
        public float getRange() {
            return 16 * this.rangeScale;
        }

        @Override
        public int getEnhancementLevel() {
            return this.enhancementLevel;
        }

        public boolean isValidAndUpdate() {
            if (this.isValid() && !this.worldObj.isRemote) {
                TileEntity tile = this.core.getBlockTileEntity(this.worldObj);
                if (tile != null && tile instanceof TileEntityAltar) {
                    TileEntityAltar tileEntity = (TileEntityAltar)tile;
                    tileEntity.updateArtefacts();
                    tileEntity.updatePower(true);
                    return true;
                }
                return false;
            }
            return this.isValid();
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            if (this.core != null) {
                this.core.setNBT(nbtTag, "Core");
            }
            if (this.isCore()) {
                nbtTag.setFloat("Power", this.power);
                nbtTag.setFloat("MaxPower", this.maxPower);
                nbtTag.setInteger("PowerScale", this.powerScale);
                nbtTag.setInteger("RechargeScale", this.rechargeScale);
                nbtTag.setInteger("RangeScale", this.rangeScale);
                nbtTag.setInteger("EnhancementLevel", this.enhancementLevel);
            }
            super.writeToNBT(nbtTag);
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            this.core = Coord.createFrom(nbtTag, "Core");
            this.power = nbtTag.getFloat("Power");
            this.maxPower = nbtTag.getFloat("MaxPower");
            this.powerScale = nbtTag.getInteger("PowerScale");
            this.rechargeScale = nbtTag.getInteger("RechargeScale");
            this.rangeScale = nbtTag.hasKey("RangeScale") ? nbtTag.getInteger("RangeScale") : 1;
            this.enhancementLevel = nbtTag.hasKey("EnhancementLevel") ? nbtTag.getInteger("EnhancementLevel") : 0;
            super.readFromNBT(nbtTag);
        }

        private void setCore(Coord coord) {
            this.core = coord;
            if (this.isCore()) {
                this.updatePower(false);
                PowerSources.instance().registerPowerSource(this);
            }
            if (coord == null) {
                PowerSources.instance().removePowerSource(this);
                this.power = 0.0f;
                this.maxPower = 0.0f;
                this.powerScale = 1;
                this.rechargeScale = 1;
                this.rangeScale = 1;
                this.enhancementLevel = 0;
            }
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, coord != null ? 1 : 0, 3);
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }

        private boolean isCore() {
            return this.core != null && this.core.isAtPosition(this);
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public float getCorePower() {
            TileEntity te;
            if (this.core != null && (te = this.core.getBlockTileEntity(this.worldObj)) != null && te instanceof TileEntityAltar) {
                TileEntityAltar tileEntity = (TileEntityAltar)te;
                return tileEntity.power;
            }
            return 0.0f;
        }

        private void updateCoreArtefacts() {
            TileEntity tile;
            if (this.core != null && (tile = this.core.getBlockTileEntity(this.worldObj)) != null && tile instanceof TileEntityAltar) {
                TileEntityAltar tileEntity = (TileEntityAltar)tile;
                tileEntity.updateArtefacts();
            }
        }

        @Override
        public boolean consumePower(float requiredPower) {
            TileEntityAltar tileEntity;
            if (this.core != null && (tileEntity = (TileEntityAltar)this.core.getBlockTileEntity(this.worldObj)) != null) {
                return tileEntity.consumeOurPower(requiredPower);
            }
            return false;
        }

        private boolean consumeOurPower(float requiredPower) {
            if (!this.worldObj.isRemote && this.power >= requiredPower) {
                this.power -= requiredPower;
                return true;
            }
            return false;
        }

        @Override
        public float getCurrentPower() {
            TileEntityAltar tileEntity;
            if (this.core != null && (tileEntity = (TileEntityAltar)this.core.getBlockTileEntity(this.worldObj)) != null) {
                return tileEntity.getOurCurrentPower();
            }
            return -1.0f;
        }

        private float getOurCurrentPower() {
            if (!this.worldObj.isRemote) {
                return this.power;
            }
            return -2.0f;
        }

        public float getCoreMaxPower() {
            TileEntity tile;
            if (this.core != null && (tile = this.core.getBlockTileEntity(this.worldObj)) != null && tile instanceof TileEntityAltar) {
                TileEntityAltar tileEntity = (TileEntityAltar)tile;
                return tileEntity.maxPower * (float)tileEntity.powerScale;
            }
            return 0.0f;
        }

        public int getCoreSpeed() {
            TileEntity tile;
            if (this.core != null && (tile = this.core.getBlockTileEntity(this.worldObj)) != null && tile instanceof TileEntityAltar) {
                TileEntityAltar tileEntity = (TileEntityAltar)tile;
                return tileEntity.rechargeScale;
            }
            return 0;
        }

        public boolean isValid() {
            return this.core != null;
        }

        @Override
        public World getWorld() {
            return this.worldObj;
        }

        @Override
        public Coord getLocation() {
            return new Coord(this);
        }

        @Override
        public boolean isLocationEqual(Coord location) {
            return location != null && location.isAtPosition(this);
        }

        private void updatePower(boolean throttle) {
            if (!(this.worldObj.isRemote || throttle && this.ticks - this.lastPowerUpdate > 0L && this.ticks - this.lastPowerUpdate <= 100L)) {
                Block block;
                this.lastPowerUpdate = this.ticks;
                Hashtable<Block, PowerSource> powerObjectTable = new Hashtable<Block, PowerSource>();
                try {
                    for (ItemStack blockItem : OreDictionary.getOres((String)"treeSapling")) {
                        block = Block.getBlockFromItem((Item)blockItem.getItem());
                        if (block == null) continue;
                        PowerSource.createInMap(powerObjectTable, block, 4, 20);
                    }
                }
                catch (Exception e) {
                    Log.instance().warning(e, "Exception occurred while creating power source list for sapling ores");
                }
                try {
                    for (ItemStack blockItem : OreDictionary.getOres((String)"logWood")) {
                        block = Block.getBlockFromItem((Item)blockItem.getItem());
                        if (block == null) continue;
                        PowerSource.createInMap(powerObjectTable, block, 2, 50);
                    }
                }
                catch (Exception e) {
                    Log.instance().warning(e, "Exception occurred while creating power source list for log ores");
                }
                try {
                    for (ItemStack blockItem : OreDictionary.getOres((String)"treeLeaves")) {
                        block = Block.getBlockFromItem((Item)blockItem.getItem());
                        if (block == null) continue;
                        PowerSource.createInMap(powerObjectTable, block, 3, 100);
                    }
                }
                catch (Exception e) {
                    Log.instance().warning(e, "Exception occurred while creating power source list for leaf ores");
                }
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.grass, 2, 80);
                PowerSource.createInMap(powerObjectTable, Blocks.dirt, 1, 80);
                PowerSource.createInMap(powerObjectTable, Blocks.farmland, 1, 100);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.tallgrass, 3, 50);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.yellow_flower, 4, 30);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.red_flower, 4, 30);
                PowerSource.createInMap(powerObjectTable, Blocks.wheat, 4, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.water, 1, 50);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.red_mushroom, 3, 20);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.brown_mushroom, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.cactus, 3, 50);
                PowerSource.createInMap(powerObjectTable, Blocks.reeds, 3, 50);
                PowerSource.createInMap(powerObjectTable, Blocks.pumpkin, 4, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.pumpkin_stem, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.brown_mushroom_block, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.red_mushroom_block, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.melon_block, 4, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.melon_stem, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.vine, 2, 50);
                PowerSource.createInMap(powerObjectTable, (Block)Blocks.mycelium, 1, 80);
                PowerSource.createInMap(powerObjectTable, Blocks.dragon_egg, 250, 1);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.DEMON_HEART, 40, 2);
                PowerSource.createInMap(powerObjectTable, Blocks.cocoa, 3, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.carrots, 4, 20);
                PowerSource.createInMap(powerObjectTable, Blocks.potatoes, 4, 20);
                PowerSource.createInMap(powerObjectTable, (Block)Witchery.Blocks.CROP_BELLADONNA, 4, 20);
                PowerSource.createInMap(powerObjectTable, (Block)Witchery.Blocks.CROP_MANDRAKE, 4, 20);
                PowerSource.createInMap(powerObjectTable, (Block)Witchery.Blocks.CROP_ARTICHOKE, 4, 20);
                PowerSource.createInMap(powerObjectTable, (Block)Witchery.Blocks.CROP_SNOWBELL, 4, 20);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.EMBER_MOSS, 4, 20);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.LEAVES, 4, 50);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.LOG, 3, 100);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.SPANISH_MOSS, 3, 20);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.GLINT_WEED, 2, 20);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.CRITTER_SNARE, 2, 10);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.BLOOD_ROSE, 2, 10);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.GRASSPER, 2, 10);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.WISPY_COTTON, 3, 20);
                PowerSource.createInMap(powerObjectTable, Witchery.Blocks.INFINITY_EGG, 1000, 1);
                if (this.extraNatureIDs == null) {
                    try {
                        this.extraNatureIDs = new ArrayList();
                        for (Block block2 : Block.blockRegistry) {
                            if (!(block2 instanceof BlockFlower) && !(block2 instanceof BlockCrops) || powerObjectTable.containsKey(block2)) continue;
                            this.extraNatureIDs.add(block2);
                            Log.instance().debug(block2.getUnlocalizedName());
                        }
                    }
                    catch (Exception e) {
                        Log.instance().warning(e, "Exception occurred while creating power source list for other mod flowers and crops");
                    }
                }
                for (Block block2 : this.extraNatureIDs) {
                    PowerSource.createInMap(powerObjectTable, block2, 2, 4);
                }
                for (int y = this.yCoord - 14; y <= this.yCoord + 14; ++y) {
                    for (int z = this.zCoord + 14; z >= this.zCoord - 14; --z) {
                        for (int x = this.xCoord - 14; x <= this.xCoord + 14; ++x) {
                            Block block3 = this.worldObj.getBlock(x, y, z);
                            PowerSource source = powerObjectTable.get(block3);
                            if (source == null) continue;
                            ++source.count;
                        }
                    }
                }
                float newMax = 0.0f;
                for (PowerSource source : powerObjectTable.values()) {
                    newMax += (float)source.getPower();
                }
                if (newMax != this.maxPower) {
                    this.maxPower = newMax;
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }

        private void updateArtefacts() {
            ArrayList<Coord> visited = new ArrayList<Coord>();
            ArrayList<Coord> toVisit = new ArrayList<Coord>();
            toVisit.add(new Coord(this.xCoord, this.yCoord, this.zCoord));
            boolean headfound = false;
            boolean candlefound = false;
            boolean cupfound = false;
            boolean knifeFound = false;
            boolean wandFound = false;
            boolean pentacleFound = false;
            boolean infinityFound = false;
            int newPowerScale = 1;
            int newRechargeScale = 1;
            int newRangeScale = 1;
            int newEnhancementLevel = 0;
            while (toVisit.size() > 0) {
                Coord coord = (Coord)toVisit.get(0);
                toVisit.remove(0);
                for (Coord newCoord : new Coord[]{coord.north(), coord.south(), coord.east(), coord.west()}) {
                    if (newCoord.getBlock(this.worldObj) != Witchery.Blocks.ALTAR || visited.contains(newCoord) || toVisit.contains(newCoord)) continue;
                    toVisit.add(newCoord);
                }
                visited.add(coord);
                boolean offsetY = true;
                Block block = coord.getBlock(this.worldObj, 0, 1, 0);
                if (!headfound && block == Blocks.skull) {
                    TileEntity tile = coord.getBlockTileEntity(this.worldObj, 0, 1, 0);
                    if (tile == null || !(tile instanceof TileEntitySkull)) continue;
                    TileEntitySkull skullTileEntity = (TileEntitySkull)tile;
                    switch (skullTileEntity.func_145904_a()) {
                        case 0: {
                            ++newRechargeScale;
                            ++newPowerScale;
                            headfound = true;
                            break;
                        }
                        case 1: {
                            newRechargeScale += 2;
                            newPowerScale += 2;
                            headfound = true;
                            break;
                        }
                        case 3: {
                            newRechargeScale += 3;
                            newPowerScale += 3;
                            headfound = true;
                            break;
                        }
                    }
                    continue;
                }
                if (!candlefound && block == Witchery.Blocks.CANDELABRA) {
                    candlefound = true;
                    newRechargeScale += 2;
                    continue;
                }
                if (!candlefound && block == Blocks.torch) {
                    candlefound = true;
                    ++newRechargeScale;
                    continue;
                }
                if (block == Witchery.Blocks.PLACED_ITEMSTACK) {
                    BlockPlacedItem.TileEntityPlacedItem placeItem;
                    TileEntity tile = coord.getBlockTileEntity(this.worldObj, 0, 1, 0);
                    if (tile == null || !(tile instanceof BlockPlacedItem.TileEntityPlacedItem) || (placeItem = (BlockPlacedItem.TileEntityPlacedItem)tile).getStack() == null) continue;
                    if (!knifeFound && placeItem.getStack().getItem() == Witchery.Items.ARTHANA) {
                        knifeFound = true;
                        ++newRangeScale;
                        continue;
                    }
                    if (!wandFound && placeItem.getStack().getItem() == Witchery.Items.MYSTIC_BRANCH) {
                        wandFound = true;
                        ++newEnhancementLevel;
                        continue;
                    }
                    if (pentacleFound || !Witchery.Items.GENERIC.itemKobolditePentacle.isMatch(placeItem.getStack())) continue;
                    pentacleFound = true;
                    continue;
                }
                if (!cupfound && block == Witchery.Blocks.CHALICE) {
                    cupfound = true;
                    TileEntity tile = coord.getBlockTileEntity(this.worldObj, 0, 1, 0);
                    if (tile == null || !(tile instanceof BlockChalice.TileEntityChalice)) continue;
                    BlockChalice.TileEntityChalice tileEntityChalice = (BlockChalice.TileEntityChalice)tile;
                    newPowerScale += tileEntityChalice != null && tileEntityChalice.isFilled() ? 2 : 1;
                    continue;
                }
                if (infinityFound || block != Witchery.Blocks.INFINITY_EGG) continue;
                infinityFound = true;
            }
            if (pentacleFound) {
                newRechargeScale *= 2;
            }
            if (infinityFound) {
                newRechargeScale *= 10;
                newPowerScale *= 10;
            }
            if (newRechargeScale != this.rechargeScale || newPowerScale != this.powerScale || newRangeScale != this.rangeScale || newEnhancementLevel != this.enhancementLevel) {
                this.rechargeScale = newRechargeScale;
                this.powerScale = newPowerScale;
                this.rangeScale = newRangeScale;
                this.enhancementLevel = newEnhancementLevel;
                if (!this.worldObj.isRemote) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }

        static class PowerSource {
            private final Block block;
            private final int factor;
            private final int limit;
            private int count;

            public PowerSource(Block block, int factor, int limit) {
                this.block = block;
                this.factor = factor;
                this.limit = limit;
                this.count = 0;
            }

            public int getPower() {
                return Math.min(this.count, this.limit) * this.factor;
            }

            static void createInMap(Map<Block, PowerSource> map, Block block, int factor, int limit) {
                PowerSource source = new PowerSource(block, factor, limit);
                map.put(block, source);
            }
        }
    }
}

