/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.item.ItemAlluringSkull;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlluringSkull
extends BlockBaseContainer {
    private static final int UPDATE_FREQUENCY = 100;

    public BlockAlluringSkull() {
        super(Material.circuits, TileEntityAlluringSkull.class, ItemAlluringSkull.class);
        this.setLightLevel(0.5f);
        this.setStepSound(soundTypeStone);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean onBlockActivated(World world, int posX, int posY, int posZ, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.isRemote) {
            TileEntityAlluringSkull tileEntity = (TileEntityAlluringSkull)world.getTileEntity(posX, posY, posZ);
            int type = tileEntity.getSkullType();
            ItemStack itemstack = player.getHeldItem();
            if (itemstack != null && Witchery.Items.GENERIC.itemNecroStone.isMatch(itemstack)) {
                if (type == 0) {
                    ParticleEffect.FLAME.send(SoundEffect.MOB_HORSE_SKELETON_DEATH, world, 0.5 + (double)posX, 0.3 + (double)posY, 0.5 + (double)posZ, 0.5, 0.5, 16);
                    tileEntity.setSkullType(type == 0 ? 1 : 0);
                } else {
                    ParticleEffect.EXPLODE.send(SoundEffect.MOB_HORSE_SKELETON_HIT, world, 0.5 + (double)posX, 0.3 + (double)posY, 0.5 + (double)posZ, 0.5, 0.5, 16);
                    world.setBlockToAir(posX, posY, posZ);
                    world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)posX, 0.8 + (double)posY, 0.5 + (double)posZ, new ItemStack((Block)this)));
                }
                return true;
            }
        }
        return super.onBlockActivated(world, posX, posY, posZ, player, par6, par7, par8, par9);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 7;
        switch (l) {
            default: {
                this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.25f, 0.25f, 0.5f, 0.75f, 0.75f, 1.0f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.5f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.5f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.75f);
            }
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 2.5)) & 3;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this);
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        TileEntity tileentity = par1World.getTileEntity(par2, par3, par4);
        return tileentity != null && tileentity instanceof TileEntityAlluringSkull ? ((TileEntityAlluringSkull)tileentity).getSkullType() : super.getDamageValue(par1World, par2, par3, par4);
    }

    public int damageDropped(int par1) {
        return par1;
    }

    public void onBlockHarvested(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.capabilities.isCreativeMode) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, par5 |= 8, 4);
        }
        this.dropBlockAsItem(par1World, par2, par3, par4, par5, 0);
        super.onBlockHarvested(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((metadata & 8) == 0) {
            ItemStack itemstack = new ItemStack((Block)this);
            TileEntityAlluringSkull tileentityskull = (TileEntityAlluringSkull)world.getTileEntity(x, y, z);
            if (tileentityskull == null) {
                return drops;
            }
            drops.add(itemstack);
        }
        return drops;
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)this);
    }

    private boolean func_82528_d(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.getBlock(par2, par3, par4) != this) {
            return false;
        }
        TileEntity tileentity = par1World.getTileEntity(par2, par3, par4);
        return tileentity != null && tileentity instanceof TileEntityAlluringSkull ? ((TileEntityAlluringSkull)tileentity).getSkullType() == par5 : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return Blocks.soul_sand.getBlockTextureFromSide(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemIconName() {
        return this.getTextureName();
    }

    public static void allure(World world, double posX, double posY, double posZ, int quad) {
        try {
            float r = 64.0f;
            float dy = 10.0f;
            AxisAlignedBB bounds = null;
            switch (quad) {
                case 0: {
                    bounds = AxisAlignedBB.getBoundingBox((double)posX, (double)(posY - 10.0), (double)(posZ - 64.0), (double)(posX + 64.0), (double)posY, (double)posZ);
                    break;
                }
                case 1: {
                    bounds = AxisAlignedBB.getBoundingBox((double)(posX - 64.0), (double)(posY - 10.0), (double)(posZ - 64.0), (double)posX, (double)posY, (double)posZ);
                    break;
                }
                case 2: {
                    bounds = AxisAlignedBB.getBoundingBox((double)posX, (double)(posY - 10.0), (double)posZ, (double)(posX + 64.0), (double)posY, (double)(posZ + 64.0));
                    break;
                }
                case 3: {
                    bounds = AxisAlignedBB.getBoundingBox((double)(posX - 64.0), (double)(posY - 10.0), (double)posZ, (double)posX, (double)posY, (double)(posZ + 64.0));
                    break;
                }
                case 4: {
                    bounds = AxisAlignedBB.getBoundingBox((double)(posX - 64.0), (double)(posY + 1.0), (double)(posZ - 64.0), (double)posX, (double)(posY + 10.0), (double)posZ);
                    break;
                }
                case 5: {
                    bounds = AxisAlignedBB.getBoundingBox((double)posX, (double)(posY + 1.0), (double)posZ, (double)(posX + 64.0), (double)(posY + 10.0), (double)(posZ + 64.0));
                    break;
                }
                case 6: {
                    bounds = AxisAlignedBB.getBoundingBox((double)(posX - 64.0), (double)(posY + 1.0), (double)posZ, (double)posX, (double)(posY + 10.0), (double)(posZ + 64.0));
                    break;
                }
                default: {
                    bounds = AxisAlignedBB.getBoundingBox((double)posX, (double)(posY + 1.0), (double)(posZ - 64.0), (double)(posX + 64.0), (double)(posY + 10.0), (double)posZ);
                }
            }
            for (Object obj : world.getEntitiesWithinAABB(EntityCreature.class, bounds)) {
                int z;
                int y;
                int x;
                PathEntity path;
                EntityCreature creature = (EntityCreature)obj;
                if (creature.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD || creature.getNavigator().tryMoveToXYZ(posX, posY, posZ, 1.0) || (path = world.getEntityPathToXYZ((Entity)creature, x = MathHelper.floor_double((double)posX), y = MathHelper.floor_double((double)posY), z = MathHelper.floor_double((double)posZ), 10.0f, true, false, false, true)) == null) continue;
                creature.setPathToEntity(path);
            }
        }
        catch (Exception e) {
            Log.instance().debug(String.format("Exception occurred alluring with a skull! %s", e.toString()));
        }
    }

    public static class TileEntityAlluringSkull
    extends TileEntityBase {
        private int skullType;
        private int skullRotation;
        private int quad = 0;

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && this.skullType == 1 && this.ticks % 100L == 0L) {
                if (++this.quad >= 8) {
                    this.quad = 0;
                }
                BlockAlluringSkull.allure(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.quad);
            }
        }

        public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
            super.writeToNBT(par1NBTTagCompound);
            par1NBTTagCompound.setByte("SkullType", (byte)(this.skullType & 0xFF));
            par1NBTTagCompound.setByte("Rot", (byte)(this.skullRotation & 0xFF));
        }

        public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
            super.readFromNBT(par1NBTTagCompound);
            this.skullType = par1NBTTagCompound.getByte("SkullType");
            this.skullRotation = par1NBTTagCompound.getByte("Rot");
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public void setSkullType(int par1) {
            this.skullType = par1;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }

        public int getSkullType() {
            return this.skullType;
        }

        public void setSkullRotation(int par1) {
            this.skullRotation = par1;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_82119_b() {
            return this.skullRotation;
        }
    }
}

