/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTFThornBorder
extends GenLayer {
    public GenLayerTFThornBorder(long l, GenLayer genlayer) {
        super(l);
        this.parent = genlayer;
    }

    public int[] getInts(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.parent.getInts(nx, nz, nwidth, ndepth);
        int[] output = IntCache.getIntCache((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int right = input[dx + 0 + (dz + 1) * nwidth];
                int left = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 0) * nwidth];
                int down = input[dx + 1 + (dz + 2) * nwidth];
                int center = input[dx + 1 + (dz + 1) * nwidth];
                int ur = input[dx + 0 + (dz + 0) * nwidth];
                int ul = input[dx + 2 + (dz + 0) * nwidth];
                int dr = input[dx + 0 + (dz + 2) * nwidth];
                int dl = input[dx + 2 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.onBorder(TFBiomeBase.highlandsCenter.biomeID, center, right, left, up, down) ? TFBiomeBase.thornlands.biomeID : (this.onBorder(TFBiomeBase.highlandsCenter.biomeID, center, ur, ul, dr, dl) ? TFBiomeBase.thornlands.biomeID : center);
            }
        }
        return output;
    }

    private boolean onBorder(int biomeID, int biomeID2, int center, int right, int left, int up, int down) {
        if (center != biomeID) {
            return false;
        }
        if (right == biomeID2) {
            return true;
        }
        if (left == biomeID2) {
            return true;
        }
        if (up == biomeID2) {
            return true;
        }
        return down == biomeID2;
    }

    private boolean onBorder(int biomeID, int center, int right, int left, int up, int down) {
        if (center == biomeID) {
            return false;
        }
        if (right == biomeID) {
            return true;
        }
        if (left == biomeID) {
            return true;
        }
        if (up == biomeID) {
            return true;
        }
        return down == biomeID;
    }
}

