/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTFStream
extends GenLayer {
    public GenLayerTFStream(long l, GenLayer genlayer) {
        super(l);
        this.parent = genlayer;
    }

    public int[] getInts(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.parent.getInts(nx, nz, nwidth, ndepth);
        int[] output = IntCache.getIntCache((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int mid = input[dx + 1 + (dz + 1) * nwidth];
                int left = input[dx + 0 + (dz + 1) * nwidth];
                int down = input[dx + 1 + (dz + 0) * nwidth];
                int right = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.shouldStream(mid, left, down, right, up) ? TFBiomeBase.stream.biomeID : -1;
            }
        }
        return output;
    }

    boolean shouldStream(int mid, int left, int down, int right, int up) {
        if (this.shouldStream(mid, left)) {
            return true;
        }
        if (this.shouldStream(mid, right)) {
            return true;
        }
        if (this.shouldStream(mid, down)) {
            return true;
        }
        return this.shouldStream(mid, up);
    }

    boolean shouldStream(int biome1, int biome2) {
        if (biome1 == biome2) {
            return false;
        }
        if (biome1 == -biome2) {
            return false;
        }
        if (biome1 == TFBiomeBase.glacier.biomeID && biome2 == TFBiomeBase.tfSnow.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.tfSnow.biomeID && biome2 == TFBiomeBase.glacier.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.deepMushrooms.biomeID && biome2 == TFBiomeBase.mushrooms.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.mushrooms.biomeID && biome2 == TFBiomeBase.deepMushrooms.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.tfSwamp.biomeID && biome2 == TFBiomeBase.fireSwamp.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.fireSwamp.biomeID && biome2 == TFBiomeBase.tfSwamp.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.highlands.biomeID && biome2 == TFBiomeBase.highlandsCenter.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.highlandsCenter.biomeID && biome2 == TFBiomeBase.highlands.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.darkForest.biomeID && biome2 == TFBiomeBase.darkForestCenter.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.darkForestCenter.biomeID && biome2 == TFBiomeBase.darkForest.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.tfLake.biomeID || biome2 == TFBiomeBase.tfLake.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.clearing.biomeID || biome2 == TFBiomeBase.oakSavanna.biomeID) {
            return false;
        }
        if (biome1 == TFBiomeBase.oakSavanna.biomeID || biome2 == TFBiomeBase.clearing.biomeID) {
            return false;
        }
        return biome1 != TFBiomeBase.thornlands.biomeID && biome2 != TFBiomeBase.thornlands.biomeID;
    }
}

