/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;

public class WorldProviderTwilightForest
extends WorldProviderSurface {
    public final String saveFolder;
    public ChunkProviderTwilightForest chunkProvider;

    public WorldProviderTwilightForest() {
        this.setDimension(TwilightForestMod.dimensionID);
        this.saveFolder = "DIM" + TwilightForestMod.dimensionID;
    }

    public float[] calcSunriseSunsetColors(float celestialAngle, float f1) {
        return null;
    }

    public Vec3 getFogColor(float f, float f1) {
        float bright = MathHelper.cos((float)1.5707965f) * 2.0f + 0.5f;
        if (bright < 0.0f) {
            bright = 0.0f;
        }
        if (bright > 1.0f) {
            bright = 1.0f;
        }
        float red = 0.7529412f;
        float green = 1.0f;
        float blue = 0.8470588f;
        return Vec3.createVectorHelper((double)(red *= bright * 0.94f + 0.06f), (double)(green *= bright * 0.94f + 0.06f), (double)(blue *= bright * 0.91f + 0.09f));
    }

    public float calculateCelestialAngle(long par1, float par3) {
        return 0.225f;
    }

    public void registerWorldChunkManager() {
        this.worldChunkMgr = new TFWorldChunkManager(this.worldObj);
        this.dimensionId = TwilightForestMod.dimensionID;
    }

    public IChunkProvider createChunkGenerator() {
        if (this.chunkProvider == null) {
            this.chunkProvider = new ChunkProviderTwilightForest(this.worldObj, this.worldObj.getSeed(), this.worldObj.getWorldInfo().isMapFeaturesEnabled());
            return this.chunkProvider;
        }
        return new ChunkProviderTwilightForest(this.worldObj, this.worldObj.getSeed(), this.worldObj.getWorldInfo().isMapFeaturesEnabled());
    }

    public ChunkProviderTwilightForest getChunkProvider() {
        return this.chunkProvider;
    }

    public boolean isSkyColored() {
        return false;
    }

    public int getAverageGroundLevel() {
        return 30;
    }

    public boolean canRespawnHere() {
        return this.worldObj.getWorldInfo().isInitialized();
    }

    public String getSaveFolder() {
        return this.saveFolder;
    }

    public String getWelcomeMessage() {
        return "Entering the Twilight Forest";
    }

    public String getDepartMessage() {
        return "Leaving the Twilight Forest";
    }

    public String getDimensionName() {
        return "Twilight Forest";
    }

    public boolean isDaytime() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        return Vec3.createVectorHelper((double)0.16796875, (double)0.1796875, (double)0.38671875);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return 1.0f;
    }

    public double getHorizon() {
        return 32.0;
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        BiomeGenBase biome = super.getBiomeGenForCoords(x, z);
        if (biome == null) {
            biome = TFBiomeBase.twilightForest;
        }
        return biome;
    }

    public long getSeed() {
        if (TwilightForestMod.twilightForestSeed == null || TwilightForestMod.twilightForestSeed.length() == 0) {
            return super.getSeed();
        }
        return TwilightForestMod.twilightForestSeed.hashCode();
    }

    public void updateWeather() {
        super.updateWeather();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new TFSkyRenderer());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.setWeatherRenderer(new TFWeatherRenderer());
        }
        return super.getWeatherRenderer();
    }

    public float getCloudHeight() {
        return 161.0f;
    }
}

