/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public class TFGenHangingLamps
extends TFGenerator {
    private static final int MAX_HANG = 8;

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (world.isAirBlock(x, y, z) && TFGenerator.surroundedByAir((IBlockAccess)world, x, y, z) && this.areLeavesAbove(world, x, y, z) && this.isClearBelow(world, x, y, z)) {
            Material above;
            world.setBlock(x, y, z, TFBlocks.fireflyJar);
            for (int cy = 1; cy < 8 && !(above = world.getBlock(x, y + cy, z).getMaterial()).isSolid() && above != Material.leaves; ++cy) {
                world.setBlock(x, y + cy, z, Blocks.fence);
            }
        }
        return false;
    }

    private boolean areLeavesAbove(World world, int x, int y, int z) {
        boolean areLeavesAbove = false;
        for (int cy = 1; cy < 8; ++cy) {
            Material above = world.getBlock(x, y + cy, z).getMaterial();
            if (!above.isSolid() && above != Material.leaves) continue;
            areLeavesAbove = true;
        }
        return areLeavesAbove;
    }

    private boolean isClearBelow(World world, int x, int y, int z) {
        boolean isClearBelow = true;
        for (int cy = 1; cy < 4; ++cy) {
            if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(y - cy), (int)z)) continue;
            isClearBelow = false;
        }
        return isClearBelow;
    }
}

