/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import twilightforest.block.TFBlocks;

public class TileEntityTFTowerBuilder
extends TileEntity {
    private static final int RANGE = 16;
    int ticksRunning = 0;
    int blockedCounter = 0;
    int ticksStopped = 0;
    public boolean makingBlocks = false;
    int blocksMade = 0;
    protected ChunkCoordinates lastBlockCoords;
    protected int nextFacing;
    protected EntityPlayer trackedPlayer;
    protected Block blockBuiltID = TFBlocks.towerTranslucent;
    protected int blockBuiltMeta = 2;

    public void startBuilding() {
        this.makingBlocks = true;
        this.blocksMade = 0;
        this.lastBlockCoords = new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.makingBlocks) {
            if (this.trackedPlayer == null) {
                this.trackedPlayer = this.findClosestValidPlayer();
            }
            this.nextFacing = this.findNextFacing();
            ++this.ticksRunning;
            if (this.ticksRunning % 10 == 0 && this.lastBlockCoords != null && this.nextFacing != -1) {
                int nextX = this.lastBlockCoords.posX + Facing.offsetsXForSide[this.nextFacing];
                int nextY = this.lastBlockCoords.posY + Facing.offsetsYForSide[this.nextFacing];
                int nextZ = this.lastBlockCoords.posZ + Facing.offsetsZForSide[this.nextFacing];
                if (this.blocksMade <= 16 && this.worldObj.isAirBlock(nextX, nextY, nextZ)) {
                    this.worldObj.setBlock(nextX, nextY, nextZ, this.blockBuiltID, this.blockBuiltMeta, 3);
                    this.worldObj.playAuxSFX(1001, nextX, nextY, nextZ, 0);
                    this.lastBlockCoords.posX = nextX;
                    this.lastBlockCoords.posY = nextY;
                    this.lastBlockCoords.posZ = nextZ;
                    this.blockedCounter = 0;
                    ++this.blocksMade;
                } else {
                    ++this.blockedCounter;
                }
            }
            if (this.blockedCounter > 0) {
                this.makingBlocks = false;
                this.trackedPlayer = null;
                this.ticksStopped = 0;
            }
        } else if (!this.worldObj.isRemote && !this.makingBlocks) {
            this.trackedPlayer = null;
            if (++this.ticksStopped == 60) {
                this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, TFBlocks.towerDevice, 8, 3);
                this.worldObj.scheduleBlockUpdate(this.xCoord, this.yCoord, this.zCoord, TFBlocks.towerDevice, 4);
            }
        }
    }

    private boolean isInBounds(int nextX, int nextY, int nextZ) {
        return nextX > this.xCoord - 16 && nextX < this.xCoord + 16 && nextY > this.yCoord - 16 && nextY < this.yCoord + 16 && nextZ > this.zCoord - 16 && nextZ < this.zCoord + 16;
    }

    private int findNextFacing() {
        if (this.trackedPlayer != null) {
            int pitch = MathHelper.floor_double((double)((double)(this.trackedPlayer.rotationPitch * 4.0f / 360.0f) + 1.5)) & 3;
            if (pitch == 0) {
                return 1;
            }
            if (pitch == 2) {
                return 0;
            }
            int direction = MathHelper.floor_double((double)((double)(this.trackedPlayer.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
            switch (direction) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 5;
                }
            }
        }
        return -1;
    }

    private EntityPlayer findClosestValidPlayer() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0);
    }
}

