/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMiniGhast;

public class TileEntityTFGhastTrapInactive
extends TileEntity {
    int counter;
    Random rand = new Random();
    ArrayList<EntityTFMiniGhast> dyingGhasts = new ArrayList();

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(10.0, 16.0, 10.0);
        List nearbyGhasts = this.worldObj.getEntitiesWithinAABB(EntityTFMiniGhast.class, aabb);
        for (EntityTFMiniGhast ghast : nearbyGhasts) {
            if (ghast.deathTime <= 0) continue;
            this.makeParticlesTo((Entity)ghast);
            if (this.dyingGhasts.contains((Object)ghast)) continue;
            this.dyingGhasts.add(ghast);
        }
        int chargeLevel = Math.min(3, this.dyingGhasts.size());
        ++this.counter;
        if (this.worldObj.isRemote) {
            if (this.counter % 20 == 0 && nearbyGhasts.size() > 0) {
                EntityTFMiniGhast highlight = (EntityTFMiniGhast)((Object)nearbyGhasts.get(this.rand.nextInt(nearbyGhasts.size())));
                this.makeParticlesTo((Entity)highlight);
            }
            if (chargeLevel >= 1 && this.counter % 10 == 0) {
                ((BlockTFTowerDevice)TFBlocks.towerDevice).sparkle(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.rand);
                this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 1.5, (double)this.zCoord + 0.5, "note.harp", 1.0f, 1.0f, false);
            }
            if (chargeLevel >= 2) {
                this.worldObj.spawnParticle("smoke", (double)this.xCoord + 0.1 + (double)this.rand.nextFloat() * 0.8, (double)this.yCoord + 1.05, (double)this.zCoord + 0.1 + (double)this.rand.nextFloat() * 0.8, (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.05, 0.0, (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.05);
                if (this.counter % 10 == 0) {
                    this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 1.5, (double)this.zCoord + 0.5, "note.harp", 1.2f, 0.8f, false);
                }
            }
            if (chargeLevel >= 3) {
                this.worldObj.spawnParticle("largesmoke", (double)this.xCoord + 0.1 + (double)this.rand.nextFloat() * 0.8, (double)this.yCoord + 1.05, (double)this.zCoord + 0.1 + (double)this.rand.nextFloat() * 0.8, (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.05, 0.05, (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.05);
                ((BlockTFTowerDevice)TFBlocks.towerDevice).sparkle(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.rand);
                if (this.counter % 5 == 0) {
                    this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 1.5, (double)this.zCoord + 0.5, "note.harp", 1.5f, 2.0f, false);
                }
            }
        }
    }

    private void makeParticlesTo(Entity highlight) {
        double sx = (double)this.xCoord + 0.5;
        double sy = (double)this.yCoord + 1.0;
        double sz = (double)this.zCoord + 0.5;
        double dx = sx - highlight.posX;
        double dy = sy - highlight.posY - (double)highlight.getEyeHeight();
        double dz = sz - highlight.posZ;
        for (int i = 0; i < 5; ++i) {
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "ghasttrap", sx, sy, sz, -dx, -dy, -dz);
        }
    }

    public boolean isCharged() {
        return this.dyingGhasts.size() >= 3;
    }
}

