/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.trollcave;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.trollcave.ComponentTFTrollCaveMain;
import twilightforest.world.TFGenBigMushgloom;
import twilightforest.world.TFGenMyceliumBlob;

public class ComponentTFTrollCaveGarden
extends ComponentTFTrollCaveMain {
    TFGenMyceliumBlob myceliumBlobGen = new TFGenMyceliumBlob(5);
    TFGenMyceliumBlob dirtGen = new TFGenMyceliumBlob(Blocks.dirt, 5);
    WorldGenBigMushroom bigMushroomGen = new WorldGenBigMushroom();
    TFGenBigMushgloom bigMushgloomGen = new TFGenBigMushgloom();

    public ComponentTFTrollCaveGarden() {
    }

    public ComponentTFTrollCaveGarden(int index, int x, int y, int z, int caveSize, int caveHeight, int direction) {
        super(index);
        this.size = caveSize;
        this.height = caveHeight;
        this.setCoordBaseMode(direction);
        this.boundingBox = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    @Override
    public void buildComponent(StructureComponent parent, List list, Random rand) {
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        ChunkCoordinates dest;
        int i;
        if (this.isBoundingBoxOutOfHighlands(world, sbb)) {
            return false;
        }
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        Random decoRNG = new Random(world.getSeed() + (long)(this.boundingBox.minX * 321534781) ^ (long)(this.boundingBox.minZ * 756839));
        this.makeTreasureCrate(world, rand, sbb);
        for (i = 0; i < 24; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, this.dirtGen, decoRNG, dest.posX, 1, dest.posZ, sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, this.myceliumBlobGen, decoRNG, dest.posX, 1, dest.posZ, sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, uberousGen, decoRNG, dest.posX, 1, dest.posZ, sbb);
            this.generateAtSurface(world, uberousGen, decoRNG, dest.posX, 60, dest.posZ, sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, this.bigMushgloomGen, decoRNG, dest.posX, 1, dest.posZ, sbb);
        }
        for (i = 0; i < 64; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, (WorldGenerator)this.bigMushroomGen, decoRNG, dest.posX, 1, dest.posZ, sbb);
        }
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, decoRNG, Blocks.stone, 0.7f, true, dest.posX, 3, dest.posZ, sbb);
        }
        return true;
    }

    protected void generate(World world, WorldGenerator generator, Random rand, int x, int y, int z, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffset(x, z);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffset(x, z))) {
            generator.generate(world, rand, dx, dy, dz);
        }
    }
}

