/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.trollcave;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFArmoredGiant;
import twilightforest.entity.EntityTFGiantMiner;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.trollcave.ComponentTFCloudTree;

public class ComponentTFCloudCastle
extends StructureTFComponent {
    private boolean minerPlaced = false;
    private boolean warriorPlaced = false;

    public ComponentTFCloudCastle() {
    }

    public ComponentTFCloudCastle(int index, int x, int y, int z) {
        super(index);
        this.setCoordBaseMode(0);
        x = x >> 2 << 2;
        y = y >> 2 << 2;
        z = z >> 2 << 2;
        this.spawnListIndex = 1;
        this.boundingBox = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -8, 0, -8, 16, 16, 16, 0);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("minerPlaced", this.minerPlaced);
        par1NBTTagCompound.setBoolean("warriorPlaced", this.warriorPlaced);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.minerPlaced = par1NBTTagCompound.getBoolean("minerPlaced");
        this.warriorPlaced = par1NBTTagCompound.getBoolean("warriorPlaced");
    }

    public void buildComponent(StructureComponent parent, List list, Random rand) {
        boolean plus = rand.nextBoolean();
        int offset = rand.nextInt(5) - rand.nextInt(5);
        ComponentTFCloudTree treeX = new ComponentTFCloudTree(this.getComponentType() + 1, this.boundingBox.minX + (plus ? 16 : -16), 168, this.boundingBox.minZ - 8 + offset * 4);
        list.add(treeX);
        treeX.buildComponent(this, list, rand);
        plus = rand.nextBoolean();
        offset = rand.nextInt(5) - rand.nextInt(5);
        ComponentTFCloudTree treeZ = new ComponentTFCloudTree(this.getComponentType() + 1, this.boundingBox.minX - 8 + offset * 4, 168, this.boundingBox.minZ + (plus ? 16 : -16));
        list.add(treeZ);
        treeZ.buildComponent(this, list, rand);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        int bz;
        int by;
        int bx;
        this.fillWithMetadataBlocks(world, sbb, 0, -4, 0, 15, -1, 15, TFBlocks.fluffyCloud, 0, TFBlocks.fluffyCloud, 0, false);
        this.fillWithMetadataBlocks(world, sbb, 0, 0, 0, 15, 11, 15, TFBlocks.giantCobble, 0, TFBlocks.giantCobble, 0, false);
        this.fillWithMetadataBlocks(world, sbb, 0, 12, 0, 15, 15, 15, TFBlocks.giantLog, 0, TFBlocks.giantLog, 0, false);
        this.fillWithAir(world, sbb, 4, 0, 4, 11, 11, 11);
        this.fillWithAir(world, sbb, 0, 0, 4, 4, 7, 7);
        if (!this.minerPlaced && sbb.isVecInside(bx = this.getXWithOffset(6, 6), by = this.getYWithOffset(0), bz = this.getZWithOffset(6, 6))) {
            this.minerPlaced = true;
            EntityTFGiantMiner miner = new EntityTFGiantMiner(world);
            miner.setPosition(bx, by, bz);
            miner.makeNonDespawning();
            world.spawnEntityInWorld((Entity)miner);
        }
        if (!this.warriorPlaced && sbb.isVecInside(bx = this.getXWithOffset(9, 9), by = this.getYWithOffset(0), bz = this.getZWithOffset(9, 9))) {
            this.warriorPlaced = true;
            EntityTFArmoredGiant warrior = new EntityTFArmoredGiant(world);
            warrior.setPosition(bx, by, bz);
            warrior.makeNonDespawning();
            world.spawnEntityInWorld((Entity)warrior);
        }
        return true;
    }
}

