/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.stronghold.ComponentTFStrongholdAccessChamber;
import twilightforest.structures.stronghold.ComponentTFStrongholdBossRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdDeadEnd;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallStairs;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureRoom;
import twilightforest.structures.stronghold.StructureTFDecoratorStronghold;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;
import twilightforest.structures.stronghold.TFStrongholdPieces;

public class ComponentTFStrongholdEntrance
extends StructureTFStrongholdComponent {
    public TFStrongholdPieces lowerPieces;

    public ComponentTFStrongholdEntrance() {
    }

    public ComponentTFStrongholdEntrance(World world, Random rand, int i, int x, int y, int z) {
        super(i, 0, x, y - 10, z);
        this.deco = new StructureTFDecoratorStronghold();
        this.lowerPieces = new TFStrongholdPieces();
    }

    @Override
    public void buildComponent(StructureComponent parent, List list, Random random) {
        super.buildComponent(parent, list, random);
        this.lowerPieces.prepareStructurePieces();
        this.addNewComponent(parent, list, random, 0, 4, 1, 18);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, 1, -1, 1, 13);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, 2, 13, 1, -1);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, 3, 18, 1, 4);
        if (!this.listContainsBossRoom(list)) {
            System.out.println("Did not find boss room from exit 3 - EPIC FAIL");
        }
        List pieceList = list;
        StructureBoundingBox shieldBox = new StructureBoundingBox(this.boundingBox);
        int tStairs = 0;
        int tCorridors = 0;
        int deadEnd = 0;
        int tRooms = 0;
        int bossRooms = 0;
        for (StructureTFStrongholdComponent component : pieceList) {
            shieldBox.expandTo(component.getBoundingBox());
            if (component instanceof ComponentTFStrongholdSmallStairs && ((ComponentTFStrongholdSmallStairs)component).hasTreasure) {
                ++tStairs;
            }
            if (component instanceof ComponentTFStrongholdTreasureCorridor) {
                ++tCorridors;
            }
            if (component instanceof ComponentTFStrongholdDeadEnd) {
                ++deadEnd;
            }
            if (component instanceof ComponentTFStrongholdTreasureRoom) {
                ++tRooms;
            }
            if (!(component instanceof ComponentTFStrongholdBossRoom)) continue;
            ++bossRooms;
        }
        ComponentTFStrongholdAccessChamber accessChamber = new ComponentTFStrongholdAccessChamber(2, this.getCoordBaseMode(), this.boundingBox.minX + 8, this.boundingBox.minY + 7, this.boundingBox.minZ + 4);
        list.add(accessChamber);
        ((StructureTFStrongholdComponent)accessChamber).buildComponent(this, list, random);
    }

    private boolean listContainsBossRoom(List list) {
        for (StructureTFStrongholdComponent component : list) {
            if (!(component instanceof ComponentTFStrongholdBossRoom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StructureBoundingBox generateBoundingBox(int facing, int x, int y, int z) {
        return StructureBoundingBox.getComponentToAddBoundingBox((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)18, (int)7, (int)18, (int)facing);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 6, 17, rand, this.deco.randomBlocks);
        int var8 = this.getXWithOffset(0, 0);
        int var9 = this.getYWithOffset(0);
        int var10 = this.getZWithOffset(0, 0);
        this.placeCornerStatue(world, 5, 1, 5, 0, sbb);
        this.placeCornerStatue(world, 5, 1, 12, 1, sbb);
        this.placeCornerStatue(world, 12, 1, 5, 2, sbb);
        this.placeCornerStatue(world, 12, 1, 12, 3, sbb);
        this.placeWallStatue(world, 9, 1, 16, 0, sbb);
        this.placeWallStatue(world, 1, 1, 9, 1, sbb);
        this.placeWallStatue(world, 8, 1, 1, 2, sbb);
        this.placeWallStatue(world, 16, 1, 8, 3, sbb);
        this.placeDoors(world, rand, sbb);
        return true;
    }
}

