/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.icetower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.icetower.ComponentTFIceTowerBridge;
import twilightforest.structures.icetower.ComponentTFIceTowerEntrance;
import twilightforest.structures.icetower.ComponentTFIceTowerWing;
import twilightforest.structures.icetower.StructureDecoratorIceTower;

public class ComponentTFIceTowerMain
extends ComponentTFIceTowerWing {
    public boolean hasBossWing = false;

    public ComponentTFIceTowerMain() {
    }

    public ComponentTFIceTowerMain(World world, Random rand, int index, int x, int y, int z) {
        this(world, rand, index, x + 11, y + 40, z + 11, 2);
    }

    public ComponentTFIceTowerMain(World world, Random rand, int index, int x, int y, int z, int rotation) {
        super(index, x, y, z, 11, 31 + rand.nextInt(3) * 10, rotation);
        if (this.deco == null) {
            this.deco = new StructureDecoratorIceTower();
        }
    }

    protected ComponentTFIceTowerMain(int i, int x, int y, int z, int pSize, int pHeight, int direction) {
        super(i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("hasBossWing", this.hasBossWing);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasBossWing = par1NBTTagCompound.getBoolean("hasBossWing");
    }

    @Override
    public void buildComponent(StructureComponent parent, List list, Random rand) {
        int length;
        super.buildComponent(parent, list, rand);
        StructureBoundingBox towerBB = StructureBoundingBox.getNewBoundingBox();
        for (StructureComponent structurecomponent : list) {
            towerBB.expandTo(structurecomponent.getBoundingBox());
        }
        ChunkCoordinates myDoor = (ChunkCoordinates)this.openings.get(0);
        ChunkCoordinates entranceDoor = new ChunkCoordinates(myDoor);
        if (myDoor.posX == 0 && (length = this.getBoundingBox().minX - towerBB.minX) >= 0) {
            entranceDoor.posX -= length;
            this.makeEntranceBridge(list, rand, this.getComponentType() + 1, myDoor.posX, myDoor.posY, myDoor.posZ, length, 2);
        }
        if (myDoor.posX == this.size - 1) {
            entranceDoor.posX += towerBB.maxX - this.getBoundingBox().maxX;
        }
        if (myDoor.posZ == 0) {
            entranceDoor.posZ += towerBB.minZ - this.getBoundingBox().minZ;
        }
        if (myDoor.posX == this.size - 1) {
            entranceDoor.posZ += towerBB.maxZ - this.getBoundingBox().maxZ;
        }
        this.makeEntranceTower(list, rand, this.getComponentType() + 1, entranceDoor.posX, entranceDoor.posY, entranceDoor.posZ, 11, 11, this.getCoordBaseMode());
    }

    private void makeEntranceBridge(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int length, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        ChunkCoordinates dest = this.offsetTowerCCoords(x, y, z, 5, direction);
        ComponentTFIceTowerBridge bridge = new ComponentTFIceTowerBridge(index, dest.posX, dest.posY, dest.posZ, length, direction);
        list.add(bridge);
        bridge.buildComponent(list.get(0), list, rand);
    }

    public boolean makeEntranceTower(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        ComponentTFIceTowerEntrance entrance = new ComponentTFIceTowerEntrance(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(entrance);
        ((ComponentTFIceTowerWing)entrance).buildComponent(list.get(0), list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }
}

