/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class DestroyArea {
    StructureBoundingBox destroyBox;

    public DestroyArea(StructureBoundingBox tower, Random rand, int y) {
        int bx = tower.minX - 2 + rand.nextInt(tower.getXSize());
        int bz = tower.minZ - 2 + rand.nextInt(tower.getZSize());
        this.destroyBox = new StructureBoundingBox(bx, y - 10, bz, bx + 4, y, bz + 4);
    }

    public boolean isEntirelyAbove(int y) {
        return this.destroyBox.minY > y;
    }

    public boolean isVecInside(int x, int y, int z) {
        return this.destroyBox.isVecInside(x, y, z);
    }

    public static DestroyArea createNonIntersecting(StructureBoundingBox tower, Random rand, int y, ArrayList<DestroyArea> otherAreas) {
        int attempts = 100;
        DestroyArea area = null;
        for (int i = 0; i < attempts && area == null; ++i) {
            DestroyArea testArea = new DestroyArea(tower, rand, y);
            if (otherAreas.size() == 0) {
                area = testArea;
                continue;
            }
            for (DestroyArea otherArea : otherAreas) {
                if (otherArea != null && testArea.intersectsWith(otherArea)) continue;
                area = testArea;
            }
        }
        return area;
    }

    private boolean intersectsWith(DestroyArea otherArea) {
        return this.destroyBox.intersectsWith(otherArea.destroyBox.minX - 1, otherArea.destroyBox.minZ - 1, otherArea.destroyBox.maxX + 1, otherArea.destroyBox.maxX + 1);
    }
}

