/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBridge;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleEntranceBottomTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleEntranceSideTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMazeTower13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof13Peaked;

public class ComponentTFFinalCastleEntranceTower
extends ComponentTFFinalCastleMazeTower13 {
    public ComponentTFFinalCastleEntranceTower() {
    }

    public ComponentTFFinalCastleEntranceTower(Random rand, int i, int x, int y, int z, int direction) {
        super(rand, i, x, y, z, 3, 2, 0, direction);
    }

    @Override
    public void buildComponent(StructureComponent parent, List list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        ComponentTFFinalCastleFoundation13 foundation = new ComponentTFFinalCastleFoundation13(rand, 4, this);
        list.add(foundation);
        foundation.buildComponent(this, list, rand);
        ComponentTFFinalCastleRoof13Peaked roof = new ComponentTFFinalCastleRoof13Peaked(rand, 4, this);
        list.add(roof);
        roof.buildComponent(this, list, rand);
        int missingFloors = (this.boundingBox.minY - 127) / 8;
        int bottomFloors = missingFloors / 2;
        int middleFloors = missingFloors - bottomFloors;
        int direction = 1;
        int howFar = 20;
        if (this.buildSideTower(list, rand, middleFloors + 1, direction, howFar) || this.buildSideTower(list, rand, middleFloors + 1, direction = 3, howFar) || !this.buildSideTower(list, rand, middleFloors + 1, direction = 0, howFar)) {
            // empty if block
        }
        int brDirection = (direction + this.coordBaseMode) % 4;
        ComponentTFFinalCastleEntranceBottomTower eTower = new ComponentTFFinalCastleEntranceBottomTower(rand, this.getComponentType() + 1, this.boundingBox.minX + 6, this.boundingBox.minY - middleFloors * 8, this.boundingBox.minZ + 6, bottomFloors + 1, bottomFloors, (brDirection + 2) % 4);
        list.add(eTower);
        eTower.buildComponent(this, list, rand);
        ChunkCoordinates opening = this.getValidOpeningCC(rand, direction);
        opening.posY -= middleFloors * 8;
        ChunkCoordinates bc = this.offsetTowerCCoords(opening.posX, opening.posY, opening.posZ, 1, brDirection);
        ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.getComponentType() + 1, bc.posX, bc.posY, bc.posZ, howFar - 7, brDirection);
        list.add(bridge);
        bridge.buildComponent(this, list, rand);
    }

    private boolean buildSideTower(List list, Random rand, int middleFloors, int direction, int howFar) {
        ChunkCoordinates opening = this.getValidOpeningCC(rand, direction);
        direction += this.coordBaseMode;
        ChunkCoordinates tc = this.offsetTowerCCoords(opening.posX, opening.posY, opening.posZ, howFar, direction %= 4);
        ComponentTFFinalCastleEntranceSideTower eTower = new ComponentTFFinalCastleEntranceSideTower(rand, this.getComponentType() + 1, tc.posX, tc.posY, tc.posZ, middleFloors, middleFloors - 1, direction);
        StructureBoundingBox largerBB = new StructureBoundingBox(eTower.getBoundingBox());
        largerBB.minX -= 6;
        largerBB.minZ -= 6;
        largerBB.maxX += 6;
        largerBB.maxZ += 6;
        StructureComponent intersect = StructureComponent.findIntersecting((List)list, (StructureBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.buildComponent(this, list, rand);
            ChunkCoordinates bc = this.offsetTowerCCoords(opening.posX, opening.posY, opening.posZ, 1, direction);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.getComponentType() + 1, bc.posX, bc.posY, bc.posZ, howFar - 7, direction);
            list.add(bridge);
            bridge.buildComponent(this, list, rand);
            this.addOpening(opening.posX, opening.posY + 1, opening.posZ, direction);
            return true;
        }
        System.out.println("side entrance tower blocked");
        return false;
    }

    @Override
    public ChunkCoordinates getValidOpeningCC(Random rand, int direction) {
        if (direction == 0 || direction == 2) {
            int rx = direction == 0 ? 12 : 0;
            int rz = 6;
            int ry = 0;
            return new ChunkCoordinates(rx, ry, rz);
        }
        if (direction == 1 || direction == 3) {
            int rx = 6;
            int rz = direction == 1 ? 12 : 0;
            int ry = 0;
            return new ChunkCoordinates(rx, ry, rz);
        }
        return new ChunkCoordinates(0, 0, 0);
    }
}

