/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFHedgeMaze;
import twilightforest.structures.ComponentTFHillMaze;
import twilightforest.structures.ComponentTFHollowHill;
import twilightforest.structures.ComponentTFHydraLair;
import twilightforest.structures.ComponentTFNagaCourtyard;
import twilightforest.structures.ComponentTFQuestGrove;
import twilightforest.structures.ComponentTFYetiCave;
import twilightforest.structures.darktower.ComponentTFDarkTowerMain;
import twilightforest.structures.darktower.TFDarkTowerPieces;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMain;
import twilightforest.structures.finalcastle.TFFinalCastlePieces;
import twilightforest.structures.hollowtree.StructureTFHollowTreeStart;
import twilightforest.structures.hollowtree.TFHollowTreePieces;
import twilightforest.structures.icetower.ComponentTFIceTowerMain;
import twilightforest.structures.icetower.TFIceTowerPieces;
import twilightforest.structures.lichtower.ComponentTFTowerMain;
import twilightforest.structures.lichtower.TFLichTowerPieces;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRuins;
import twilightforest.structures.minotaurmaze.TFMinotaurMazePieces;
import twilightforest.structures.mushroomtower.ComponentTFMushroomTowerMain;
import twilightforest.structures.mushroomtower.TFMushroomTowerPieces;
import twilightforest.structures.stronghold.ComponentTFStrongholdEntrance;
import twilightforest.structures.stronghold.TFStrongholdPieces;
import twilightforest.structures.trollcave.ComponentTFTrollCaveMain;
import twilightforest.structures.trollcave.TFTrollCavePieces;
import twilightforest.world.TFWorld;
import twilightforest.world.TFWorldChunkManager;

public class StructureTFMajorFeatureStart
extends StructureStart {
    public static int NUM_LOCKS = 4;
    public TFFeature feature;
    public boolean isConquered;
    public byte[] lockBytes = new byte[NUM_LOCKS];

    public StructureTFMajorFeatureStart() {
    }

    public StructureTFMajorFeatureStart(World world, Random rand, int chunkX, int chunkZ) {
        StructureStrongholdPieces.prepareStructurePieces();
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        int y = TFWorld.SEALEVEL + 1;
        this.feature = TFFeature.getFeatureDirectlyAt(chunkX, chunkZ, world);
        this.isConquered = false;
        StructureComponent firstComponent = this.makeFirstComponent(world, rand, this.feature, x, y, z);
        if (firstComponent != null) {
            this.components.add(firstComponent);
            firstComponent.buildComponent(firstComponent, (List)this.components, rand);
        }
        this.updateBoundingBox();
        if (firstComponent instanceof StructureStrongholdPieces.Stairs2) {
            List var6 = ((StructureStrongholdPieces.Stairs2)firstComponent).field_75026_c;
            while (!var6.isEmpty()) {
                int var7 = rand.nextInt(var6.size());
                StructureComponent var8 = (StructureComponent)var6.remove(var7);
                var8.buildComponent(firstComponent, (List)this.components, rand);
            }
            this.updateBoundingBox();
            int offY = -33;
            this.boundingBox.offset(0, offY, 0);
            for (StructureComponent com : this.getComponents()) {
                com.getBoundingBox().offset(0, offY, 0);
            }
        }
        if (firstComponent instanceof ComponentTFTowerMain || firstComponent instanceof ComponentTFDarkTowerMain) {
            this.moveToAvgGroundLevel(world, x, z);
        }
    }

    public StructureComponent makeFirstComponent(World world, Random rand, TFFeature feature, int x, int y, int z) {
        if (feature == TFFeature.nagaCourtyard) {
            return new ComponentTFNagaCourtyard(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hedgeMaze) {
            return new ComponentTFHedgeMaze(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hill1) {
            return new ComponentTFHollowHill(world, rand, 0, 1, x, y, z);
        }
        if (feature == TFFeature.hill2) {
            return new ComponentTFHollowHill(world, rand, 0, 2, x, y, z);
        }
        if (feature == TFFeature.hill3) {
            return new ComponentTFHollowHill(world, rand, 0, 3, x, y, z);
        }
        if (feature == TFFeature.lichTower) {
            return new ComponentTFTowerMain(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.questGrove) {
            return new ComponentTFQuestGrove(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.hydraLair) {
            return new ComponentTFHydraLair(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.labyrinth) {
            return new ComponentTFMazeRuins(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.darkTower) {
            return new ComponentTFDarkTowerMain(world, rand, 0, x, y - 1, z);
        }
        if (feature == TFFeature.tfStronghold) {
            return new ComponentTFStrongholdEntrance(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.iceTower) {
            return new ComponentTFIceTowerMain(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.mushroomTower) {
            return new ComponentTFMushroomTowerMain(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.yetiCave) {
            return new ComponentTFYetiCave(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.trollCave) {
            return new ComponentTFTrollCaveMain(world, rand, 0, x, y, z);
        }
        if (feature == TFFeature.finalCastle) {
            return new ComponentTFFinalCastleMain(world, rand, 0, x, y, z);
        }
        return null;
    }

    public boolean isSizeableStructure() {
        return this.feature.isStructureEnabled;
    }

    protected void moveToAvgGroundLevel(World world, int x, int z) {
        if (world.getWorldChunkManager() instanceof TFWorldChunkManager) {
            BiomeGenBase biomeAt = world.getBiomeGenForCoords(x, z);
            int offY = (int)((biomeAt.rootHeight + biomeAt.heightVariation) * 8.0f);
            if (biomeAt == TFBiomeBase.darkForest) {
                offY += 4;
            }
            if (offY > 0) {
                this.boundingBox.offset(0, offY, 0);
                for (StructureComponent com : this.getComponents()) {
                    com.getBoundingBox().offset(0, offY, 0);
                }
            }
        }
    }

    private boolean isIntersectingLarger(StructureBoundingBox chunkBB, StructureComponent component) {
        StructureBoundingBox compBB = component.getBoundingBox();
        return compBB.maxX + 1 >= chunkBB.minX && compBB.minX - 1 <= chunkBB.maxX && compBB.maxZ + 1 >= chunkBB.minZ && compBB.minZ - 1 <= chunkBB.maxZ;
    }

    private boolean isShieldable(StructureComponent component) {
        return component.getBoundingBox().maxY <= 32;
    }

    private void addShieldFor(World world, StructureComponent component, List<StructureComponent> otherComponents, StructureBoundingBox chunkBox) {
        StructureBoundingBox shieldBox = new StructureBoundingBox(component.getBoundingBox());
        --shieldBox.minX;
        --shieldBox.minY;
        --shieldBox.minZ;
        ++shieldBox.maxX;
        ++shieldBox.maxY;
        ++shieldBox.maxZ;
        ArrayList<StructureComponent> intersecting = new ArrayList<StructureComponent>();
        for (StructureComponent other : otherComponents) {
            if (other == component || !shieldBox.intersectsWith(other.getBoundingBox())) continue;
            intersecting.add(other);
        }
        for (int x = shieldBox.minX; x <= shieldBox.maxX; ++x) {
            for (int y = shieldBox.minY; y <= shieldBox.maxY; ++y) {
                for (int z = shieldBox.minZ; z <= shieldBox.maxZ; ++z) {
                    if (x != shieldBox.minX && x != shieldBox.maxX && y != shieldBox.minY && y != shieldBox.maxY && z != shieldBox.minZ && z != shieldBox.maxZ || !chunkBox.isVecInside(x, y, z)) continue;
                    boolean notIntersecting = true;
                    for (StructureComponent other : intersecting) {
                        if (!other.getBoundingBox().isVecInside(x, y, z)) continue;
                        notIntersecting = false;
                    }
                    if (!notIntersecting) continue;
                    world.setBlock(x, y, z, TFBlocks.shield, this.calculateShieldMeta(shieldBox, x, y, z), 2);
                }
            }
        }
    }

    private int calculateShieldMeta(StructureBoundingBox shieldBox, int x, int y, int z) {
        int shieldMeta = 0;
        if (x == shieldBox.minX) {
            shieldMeta = 5;
        } else if (x == shieldBox.maxX) {
            shieldMeta = 4;
        }
        if (z == shieldBox.minZ) {
            shieldMeta = 3;
        } else if (z == shieldBox.maxZ) {
            shieldMeta = 2;
        }
        if (y == shieldBox.minY) {
            shieldMeta = 1;
        } else if (y == shieldBox.maxY) {
            shieldMeta = 0;
        }
        return shieldMeta;
    }

    public void func_143022_a(NBTTagCompound tagCompound) {
        super.func_143022_a(tagCompound);
        tagCompound.setBoolean("Conquered", this.isConquered);
        tagCompound.setInteger("FeatureID", this.feature.featureID);
        tagCompound.setByteArray("Locks", this.lockBytes);
    }

    public void func_143017_b(NBTTagCompound tagCompound) {
        super.func_143017_b(tagCompound);
        this.isConquered = tagCompound.getBoolean("Conquered");
        this.feature = TFFeature.featureList[tagCompound.getInteger("FeatureID")];
        this.lockBytes = tagCompound.getByteArray("Locks");
    }

    public boolean isLocked(int lockIndex) {
        if (lockIndex < this.lockBytes.length) {
            System.out.println("Checking locks for lockIndex " + lockIndex);
            for (int i = 0; i < this.lockBytes.length; ++i) {
                System.out.println("Lock " + i + " = " + this.lockBytes[i]);
            }
            return this.lockBytes[lockIndex] != 0;
        }
        System.out.println("Current lock index, " + lockIndex + " is beyond array bounds " + this.lockBytes.length);
        return false;
    }

    static {
        MapGenStructureIO.registerStructure(StructureTFMajorFeatureStart.class, (String)"TFFeature");
        MapGenStructureIO.registerStructure(StructureTFHollowTreeStart.class, (String)"TFHollowTree");
        TFStrongholdPieces.registerPieces();
        TFMinotaurMazePieces.registerPieces();
        TFDarkTowerPieces.registerPieces();
        TFLichTowerPieces.registerPieces();
        TFIceTowerPieces.registerPieces();
        TFMushroomTowerPieces.registerPieces();
        TFHollowTreePieces.registerPieces();
        TFTrollCavePieces.registerPieces();
        TFFinalCastlePieces.registerFinalCastlePieces();
        MapGenStructureIO.func_143031_a(ComponentTFHedgeMaze.class, (String)"TFHedge");
        MapGenStructureIO.func_143031_a(ComponentTFHillMaze.class, (String)"TFHillMaze");
        MapGenStructureIO.func_143031_a(ComponentTFHollowHill.class, (String)"TFHill");
        MapGenStructureIO.func_143031_a(ComponentTFHydraLair.class, (String)"TFHydra");
        MapGenStructureIO.func_143031_a(ComponentTFNagaCourtyard.class, (String)"TFNaga");
        MapGenStructureIO.func_143031_a(ComponentTFQuestGrove.class, (String)"TFQuest1");
        MapGenStructureIO.func_143031_a(ComponentTFYetiCave.class, (String)"TFYeti");
    }
}

