/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.entity.boss.EntityTFYetiAlpha;
import twilightforest.structures.ComponentTFHollowHill;
import twilightforest.world.TFWorld;

public class ComponentTFYetiCave
extends ComponentTFHollowHill {
    private boolean yetiPlaced;

    public ComponentTFYetiCave() {
    }

    public ComponentTFYetiCave(World world, Random rand, int i, int x, int y, int z) {
        super(world, rand, i, 2, x, y + 2, z);
    }

    @Override
    boolean isInHill(int cx, int cz) {
        return cx < this.radius * 2 && cx > 0 && cz < this.radius * 2 && cz > 0;
    }

    @Override
    boolean isInHill(int mapX, int mapY, int mapZ) {
        return mapX < this.radius * 2 && mapX > 0 && mapZ < this.radius * 2 && mapZ > 0 && mapY > TFWorld.SEALEVEL && mapY < TFWorld.SEALEVEL + 20;
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        int bz;
        int by;
        int bx;
        int[] dest;
        int i;
        int sn = 128;
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.stone, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.ice, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.packed_ice, 0.9f, true, dest[0], 1, dest[1], sbb);
        }
        if (!this.yetiPlaced && sbb.isVecInside(bx = this.getXWithOffset(this.radius, this.radius), by = this.getYWithOffset(0), bz = this.getZWithOffset(this.radius, this.radius))) {
            this.yetiPlaced = true;
            EntityTFYetiAlpha yeti = new EntityTFYetiAlpha(world);
            yeti.setPosition(bx, by, bz);
            yeti.setHomeArea(bx, by, bz, 30);
            world.spawnEntityInWorld((Entity)yeti);
        }
        return true;
    }
}

