/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;

public class ComponentTFNagaCourtyard
extends StructureTFComponent {
    static int RADIUS = 46;
    static int DIAMETER = 2 * RADIUS + 1;

    public ComponentTFNagaCourtyard() {
    }

    public ComponentTFNagaCourtyard(World world, Random rand, int i, int x, int y, int z) {
        super(i);
        this.setCoordBaseMode(0);
        this.boundingBox = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -RADIUS, -1, -RADIUS, RADIUS * 2, 10, RADIUS * 2, 0);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        int fx;
        for (fx = 0; fx <= DIAMETER; ++fx) {
            for (int fz = 0; fz <= DIAMETER; ++fz) {
                if (rand.nextInt(3) == 0) {
                    this.placeBlockAtCurrentPosition(world, (Block)Blocks.double_stone_slab, 0, fx, 0, fz, sbb);
                    if (rand.nextInt(20) == 0) {
                        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, fx, 1, fz, sbb);
                        continue;
                    }
                    this.placeBlockAtCurrentPosition(world, Blocks.air, 0, fx, 1, fz, sbb);
                    continue;
                }
                this.placeBlockAtCurrentPosition(world, (Block)Blocks.grass, 0, fx, 0, fz, sbb);
            }
        }
        block26: for (fx = 0; fx <= DIAMETER; ++fx) {
            this.randomBrick(world, rand, fx, 0, DIAMETER, sbb);
            this.randomBrick(world, rand, fx, 0, 0, sbb);
            this.randomBrick(world, rand, fx, 1, DIAMETER, sbb);
            this.randomBrick(world, rand, fx, 1, 0, sbb);
            this.randomBrick(world, rand, fx, 2, DIAMETER, sbb);
            this.randomBrick(world, rand, fx, 2, 0, sbb);
            this.randomBrick(world, rand, fx, 3, DIAMETER, sbb);
            this.randomBrick(world, rand, fx, 3, 0, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 5, fx, 4, DIAMETER, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 5, fx, 4, 0, sbb);
            switch (fx % 23) {
                case 2: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 11, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 11, fx, 1, 0, sbb);
                    continue block26;
                }
                case 3: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 3, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 3, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, 0, sbb);
                    continue block26;
                }
                case 4: 
                case 8: 
                case 16: 
                case 20: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, 0, sbb);
                    continue block26;
                }
                case 5: 
                case 9: 
                case 17: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 10, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 10, fx, 1, 0, sbb);
                    continue block26;
                }
                case 6: 
                case 10: 
                case 14: 
                case 18: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 3, 0, sbb);
                    continue block26;
                }
                case 7: 
                case 15: 
                case 19: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 11, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 11, fx, 1, 0, sbb);
                    continue block26;
                }
                case 11: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 1, 0, sbb);
                    continue block26;
                }
                case 13: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 7, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 1, 0, sbb);
                    continue block26;
                }
                case 21: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 2, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 2, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 12, fx, 1, 0, sbb);
                    continue block26;
                }
                case 22: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 6, fx, 3, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, fx, 2, 0, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 10, fx, 1, DIAMETER, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 10, fx, 1, 0, sbb);
                }
            }
        }
        block27: for (int fz = 0; fz <= DIAMETER; ++fz) {
            this.randomBrick(world, rand, DIAMETER, 0, fz, sbb);
            this.randomBrick(world, rand, 0, 0, fz, sbb);
            this.randomBrick(world, rand, DIAMETER, 1, fz, sbb);
            this.randomBrick(world, rand, 0, 1, fz, sbb);
            this.randomBrick(world, rand, DIAMETER, 2, fz, sbb);
            this.randomBrick(world, rand, 0, 2, fz, sbb);
            this.randomBrick(world, rand, DIAMETER, 3, fz, sbb);
            this.randomBrick(world, rand, 0, 3, fz, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 5, DIAMETER, 4, fz, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 5, 0, 4, fz, sbb);
            switch (fz % 23) {
                case 2: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 9, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 9, 0, 1, fz, sbb);
                    continue block27;
                }
                case 3: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 1, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 1, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, 0, 1, fz, sbb);
                    continue block27;
                }
                case 4: 
                case 8: 
                case 16: 
                case 20: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, 0, 1, fz, sbb);
                    continue block27;
                }
                case 5: 
                case 9: 
                case 17: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 8, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 8, 0, 1, fz, sbb);
                    continue block27;
                }
                case 6: 
                case 10: 
                case 14: 
                case 18: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, 0, 3, fz, sbb);
                    continue block27;
                }
                case 7: 
                case 15: 
                case 19: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 9, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 9, 0, 1, fz, sbb);
                    continue block27;
                }
                case 11: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 1, fz, sbb);
                    continue block27;
                }
                case 13: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 5, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 1, fz, sbb);
                    continue block27;
                }
                case 21: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 0, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 0, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 13, 0, 1, fz, sbb);
                    continue block27;
                }
                case 22: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, DIAMETER, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 4, 0, 3, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, DIAMETER, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 14, 0, 2, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 8, DIAMETER, 1, fz, sbb);
                    this.placeBlockAtCurrentPosition(world, TFBlocks.nagastone, 8, 0, 1, fz, sbb);
                }
            }
        }
        Random pillarRand = new Random(world.getSeed() + (long)(this.boundingBox.minX * this.boundingBox.minZ));
        for (int i = 0; i < 20; ++i) {
            int rx = 2 + pillarRand.nextInt(DIAMETER - 4);
            int rz = 2 + pillarRand.nextInt(DIAMETER - 4);
            this.makePillar(world, pillarRand, rx, 1, rz, sbb);
        }
        this.placeBlockAtCurrentPosition(world, TFBlocks.bossSpawner, 0, RADIUS + 1, 2, RADIUS + 1, sbb);
        return true;
    }

    public boolean makePillar(World world, Random rand, int x, int y, int z, StructureBoundingBox sbb) {
        int height = 8;
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 0, z - 1, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 0, y + 0, z - 1, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 0, z - 1, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 0, z + 0, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 0, z + 0, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 0, z + 1, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 0, y + 0, z + 1, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 0, z + 1, sbb);
        block12: for (int i = 0; i < height; ++i) {
            this.randomBrick(world, rand, x, y + i, z, sbb);
            if (i > 0 && rand.nextInt(2) == 0) {
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.placeBlockAtCurrentPosition(world, Blocks.vine, 8, x - 1, y + i, z + 0, sbb);
                        break;
                    }
                    case 1: {
                        this.placeBlockAtCurrentPosition(world, Blocks.vine, 2, x + 1, y + i, z + 0, sbb);
                        break;
                    }
                    case 2: {
                        this.placeBlockAtCurrentPosition(world, Blocks.vine, 4, x + 0, y + i, z + 1, sbb);
                        break;
                    }
                    case 3: {
                        this.placeBlockAtCurrentPosition(world, Blocks.vine, 1, x + 0, y + i, z - 1, sbb);
                    }
                }
                continue;
            }
            if (i <= 0 || rand.nextInt(4) != 0) continue;
            switch (rand.nextInt(4)) {
                case 0: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.firefly, 0, x - 1, y + i, z + 0, sbb);
                    continue block12;
                }
                case 1: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.firefly, 0, x + 1, y + i, z + 0, sbb);
                    continue block12;
                }
                case 2: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.firefly, 0, x + 0, y + i, z + 1, sbb);
                    continue block12;
                }
                case 3: {
                    this.placeBlockAtCurrentPosition(world, TFBlocks.firefly, 0, x + 0, y + i, z - 1, sbb);
                }
            }
        }
        if (height == 8) {
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 8, z - 1, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 0, y + 8, z - 1, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 8, z - 1, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 8, z + 0, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 5, x + 0, y + 8, z + 0, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 8, z + 0, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x - 1, y + 8, z + 1, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 0, y + 8, z + 1, sbb);
            this.placeBlockAtCurrentPosition(world, (Block)Blocks.stone_slab, 0, x + 1, y + 8, z + 1, sbb);
        }
        return true;
    }

    public void randomBrick(World world, Random rand, int x, int y, int z, StructureBoundingBox sbb) {
        this.placeBlockAtCurrentPosition(world, Blocks.stonebrick, rand.nextInt(3), x, y, z, sbb);
    }
}

