/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.TFMaze;

public class ComponentTFHedgeMaze
extends StructureTFComponent {
    static int MSIZE = 16;
    static int RADIUS = MSIZE / 2 * 3 + 1;
    static int DIAMETER = 2 * RADIUS;
    static int FLOOR_LEVEL = 3;

    public ComponentTFHedgeMaze() {
    }

    public ComponentTFHedgeMaze(World world, Random rand, int i, int x, int y, int z) {
        super(i);
        this.setCoordBaseMode(0);
        this.boundingBox = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -RADIUS, -3, -RADIUS, RADIUS * 2, 10, RADIUS * 2, 0);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        TFMaze maze = new TFMaze(MSIZE, MSIZE);
        maze.oddBias = 2;
        maze.torchBlockID = TFBlocks.firefly;
        maze.wallBlockID = TFBlocks.hedge;
        maze.wallBlockMeta = 0;
        maze.type = 4;
        maze.tall = 3;
        maze.roots = 3;
        maze.setSeed(world.getSeed() + (long)(this.boundingBox.minX * this.boundingBox.minZ));
        for (int fx = 0; fx <= DIAMETER; ++fx) {
            for (int fz = 0; fz <= DIAMETER; ++fz) {
                this.placeBlockAtCurrentPosition(world, (Block)Blocks.grass, 0, fx, FLOOR_LEVEL - 1, fz, sbb);
            }
        }
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 1, 0, FLOOR_LEVEL, 24, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 1, 0, FLOOR_LEVEL, 29, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 3, 50, FLOOR_LEVEL, 24, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 3, 50, FLOOR_LEVEL, 29, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 2, 24, FLOOR_LEVEL, 0, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 2, 29, FLOOR_LEVEL, 0, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 0, 24, FLOOR_LEVEL, 50, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, 0, 29, FLOOR_LEVEL, 50, sbb);
        int nrooms = MSIZE / 3;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = maze.rand.nextInt(MSIZE - 2) + 1, rz = maze.rand.nextInt(MSIZE - 2) + 1, rcoords)) {
            }
            maze.carveRoom1(rx, rz);
            rcoords[i * 2] = rx;
            rcoords[i * 2 + 1] = rz;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, 1, FLOOR_LEVEL, 1, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
        return true;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= 3 || Math.abs(dz - rz) >= 3) continue;
            return true;
        }
        return false;
    }

    void decorate3x3Rooms(World world, int[] rcoords, StructureBoundingBox sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz = rcoords[i * 2 + 1];
            dx = dx * 3 + 3;
            dz = dz * 3 + 3;
            this.decorate3x3Room(world, dx, dz, sbb);
        }
    }

    void decorate3x3Room(World world, int x, int z, StructureBoundingBox sbb) {
        Random roomRNG = new Random(world.getSeed() ^ (long)(x + z));
        this.roomJackO(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomJackO(world, roomRNG, x, z, 8, sbb);
        }
        this.roomSpawner(world, roomRNG, x, z, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        }
    }

    private void roomSpawner(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        String mobID;
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        switch (rand.nextInt(3)) {
            case 1: {
                mobID = TFCreatures.getSpawnerNameFor("Swarm Spider");
                break;
            }
            case 2: {
                mobID = TFCreatures.getSpawnerNameFor("Hostile Wolf");
                break;
            }
            default: {
                mobID = TFCreatures.getSpawnerNameFor("Hedge Spider");
            }
        }
        this.placeSpawnerAtCurrentPosition(world, rand, rx, FLOOR_LEVEL, rz, mobID, sbb);
    }

    private void roomTreasure(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rand, rx, FLOOR_LEVEL, rz, TFTreasure.hedgemaze, sbb);
    }

    private void roomJackO(World world, Random rand, int x, int z, int diameter, StructureBoundingBox sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.placeBlockAtCurrentPosition(world, Blocks.lit_pumpkin, rand.nextInt(4), rx, FLOOR_LEVEL, rz, sbb);
    }
}

