/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFLoyalZombie;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFZombieWand
extends ItemTF {
    protected ItemTFZombieWand() {
        this.maxStackSize = 1;
        this.setMaxDamage(9);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World worldObj, EntityPlayer player) {
        if (par1ItemStack.getItemDamage() < this.getMaxDamage()) {
            MovingObjectPosition mop;
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
            if (!worldObj.isRemote && (mop = this.getPlayerPointVec(worldObj, player, 20.0f)) != null) {
                EntityTFLoyalZombie zombie = new EntityTFLoyalZombie(worldObj);
                zombie.setPositionAndRotation(mop.hitVec.xCoord, mop.hitVec.yCoord, mop.hitVec.zCoord, 1.0f, 1.0f);
                zombie.setTamed(true);
                try {
                    zombie.func_152115_b(player.getUniqueID().toString());
                }
                catch (NoSuchMethodError ex) {
                    FMLLog.warning((String)"[TwilightForest] Could not determine player name for loyal zombie, ignoring error.", (Object[])new Object[0]);
                }
                zombie.addPotionEffect(new PotionEffect(Potion.damageBoost.id, 1200, 1));
                worldObj.spawnEntityInWorld((Entity)zombie);
                par1ItemStack.damageItem(1, (EntityLivingBase)player);
            }
        } else {
            player.stopUsingItem();
        }
        return par1ItemStack;
    }

    private MovingObjectPosition getPlayerPointVec(World worldObj, EntityPlayer player, float range) {
        Vec3 position = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 look = player.getLook(1.0f);
        Vec3 dest = position.addVector(look.xCoord * (double)range, look.yCoord * (double)range, look.zCoord * (double)range);
        return worldObj.rayTraceBlocks(position, dest);
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 30;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(par1ItemStack.getMaxDamage() - par1ItemStack.getItemDamage() + " charges left");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

