/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFTwilightWandBolt;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFTwilightWand
extends ItemTF {
    protected ItemTFTwilightWand() {
        this.maxStackSize = 1;
        this.setMaxDamage(99);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World worldObj, EntityPlayer player) {
        if (par1ItemStack.getItemDamage() < this.getMaxDamage()) {
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        } else {
            player.stopUsingItem();
        }
        return par1ItemStack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (stack.getItemDamage() >= this.getMaxDamage()) {
            player.stopUsingItem();
            return;
        }
        if (count % 6 == 0) {
            World worldObj = player.worldObj;
            worldObj.playSoundAtEntity((Entity)player, "mob.ghast.fireball", 1.0f, (worldObj.rand.nextFloat() - worldObj.rand.nextFloat()) * 0.2f + 1.0f);
            if (!worldObj.isRemote) {
                worldObj.spawnEntityInWorld((Entity)new EntityTFTwilightWandBolt(worldObj, (EntityLivingBase)player));
                stack.damageItem(1, (EntityLivingBase)player);
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add(par1ItemStack.getMaxDamage() - par1ItemStack.getItemDamage() + " charges left");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

